/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain;
import org.eclipse.ocl.pivot.internal.ecore.EcoreASResourceFactory;
import org.eclipse.ocl.pivot.internal.resource.OCLASResourceFactory;
import org.eclipse.ocl.pivot.internal.scoping.PivotScoping;
import org.eclipse.ocl.pivot.internal.validation.PivotEAnnotationValidator;
import org.eclipse.ocl.pivot.labels.ILabelGenerator;
import org.eclipse.ocl.pivot.labels.LabelGeneratorRegistry;
import org.eclipse.ocl.pivot.model.OCLmetamodel;
import org.eclipse.ocl.pivot.model.OCLstdlib;
import org.eclipse.ocl.pivot.util.PivotValidator;
import org.eclipse.ocl.pivot.utilities.ToStringVisitor;

public class PivotStandaloneSetup {
    private static Injector injector = null;

    public static void doSetup() {
        if (injector == null) {
            new PivotStandaloneSetup().createInjectorAndDoEMFRegistration();
        }
    }

    public static void doTearDown() {
        injector = null;
    }

    public static void init() {
        OCLDelegateDomain.lazyInitializeGlobals("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", false);
        OCLASResourceFactory theOCLASResourceFactory = OCLASResourceFactory.getInstance();
        OCLstdlib.lazyInstall();
        OCLmetamodel.lazyInstall();
        EcoreASResourceFactory.getInstance();
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("oclas", theOCLASResourceFactory);
            PivotEAnnotationValidator.initializePivotEAnnotationValidators();
        }
        EcorePackage.eINSTANCE.getClass();
        PivotScoping.init();
        ToStringVisitor.FACTORY.getClass();
        EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/ocl/2015/Pivot", (Object)PivotPackage.eINSTANCE);
        EValidator.Registry.INSTANCE.put((Object)PivotPackage.eINSTANCE, (Object)PivotValidator.INSTANCE);
        LabelGeneratorRegistry.initialize(ILabelGenerator.Registry.INSTANCE);
    }

    public static final Injector getInjector() {
        return injector;
    }

    public Injector createInjector() {
        String defaultExtension;
        Map extensionToFactoryMap = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        if (extensionToFactoryMap.containsKey("xmi")) {
            extensionToFactoryMap.remove("xmi");
        }
        if (!extensionToFactoryMap.containsKey(defaultExtension = "*")) {
            extensionToFactoryMap.put(defaultExtension, new XMIResourceFactoryImpl());
        }
        injector = Guice.createInjector((Module[])new Module[0]);
        return injector;
    }

    public Injector createInjectorAndDoEMFRegistration() {
        PivotStandaloneSetup.init();
        if (!Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("ecore")) {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
        }
        if (!Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().containsKey("xmi")) {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
        }
        if (!EPackage.Registry.INSTANCE.containsKey((Object)"http://www.eclipse.org/ocl/2015/Pivot")) {
            EPackage.Registry.INSTANCE.put((Object)"http://www.eclipse.org/ocl/2015/Pivot", (Object)PivotPackage.eINSTANCE);
        }
        Injector injector = this.createInjector();
        this.register(injector);
        return injector;
    }

    public void register(Injector injector) {
    }
}

