/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.equinox.security.ui.storage;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.equinox.internal.security.ui.storage.ChangePasswordWizardDialog;
import org.eclipse.reddeer.eclipse.equinox.internal.security.ui.storage.PasswordRecoveryDialog;
import org.eclipse.reddeer.eclipse.equinox.security.ui.storage.PasswordProvider;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.swt.api.Control;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.swt.api.Tree;
import org.eclipse.reddeer.swt.condition.ControlIsEnabled;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.combo.DefaultCombo;
import org.eclipse.reddeer.swt.impl.tab.DefaultTabItem;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.swt.impl.text.LabeledText;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.swt.impl.tree.DefaultTreeItem;
import org.hamcrest.Matcher;

public class StoragePreferencePage
extends PreferencePage {
    public StoragePreferencePage(ReferencedComposite referencedComposite) {
        super(referencedComposite, new String[]{"General", "Security", "Secure Storage"});
    }

    public StoragePreferencePage selectPasswordsTab() {
        new DefaultTabItem((ReferencedComposite)this, "Password").activate();
        return this;
    }

    public StoragePreferencePage selectContentTab() {
        new DefaultTabItem((ReferencedComposite)this, "Contents").activate();
        return this;
    }

    public StoragePreferencePage selectAdvancedTab() {
        new DefaultTabItem((ReferencedComposite)this, "Advanced").activate();
        return this;
    }

    public List<PasswordProvider> getMasterPasswordProviders() {
        ArrayList<PasswordProvider> providers = new ArrayList<PasswordProvider>();
        for (TableItem item : new DefaultTable((ReferencedComposite)this).getItems()) {
            providers.add(new PasswordProvider(item));
        }
        return providers;
    }

    public PasswordRecoveryDialog recoverMasterPassword() {
        new PushButton((ReferencedComposite)this, "Recover Password...").click();
        return new PasswordRecoveryDialog();
    }

    public ChangePasswordWizardDialog changeMasterPassword() {
        new PushButton((ReferencedComposite)this, "Change Password...").click();
        return new ChangePasswordWizardDialog();
    }

    public boolean clearCachedPasswords() {
        try {
            new WaitUntil((WaitCondition)new ControlIsEnabled((Control)new PushButton((ReferencedComposite)this, "Clear Passwords")));
            new PushButton((ReferencedComposite)this, "Clear Passwords").click();
            return true;
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            return false;
        }
    }

    public boolean passwordExists(String ... pathToPassword) {
        this.selectContentTab();
        new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)this, 1, new Matcher[0]), pathToPassword).select();
        this.selectContentTab();
        return new DefaultTable((ReferencedComposite)this).getItems().size() > 0;
    }

    public Properties getPasswordsByPath(String ... pathToPasswords) {
        this.selectContentTab();
        new DefaultTreeItem((Tree)new DefaultTree((ReferencedComposite)this, 1, new Matcher[0]), pathToPasswords).select();
        this.selectContentTab();
        return this.getPasswordsFromTable(new DefaultTable((ReferencedComposite)this));
    }

    public String getStorageLocation() {
        this.selectContentTab();
        return new LabeledText((ReferencedComposite)this, "Storage location:").getText();
    }

    private Properties getPasswordsFromTable(DefaultTable table) {
        Properties props = new Properties();
        for (TableItem item : table.getItems()) {
            String id = item.getText(0);
            String value = item.getText(1);
            props.put(id, value);
        }
        return props;
    }

    public List<String> getAvailableEncryptionAlgorithms() {
        this.selectAdvancedTab();
        return new DefaultCombo((ReferencedComposite)this).getItems();
    }

    public String getEncryptionAlgorithm() {
        this.selectAdvancedTab();
        return new DefaultCombo((ReferencedComposite)this).getSelection();
    }

    public void setEncryptionAlgorithm(String algorithmName) {
        this.selectAdvancedTab();
        if (!this.getAvailableEncryptionAlgorithms().contains(algorithmName)) {
            throw new EclipseLayerException("Algorithm " + algorithmName + " not found!");
        }
        new DefaultCombo((ReferencedComposite)this).setSelection(algorithmName);
    }
}

