/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model.decorate;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.wb.internal.core.databinding.ui.decorate.IObserveDecorator;

public final class BeanDecorationInfo {
    private final BeanDecorationInfo m_parent;
    private Set<String> m_preferred = Collections.emptySet();
    private Set<String> m_advanced = Collections.emptySet();
    private Set<String> m_hidden = Collections.emptySet();

    public BeanDecorationInfo(BeanDecorationInfo parent) {
        this.m_parent = parent;
    }

    void setPreferredProperties(String[] properties) {
        if (!ArrayUtils.isEmpty((Object[])properties)) {
            this.m_preferred = Sets.newHashSet((Object[])properties);
        }
    }

    void setAdvancedProperties(String[] properties) {
        if (!ArrayUtils.isEmpty((Object[])properties)) {
            this.m_advanced = Sets.newHashSet((Object[])properties);
        }
    }

    void setHiddenProperties(String[] properties) {
        if (!ArrayUtils.isEmpty((Object[])properties)) {
            this.m_hidden = Sets.newHashSet((Object[])properties);
        }
    }

    public IObserveDecorator getDecorator(String propertyName) {
        if (this.m_preferred.contains(propertyName)) {
            return IObserveDecorator.BOLD;
        }
        if (this.m_advanced.contains(propertyName)) {
            return IObserveDecorator.ITALIC;
        }
        if (this.m_hidden.contains(propertyName)) {
            return IObserveDecorator.HIDDEN;
        }
        if (this.m_parent != null) {
            return this.m_parent.getDecorator(propertyName);
        }
        return IObserveDecorator.DEFAULT;
    }
}

