/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.internal.ui.scriptview.ScriptExplorerPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;

public class WorkingSetDetector {
    private static final IWorkingSet[] EMPTY_WORKING_SET_ARRAY = new IWorkingSet[0];

    public IWorkingSet[] detect(IStructuredSelection selection, IWorkbench workbench) {
        IWorkingSet[] selected = this.getSelectedWorkingSet(selection);
        if (selected != null && selected.length > 0) {
            int i = 0;
            while (i < selected.length) {
                if (!this.isValidWorkingSet(selected[i])) {
                    return EMPTY_WORKING_SET_ARRAY;
                }
                ++i;
            }
            return selected;
        }
        IWorkbenchPart activePart = this.getActivePart(workbench);
        if (!(activePart instanceof ScriptExplorerPart)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        ScriptExplorerPart explorerPart = (ScriptExplorerPart)activePart;
        if (explorerPart.getRootMode() == 1) {
            IWorkingSet filterWorkingSet = explorerPart.getFilterWorkingSet();
            if (filterWorkingSet == null) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            if (!this.isValidWorkingSet(filterWorkingSet)) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            return new IWorkingSet[]{filterWorkingSet};
        }
        Object input = explorerPart.getViewPartInput();
        if (!(input instanceof IWorkingSet)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        IWorkingSet workingSet = (IWorkingSet)input;
        if (!this.isValidWorkingSet(workingSet)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        return new IWorkingSet[]{workingSet};
    }

    private IWorkbenchPart getActivePart(IWorkbench workbench) {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
        if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null) {
            return activePage.getActivePart();
        }
        return null;
    }

    private IWorkingSet[] getSelectedWorkingSet(IStructuredSelection selection) {
        if (!(selection instanceof ITreeSelection)) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        ITreeSelection treeSelection = (ITreeSelection)selection;
        if (treeSelection.isEmpty()) {
            return EMPTY_WORKING_SET_ARRAY;
        }
        List elements = treeSelection.toList();
        if (elements.size() == 1) {
            Object element = elements.get(0);
            TreePath[] paths = treeSelection.getPathsFor(element);
            if (paths.length != 1) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            TreePath path = paths[0];
            if (path.getSegmentCount() == 0) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            Object candidate = path.getSegment(0);
            if (!(candidate instanceof IWorkingSet)) {
                return EMPTY_WORKING_SET_ARRAY;
            }
            IWorkingSet workingSetCandidate = (IWorkingSet)candidate;
            if (this.isValidWorkingSet(workingSetCandidate)) {
                return new IWorkingSet[]{workingSetCandidate};
            }
            return EMPTY_WORKING_SET_ARRAY;
        }
        ArrayList<IWorkingSet> result = new ArrayList<IWorkingSet>();
        for (Object element : elements) {
            IWorkingSet ws;
            if (!(element instanceof IWorkingSet) || !this.isValidWorkingSet(ws = (IWorkingSet)element)) continue;
            result.add(ws);
        }
        return result.toArray(new IWorkingSet[result.size()]);
    }

    protected boolean isValidWorkingSet(IWorkingSet workingSet) {
        String id = workingSet.getId();
        if (!"org.eclipse.dltk.ui.ScriptWorkingSetPage".equals(id) && !"org.eclipse.ui.resourceWorkingSetPage".equals(id)) {
            return false;
        }
        return !workingSet.isAggregateWorkingSet();
    }
}

