/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.figures;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.diagram.ui.figures.ICanonicalShapeCompartmentLayout;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;

public class LayoutHelper {
    public static final Rectangle UNDEFINED = new Rectangle(-1, -1, -1, -1);

    public void layoutUndefinedChildren(ICanonicalShapeCompartmentLayout mgr, IFigure parent, Map registry) {
        List children = this.getUnpositionedChildren(parent);
        if (!children.isEmpty()) {
            int i = 0;
            while (i < children.size()) {
                IFigure child = (IFigure)children.get(i);
                Point loc = this.getReferencePosition(parent);
                loc = this.validatePosition(parent, new Rectangle(loc, child.getSize()));
                child.setLocation(loc);
                parent.getLayoutManager().setConstraint(child, (Object)child.getBounds());
                ++i;
            }
        }
    }

    public final List getUnpositionedChildren(IFigure parent) {
        List children = parent.getChildren();
        ArrayList<IFigure> retval = new ArrayList<IFigure>();
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            if (UNDEFINED.getLocation().equals((Object)child.getBounds().getLocation())) {
                retval.add(child);
            }
            ++i;
        }
        return retval;
    }

    public Point getReferencePosition(IFigure parent) {
        return parent.getBounds().getCenter().getCopy();
    }

    public Point validatePosition(IFigure parent, Rectangle bounds) {
        Rectangle theBounds = bounds.getCopy();
        IFigure clobber = this.findFigureIn(parent, bounds);
        if (clobber != null) {
            theBounds.setLocation(this.updateClobberedPosition(clobber, null));
            return this.validatePosition(parent, theBounds);
        }
        return theBounds.getLocation();
    }

    public IFigure findFigureIn(IFigure parent, Rectangle bounds) {
        ListIterator listIterator = parent.getChildren().listIterator();
        boolean useContainCheck = UNDEFINED.getSize().equals((Object)bounds.getSize());
        while (listIterator.hasNext()) {
            IFigure child = (IFigure)listIterator.next();
            Rectangle cBounds = child.getBounds();
            if (UNDEFINED.getLocation().equals((Object)cBounds.getLocation()) || !(useContainCheck ? cBounds.contains(bounds.getLocation()) : cBounds.intersects(bounds))) continue;
            return child;
        }
        return null;
    }

    public Point updateClobberedPosition(IFigure clobbered, IFigure newlyAddedChild) {
        return clobbered.getBounds().getRight().getCopy().translate(MapModeUtil.getMapMode((IFigure)clobbered).DPtoLP(30), 0);
    }
}

