/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.linuxtools.internal.rpm.ui.editor.RpmMacroOccurrencesUpdater;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileConfiguration;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileDocumentProvider;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.internal.rpm.ui.editor.outline.SpecfileContentOutlinePage;
import org.eclipse.linuxtools.rpm.ui.editor.markers.SpecfileErrorHandler;
import org.eclipse.linuxtools.rpm.ui.editor.markers.SpecfileTaskHandler;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileParser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class SpecfileEditor
extends TextEditor {
    private SpecfileContentOutlinePage outlinePage;
    private IEditorInput input;
    private Specfile specfile;
    private SpecfileParser parser = this.getParser();
    private RpmMacroOccurrencesUpdater fOccurrencesUpdater;
    private ProjectionSupport projectionSupport;
    private static SpecfileDocumentProvider fDocumentProvider;

    public SpecfileEditor() {
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new SpecfileConfiguration(this));
        this.setKeyBindingScopes(new String[]{"org.eclipse.linuxtools.rpm.ui.specEditorScope"});
    }

    public void dispose() {
        this.specfile = null;
        super.dispose();
    }

    protected void doSetInput(IEditorInput newInput) throws CoreException {
        super.doSetInput(newInput);
        this.input = newInput;
        if (this.outlinePage != null) {
            this.outlinePage.setInput(this.input);
        }
        this.validateAndMark();
    }

    protected void editorSaved() {
        super.editorSaved();
        this.validateAndMark();
        if (this.outlinePage != null) {
            this.outlinePage.update();
        }
    }

    protected void validateAndMark() {
        try {
            IDocument document = this.getDocumentProvider().getDocument((Object)this.input);
            SpecfileErrorHandler specfileErrorHandler = new SpecfileErrorHandler(this.getEditorInput(), document);
            specfileErrorHandler.removeExistingMarkers();
            SpecfileTaskHandler specfileTaskHandler = new SpecfileTaskHandler(this.getInputFile(), document);
            specfileTaskHandler.removeExistingMarkers();
            this.parser.setErrorHandler(specfileErrorHandler);
            this.parser.setTaskHandler(specfileTaskHandler);
            this.specfile = this.parser.parse(document);
        }
        catch (Exception e) {
            SpecfileLog.logError(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected IFile getInputFile() {
        IEditorInput iEditorInput = this.input;
        if (iEditorInput instanceof IFileEditorInput var1_2) {
            void ife;
            return ife.getFile();
        }
        return null;
    }

    public <T> T getAdapter(Class<T> required) {
        Object adapter;
        if (IContentOutlinePage.class.equals(required)) {
            return (T)this.getOutlinePage();
        }
        if (IDocument.class.equals(required)) {
            return (T)this.getDocumentProvider().getDocument((Object)this.input);
        }
        if (this.projectionSupport != null && (adapter = this.projectionSupport.getAdapter(this.getSourceViewer(), required)) != null) {
            return (T)adapter;
        }
        return (T)super.getAdapter(required);
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.createAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.fOverviewRuler, true, styles);
        this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        return viewer;
    }

    private ContentOutlinePage getOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = new SpecfileContentOutlinePage((ITextEditor)this);
            if (this.getEditorInput() != null) {
                this.outlinePage.setInput(this.getEditorInput());
            }
        }
        return this.outlinePage;
    }

    public Specfile getSpecfile() {
        return this.specfile;
    }

    protected void setDocumentProvider(IEditorInput input) {
        this.setDocumentProvider((IDocumentProvider)SpecfileEditor.getSpecfileDocumentProvider());
    }

    public static TextFileDocumentProvider getSpecfileDocumentProvider() {
        if (fDocumentProvider == null) {
            fDocumentProvider = new SpecfileDocumentProvider();
        }
        return fDocumentProvider;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer projectionViewer = (ProjectionViewer)this.getSourceViewer();
        this.projectionSupport = new ProjectionSupport(projectionViewer, this.getAnnotationAccess(), this.getSharedColors());
        this.projectionSupport.install();
        projectionViewer.doOperation(19);
        this.fOccurrencesUpdater = new RpmMacroOccurrencesUpdater(this);
    }

    public void setSpecfile(Specfile specfile) {
        Shell shell;
        this.specfile = specfile;
        if (this.fOccurrencesUpdater != null && (shell = this.getSite().getShell()) != null && !shell.isDisposed()) {
            shell.getDisplay().asyncExec(() -> {
                ISourceViewer viewer = this.getSourceViewer();
                if (viewer != null) {
                    this.fOccurrencesUpdater.update(viewer);
                }
            });
        }
    }

    public final SpecfileParser getParser() {
        if (this.parser == null) {
            this.parser = new SpecfileParser();
        }
        return this.parser;
    }

    public SourceViewer getSpecfileSourceViewer() {
        return (SourceViewer)this.getSourceViewer();
    }
}

