/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.clones;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;

public class ConvertToUnixLineEndings
extends AbstractWorkflowComponent2 {
    private static final String COMPONENT_NAME = "Convert to Unix Line Endings";
    private static final Log LOG = LogFactory.getLog(ConvertToUnixLineEndings.class);
    private String directory;
    private final Collection<String> binaryExtensions = new HashSet<String>();
    private final Collection<String> defaultBinaryExtensions = Arrays.asList("xtextbin");
    private boolean useDefaultBinaryExtensions = true;

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getLogMessage() {
        return "converting directory '" + this.directory + "'";
    }

    protected void invokeInternal(WorkflowContext model, ProgressMonitor monitor, Issues issues) {
        if (this.directory != null) {
            StringTokenizer st = new StringTokenizer(this.directory, ",");
            while (st.hasMoreElements()) {
                String dir = st.nextToken().trim();
                File f = new File(dir);
                if (!f.exists() || !f.isDirectory()) continue;
                LOG.info((Object)("Converting " + f.getAbsolutePath()));
                try {
                    this.cleanFolder(f.getAbsolutePath());
                }
                catch (FileNotFoundException e) {
                    issues.addError(e.getMessage());
                }
            }
        }
    }

    protected void checkConfigurationInternal(Issues issues) {
        if (this.directory == null) {
            issues.addWarning("No directories specified!");
        }
    }

    public void cleanFolder(String srcGenPath) throws FileNotFoundException {
        File f = new File(srcGenPath);
        if (!f.exists()) {
            throw new FileNotFoundException(String.valueOf(srcGenPath) + " " + f.getAbsolutePath());
        }
        LOG.debug((Object)("Converting folder " + f.getPath()));
        this.convertFolder(f, new FileFilter(){

            @Override
            public boolean accept(File path) {
                return !ConvertToUnixLineEndings.this.isBinaryExtension(path);
            }
        }, false);
    }

    public boolean isBinaryExtension(File path) {
        String extension;
        String name = path.getName();
        int index = name.lastIndexOf(46);
        String string = extension = index >= 0 ? name.substring(index + 1) : "";
        if (this.useDefaultBinaryExtensions && this.defaultBinaryExtensions.contains(extension)) {
            return true;
        }
        return this.binaryExtensions.contains(extension);
    }

    public boolean convertFolder(File parentFolder, FileFilter filter, boolean continueOnError) throws FileNotFoundException {
        if (!parentFolder.exists()) {
            throw new FileNotFoundException(parentFolder.getAbsolutePath());
        }
        FileFilter myFilter = filter;
        if (myFilter == null) {
            myFilter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return true;
                }
            };
        }
        LOG.debug((Object)("Converting folder " + parentFolder.toString()));
        File[] contents = parentFolder.listFiles(myFilter);
        int j = 0;
        while (contents != null && j < contents.length) {
            File file = contents[j];
            if (file.isDirectory()) {
                if (!this.convertFolder(file, myFilter, continueOnError) && !continueOnError) {
                    return false;
                }
            } else {
                this.convertFile(file);
            }
            ++j;
        }
        return true;
    }

    private void convertFile(File file) {
        block17: {
            try {
                FileReader reader = new FileReader(file);
                StringBuilder s = new StringBuilder();
                boolean changed = false;
                boolean trimmed = false;
                try {
                    int c;
                    while ((c = ((Reader)reader).read()) >= 0) {
                        if (c == 13) {
                            changed = true;
                            continue;
                        }
                        if (c == 10) {
                            int len = s.length();
                            while (--len >= 0) {
                                char ch = s.charAt(len);
                                if (ch == '\n' || !Character.isWhitespace(ch)) break;
                                s.setLength(len);
                                trimmed = true;
                            }
                            s.append((char)c);
                            continue;
                        }
                        s.append((char)c);
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)("Failed to read '" + file + "'"), (Throwable)e);
                    return;
                }
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {
                    LOG.error((Object)("Failed to close '" + file + "'"), (Throwable)e);
                    return;
                }
                if (!changed && !trimmed) break block17;
                try (FileWriter writer = new FileWriter(file);){
                    try {
                        writer.write(s.toString());
                        ((Writer)writer).flush();
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Failed to write '" + file + "'"), (Throwable)e);
                        ((Writer)writer).close();
                        return;
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)("Failed to re-open '" + file + "'"), (Throwable)e);
                    return;
                }
                LOG.info((Object)(String.valueOf(changed ? "Converted " : "Trimmed ") + file));
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)("Failed to open '" + file + "'"), (Throwable)e);
                return;
            }
        }
    }

    public boolean isUseDefaultBinaryExtensions() {
        return this.useDefaultBinaryExtensions;
    }

    public void setUseDefaultBinaryExtensions(boolean useDefaultBinaryExtensions) {
        this.useDefaultBinaryExtensions = useDefaultBinaryExtensions;
    }

    public void addBinaryExtension(String binaryExtension) {
        this.binaryExtensions.add(binaryExtension);
    }

    public String getComponentName() {
        return COMPONENT_NAME;
    }
}

