/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.gmf.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.emf.gmf.command.ICommandWrapper;
import org.eclipse.papyrus.infra.emf.gmf.command.INonDirtying;

public class GMFtoEMFCommandWrapper
extends AbstractCommand
implements ICommandWrapper<ICommand> {
    private static Function<ICommand, Command> wrapperFunction = GMFtoEMFCommandWrapper::new;
    private static Function<ICommand, Command> ndWrapperFunction = NonDirtying::new;
    private final ICommand gmfCommand;

    public Collection<?> getResult() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.getGMFReturnValue() != null) {
            result.add(this.getGMFReturnValue());
        }
        return result;
    }

    private Object getGMFReturnValue() {
        if (this.getGMFCommand().getCommandResult() != null) {
            return this.getGMFCommand().getCommandResult().getReturnValue();
        }
        return null;
    }

    public GMFtoEMFCommandWrapper(ICommand gmfCommand) {
        super(gmfCommand.getLabel());
        this.gmfCommand = gmfCommand;
    }

    public static Command wrap(ICommand command) {
        if (command instanceof INonDirtying) {
            return ndWrapperFunction.apply(command);
        }
        return wrapperFunction.apply(command);
    }

    public ICommand getGMFCommand() {
        return this.gmfCommand;
    }

    @Override
    public ICommand getWrappedCommand() {
        return this.getGMFCommand();
    }

    public boolean canExecute() {
        return this.gmfCommand.canExecute();
    }

    public void dispose() {
        this.gmfCommand.dispose();
    }

    public boolean canUndo() {
        return this.gmfCommand.canUndo();
    }

    public void execute() {
        try {
            this.gmfCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void redo() {
        try {
            this.gmfCommand.redo((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public void undo() {
        try {
            this.gmfCommand.undo((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    public Collection<?> getAffectedObjects() {
        return this.gmfCommand.getAffectedFiles();
    }

    public String getDescription() {
        return this.gmfCommand.getLabel();
    }

    protected static void setWrapperFunction(Function<ICommand, Command> wrapperFunction) {
        GMFtoEMFCommandWrapper.wrapperFunction = wrapperFunction;
    }

    protected static void setNonDirtyingWrapperFunction(Function<ICommand, Command> wrapperFunction) {
        ndWrapperFunction = wrapperFunction;
    }

    public static class NonDirtying
    extends GMFtoEMFCommandWrapper
    implements AbstractCommand.NonDirtying {
        public NonDirtying(ICommand command) {
            super(command);
            if (!(command instanceof INonDirtying)) {
                throw new IllegalArgumentException("Wrapped command is not non-dirtying");
            }
        }
    }
}

