/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.profile.definition;

import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.TextStyle;

public enum LabelStylersEnum {
    DEFAULT(null, "default"),
    BLACK(new RGB(0, 0, 0), "black"),
    BLUE(StyledString.COUNTER_STYLER, "blue"),
    GOLD(StyledString.DECORATIONS_STYLER, "gold"),
    GREY(StyledString.QUALIFIER_STYLER, "grey");

    private String literal;
    private StyledString.Styler styler;
    private static final LabelStylersEnum[] STYLER_ARRAY;

    static {
        STYLER_ARRAY = new LabelStylersEnum[]{DEFAULT, BLACK, BLUE, GOLD, GREY};
    }

    private LabelStylersEnum(StyledString.Styler styler, String literal) {
        this.styler = styler;
        this.literal = literal;
    }

    private LabelStylersEnum(RGB color, String literal) {
        JFaceResources.getColorRegistry().put(literal, color);
        this.styler = new DefaultStyler(literal, null);
        this.literal = literal;
    }

    public StyledString.Styler getStyler() {
        return this.styler;
    }

    public String getLiteral() {
        return this.literal;
    }

    public static LabelStylersEnum getByLiteral(String literal) {
        int i = 0;
        while (i < STYLER_ARRAY.length) {
            LabelStylersEnum result = STYLER_ARRAY[i];
            if (result.getLiteral().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return this.literal;
    }

    private static class DefaultStyler
    extends StyledString.Styler {
        private final String fForegroundColorName;
        private final String fBackgroundColorName;

        public DefaultStyler(String foregroundColorName, String backgroundColorName) {
            this.fForegroundColorName = foregroundColorName;
            this.fBackgroundColorName = backgroundColorName;
        }

        public void applyStyles(TextStyle textStyle) {
            ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
            if (this.fForegroundColorName != null) {
                textStyle.foreground = colorRegistry.get(this.fForegroundColorName);
            }
            if (this.fBackgroundColorName != null) {
                textStyle.background = colorRegistry.get(this.fBackgroundColorName);
            }
        }
    }
}

