/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.condition;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.swt.api.Browser;
import org.eclipse.reddeer.swt.condition.PageIsLoaded;
import org.eclipse.reddeer.swt.impl.browser.InternalBrowser;

public class BrowserContainsText
extends AbstractWaitCondition {
    private Browser browser;
    private String text;

    public BrowserContainsText(Browser browser, String text) {
        this.browser = browser;
        this.text = text;
    }

    public BrowserContainsText(String text) {
        this((Browser)new InternalBrowser(), text);
    }

    public boolean test() {
        new WaitUntil((WaitCondition)new PageIsLoaded(this.browser));
        if (Platform.getOS().startsWith("win32")) {
            return this.browser.getText().contains(this.text);
        }
        String pageHTML = "";
        if (!StringUtils.isEmpty((String)this.browser.getURL())) {
            pageHTML = (String)this.browser.evaluate("return document.documentElement.innerHTML;");
        }
        return pageHTML.contains(this.text);
    }

    public String description() {
        return "browser contains text: " + this.text;
    }
}

