/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.internal.dialogs;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.properties.PropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceUtils;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.utils.PeerNodeDataHelper;
import org.eclipse.tcf.te.tcf.processes.core.interfaces.IProcessContextItem;
import org.eclipse.tcf.te.tcf.processes.core.model.ModelManager;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModelLookupService;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModelRefreshService;
import org.eclipse.tcf.te.tcf.processes.core.util.ProcessDataHelper;
import org.eclipse.tcf.te.tcf.processes.ui.editor.tree.ContentProvider;
import org.eclipse.tcf.te.tcf.processes.ui.interfaces.IProcessMonitorUIDelegate;
import org.eclipse.tcf.te.tcf.processes.ui.nls.Messages;
import org.eclipse.tcf.te.ui.interfaces.IDataExchangeDialog;
import org.eclipse.tcf.te.ui.jface.dialogs.CustomTitleAreaDialog;
import org.eclipse.tcf.te.ui.trees.TreeViewerSorterCaseInsensitive;
import org.eclipse.tcf.te.ui.views.navigator.DelegatingLabelProvider;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class AttachContextSelectionDialog
extends CustomTitleAreaDialog
implements IEventListener,
IDataExchangeDialog {
    protected TreeViewer viewer;
    protected FilteredTree filteredTree;
    private boolean initDone = false;
    protected boolean hasAttachedContexts;
    IPeerNode peerNode;
    IPropertiesContainer data = null;

    protected boolean isResizable() {
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return this.getDialogSettings();
    }

    public AttachContextSelectionDialog(Shell parent, String contextHelpId) {
        super(parent, contextHelpId);
    }

    protected void createDialogAreaContent(Composite parent) {
        super.createDialogAreaContent(parent);
        this.setDialogTitle(Messages.AttachContextSelectionDialog_dialogTitle);
        this.setTitle(Messages.AttachContextSelectionDialog_title);
        this.setDefaultMessage(Messages.AttachContextSelectionDialog_message, 1);
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 4, true, true));
        Label filterLabel = new Label(panel, 0);
        filterLabel.setText(Messages.AttachContextSelectionDialog_filter_label);
        PatternFilter filter = new PatternFilter(){

            public boolean isElementSelectable(Object element) {
                return element instanceof IProcessContextNode;
            }

            protected boolean isLeafMatch(Viewer viewer, final Object element) {
                if (element instanceof IProcessContextNode) {
                    final AtomicBoolean canAttach = new AtomicBoolean();
                    Protocol.invokeAndWait((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            canAttach.set(AttachContextSelectionDialog.this.canAttach(element));
                        }
                    });
                    return canAttach.get() && super.isLeafMatch(viewer, element);
                }
                return true;
            }
        };
        filter.setIncludeLeadingWildcard(true);
        filter.setPattern("org.eclipse.ui.keys.optimization.false");
        this.filteredTree = new FilteredTree(panel, 2818, filter, true){

            protected String getFilterString() {
                String filter = super.getFilterString();
                if (filter != null) {
                    if ((filter = filter.trim()).length() == 0) {
                        return "*";
                    }
                    return filter;
                }
                return null;
            }
        };
        this.viewer = this.filteredTree.getViewer();
        GridData gd = new GridData(1808);
        gd.minimumHeight = 250;
        gd.minimumWidth = 300;
        gd.widthHint = 300;
        gd.heightHint = 300;
        this.filteredTree.setLayoutData((Object)gd);
        try {
            Method method = this.filteredTree.getClass().getMethod("setQuickSelectionMode", Boolean.TYPE);
            method.invoke((Object)this.filteredTree, Boolean.TRUE);
        }
        catch (Throwable method) {
            // empty catch block
        }
        this.viewer.setContentProvider((IContentProvider)new ContentProvider());
        DelegatingLabelProvider labelProvider = new DelegatingLabelProvider(){

            public String decorateText(String text, final Object element) {
                if (element instanceof IProcessContextNode) {
                    IPeerNode peerNode;
                    IProcessMonitorUIDelegate delegate;
                    String newId;
                    String id;
                    final AtomicBoolean isAttached = new AtomicBoolean();
                    final AtomicLong pid = new AtomicLong();
                    Protocol.invokeAndWait((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            isAttached.set(AttachContextSelectionDialog.this.isAttached(element));
                            pid.set(((IProcessContextNode)element).getSysMonitorContext().getPID());
                        }
                    });
                    String string = id = pid.get() >= 0L ? Long.toString(pid.get()) : "";
                    if (id.startsWith("P")) {
                        id = id.substring(1);
                    }
                    String string2 = newId = (delegate = (IProcessMonitorUIDelegate)ServiceUtils.getUIServiceDelegate((Object)(peerNode = (IPeerNode)((IProcessContextNode)element).getAdapter(IPeerNode.class)), (Object)peerNode, IProcessMonitorUIDelegate.class)) != null ? delegate.getText(element, "PID", id) : null;
                    if (newId != null) {
                        text = NLS.bind((String)Messages.AttachContextSelectionDialog_pid_decoration, (Object)text, (Object)newId);
                    }
                    if (isAttached.get()) {
                        text = NLS.bind((String)Messages.AttachContextSelectionDialog_allReadyAttached_decoration, (Object)text);
                    }
                }
                return text;
            }

            public Color getForeground(final Object element) {
                final AtomicBoolean canAttach = new AtomicBoolean();
                final AtomicBoolean isAttached = new AtomicBoolean();
                Protocol.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        canAttach.set(AttachContextSelectionDialog.this.canAttach(element));
                        isAttached.set(AttachContextSelectionDialog.this.isAttached(element));
                    }
                });
                if (!canAttach.get() || isAttached.get()) {
                    return PlatformUI.getWorkbench().getDisplay().getSystemColor(16);
                }
                return null;
            }
        };
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)labelProvider, (ILabelDecorator)labelProvider));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AttachContextSelectionDialog.this.validate();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() instanceof IStructuredSelection && ((IStructuredSelection)event.getSelection()).size() > 0) {
                    final Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    final AtomicBoolean valid = new AtomicBoolean();
                    Protocol.invokeAndWait((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            valid.set(AttachContextSelectionDialog.this.isValid(selected));
                        }
                    });
                    if (valid.get()) {
                        AttachContextSelectionDialog.this.okPressed();
                    }
                }
            }
        });
        this.viewer.setSorter((ViewerSorter)new TreeViewerSorterCaseInsensitive());
        EventManager.getInstance().addEventListener((IEventListener)this, ChangeEvent.class);
        this.restoreWidgetValues();
        this.setupData(this.data);
        AttachContextSelectionDialog.applyDialogFont((Control)panel);
        this.initDone = true;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.validate();
        return control;
    }

    protected void validate() {
        if (!this.initDone) {
            return;
        }
        final AtomicBoolean valid = new AtomicBoolean(this.hasAttachedContexts);
        final ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            valid.set(true);
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    Iterator it = ((IStructuredSelection)selection).iterator();
                    while (valid.get() && it.hasNext()) {
                        Object sel = it.next();
                        valid.set(AttachContextSelectionDialog.this.isValid(sel));
                    }
                }
            });
        }
        if (valid.get()) {
            this.setErrorMessage(null);
        }
        this.getButton(0).setEnabled(valid.get());
    }

    protected boolean canAttach(Object selection) {
        IProcessContextNode node;
        if (selection instanceof IProcessContextNode && (node = (IProcessContextNode)selection).getProcessContext() != null) {
            if (node.getProcessContext().getProperties().containsKey("CanAttach")) {
                Boolean value = (Boolean)node.getProcessContext().getProperties().get("CanAttach");
                return value != null && value != false;
            }
            return true;
        }
        return false;
    }

    protected boolean isAttached(Object selection) {
        if (selection instanceof IProcessContextNode) {
            boolean isAttached;
            IProcessContextNode node = (IProcessContextNode)selection;
            boolean bl = isAttached = node.getProcessContext() != null && node.getProcessContext().isAttached();
            if (!this.hasAttachedContexts) {
                this.hasAttachedContexts = isAttached;
            }
            return isAttached;
        }
        return false;
    }

    protected boolean isValid(Object selection) {
        return this.canAttach(selection) || this.isAttached(selection);
    }

    public void saveWidgetValues() {
    }

    protected void restoreWidgetValues() {
        super.restoreWidgetValues();
    }

    protected void dispose() {
        super.dispose();
        this.viewer = null;
        EventManager.getInstance().removeEventListener((IEventListener)this);
    }

    public void eventFired(EventObject event) {
        IPeerNode node;
        ChangeEvent e;
        if (event instanceof ChangeEvent && "changed".equals((e = (ChangeEvent)event).getEventId()) && (e.getSource() instanceof IRuntimeModel || e.getSource() instanceof IProcessContextNode) && (node = (IPeerNode)Platform.getAdapterManager().getAdapter(e.getSource(), IPeerNode.class)) == this.peerNode) {
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AttachContextSelectionDialog.this.viewer.refresh(e.getSource(), true);
                }
            });
        }
    }

    public void setupData(IPropertiesContainer data) {
        IPeerNode newPeerNode;
        this.data = new PropertiesContainer();
        this.data.setProperties(data.getProperties());
        IPeerNode[] contexts = PeerNodeDataHelper.decodeContextList((String)data.getStringProperty("contextList"));
        IPeerNode iPeerNode = newPeerNode = contexts != null && contexts.length > 0 ? contexts[0] : null;
        if (this.peerNode == null || this.peerNode != newPeerNode) {
            this.peerNode = newPeerNode;
            if (this.viewer != null) {
                this.viewer.setInput((Object)this.peerNode);
                this.viewer.expandAll();
                this.viewer.refresh(true);
            }
            Protocol.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    IRuntimeModelRefreshService refresh = (IRuntimeModelRefreshService)ModelManager.getRuntimeModel((IPeerNode)AttachContextSelectionDialog.this.peerNode).getService(IRuntimeModelRefreshService.class);
                    refresh.refresh((ICallback)new Callback(){

                        protected void internalDone(Object caller, IStatus status) {
                            if ((this).AttachContextSelectionDialog.this.viewer != null) {
                                AttachContextSelectionDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        AttachContextSelectionDialog.this.internalSetupData();
                                    }
                                });
                            }
                        }
                    });
                }
            });
        } else {
            this.internalSetupData();
        }
    }

    protected void internalSetupData() {
        if (this.viewer != null) {
            this.viewer.setInput((Object)this.peerNode);
            this.viewer.expandAll();
            this.viewer.refresh(true);
            final ArrayList ctxNodes = new ArrayList();
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    IProcessContextItem[] iProcessContextItemArray = ProcessDataHelper.decodeProcessContextItems((String)AttachContextSelectionDialog.this.data.getStringProperty("processContextList"));
                    int n = iProcessContextItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProcessContextItem item = iProcessContextItemArray[n2];
                        IRuntimeModelLookupService lkup = (IRuntimeModelLookupService)ModelManager.getRuntimeModel((IPeerNode)AttachContextSelectionDialog.this.peerNode).getService(IRuntimeModelLookupService.class);
                        IModelNode[] nodes = null;
                        if (item.getId() != null) {
                            nodes = lkup.lkupModelNodesById(item.getId());
                        }
                        if (nodes == null || nodes.length == 0) {
                            nodes = lkup.lkupModelNodesByName(item.getName());
                        }
                        if (nodes != null) {
                            IModelNode[] iModelNodeArray = nodes;
                            int n3 = nodes.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IModelNode node = iModelNodeArray[n4];
                                if (node instanceof IProcessContextNode) {
                                    ctxNodes.add((IProcessContextNode)node);
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
            });
            this.viewer.setSelection((ISelection)new StructuredSelection(ctxNodes));
        }
    }

    public void extractData(IPropertiesContainer data) {
        Assert.isNotNull((Object)data);
        data.setProperties(this.data.getProperties());
    }

    protected void okPressed() {
        if (this.data == null) {
            this.data = new PropertiesContainer();
        }
        if (this.viewer != null) {
            final ISelection sel = this.viewer.getSelection();
            final ArrayList items = new ArrayList();
            if (sel instanceof IStructuredSelection) {
                Protocol.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (Object obj : (IStructuredSelection)sel) {
                            IProcessContextItem item;
                            if (!(obj instanceof IProcessContextNode) || (item = ProcessDataHelper.getProcessContextItem((IProcessContextNode)((IProcessContextNode)obj))) == null || items.contains(item) || AttachContextSelectionDialog.this.isAttached(obj)) continue;
                            items.add(item);
                        }
                    }
                });
            }
            this.data.setProperty("processContextList", (Object)ProcessDataHelper.encodeProcessContextItems((IProcessContextItem[])items.toArray(new IProcessContextItem[items.size()])));
            if (items.size() == 0) {
                this.data.setProperty("org.eclipse.tcf.te.runtime.stepper.skip_last_run_history", true);
            }
        }
        super.okPressed();
    }
}

