/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.search;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.tcf.te.ui.interfaces.ILazyLoader;
import org.eclipse.tcf.te.ui.interfaces.ISearchable;
import org.eclipse.tcf.te.ui.interfaces.ITreeSearcher;
import org.eclipse.tcf.te.ui.trees.Pending;
import org.eclipse.tcf.te.ui.utils.TreeViewerUtil;

public abstract class AbstractSearcher
implements ITreeSearcher {
    protected TreeViewer fViewer;
    protected ISearchable fSearchable;

    protected AbstractSearcher(TreeViewer viewer, ISearchable searchable) {
        this.fViewer = viewer;
        this.fSearchable = searchable;
    }

    protected Object[] getUpdatedChildren(Object parent, IProgressMonitor monitor) {
        if (parent instanceof Pending) {
            return new Object[0];
        }
        ILazyLoader lazyLoader = this.getLazyLoader(parent);
        if (lazyLoader != null) {
            if (lazyLoader.isLeaf()) {
                return new Object[0];
            }
            if (!lazyLoader.isDataLoaded()) {
                try {
                    lazyLoader.loadData(monitor);
                }
                catch (Exception e) {
                    return new Object[0];
                }
            }
        }
        Object[] children = TreeViewerUtil.getSortedChildren(this.fViewer, parent);
        return children;
    }

    private ILazyLoader getLazyLoader(Object element) {
        ILazyLoader loader = null;
        if (element instanceof ILazyLoader) {
            loader = (ILazyLoader)element;
        }
        if (loader == null && element instanceof IAdaptable) {
            loader = (ILazyLoader)((IAdaptable)element).getAdapter(ILazyLoader.class);
        }
        if (loader == null) {
            loader = (ILazyLoader)Platform.getAdapterManager().getAdapter(element, ILazyLoader.class);
        }
        return loader;
    }
}

