/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.events;

import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.table.ITmfFilterModel;

public class TmfEventTableFilterModel
implements ITmfFilterModel {
    private final @Nullable Map<Long, String> fTableFilter;
    private final @Nullable Map<Long, String> fTableFilterName;
    private final @Nullable List<String> fPresetFilter;
    private final @Nullable Map<String, String> fPresetFilterName;
    private final boolean fCollapseFilterEnabled;

    public TmfEventTableFilterModel(@Nullable Map<Long, String> tableFilter, @Nullable Map<Long, String> tableFilterName, boolean isCollapseFilterEnabled) {
        this(tableFilter, tableFilterName, null, null, isCollapseFilterEnabled);
    }

    public TmfEventTableFilterModel(@Nullable List<String> presetFilter, @Nullable Map<String, String> presetFilterName, boolean isCollapseFilterEnabled) {
        this(null, null, presetFilter, presetFilterName, isCollapseFilterEnabled);
    }

    public TmfEventTableFilterModel(boolean isCollapseFilterEnabled) {
        this(null, null, null, null, isCollapseFilterEnabled);
    }

    public TmfEventTableFilterModel(@Nullable Map<Long, String> tableFilter, @Nullable Map<Long, String> tableFilterName, @Nullable List<String> presetFilter, @Nullable Map<String, String> presetFilterName, boolean isCollapseFilterEnabled) {
        this.fTableFilter = tableFilter == null || tableFilter.isEmpty() ? null : tableFilter;
        this.fTableFilterName = tableFilterName;
        this.fPresetFilter = presetFilter == null || presetFilter.isEmpty() ? null : presetFilter;
        this.fPresetFilterName = presetFilterName;
        this.fCollapseFilterEnabled = isCollapseFilterEnabled;
    }

    @Override
    public @Nullable Map<Long, String> getTableFilter() {
        return this.fTableFilter;
    }

    @Override
    public @NonNull String getTableFilterName(Long filterId) {
        String filterName = null;
        if (this.fTableFilterName != null) {
            filterName = this.fTableFilterName.get(filterId);
        }
        if (filterName == null && this.fTableFilter != null) {
            filterName = this.fTableFilter.get(filterId);
        }
        return filterName == null ? "" : filterName;
    }

    @Override
    public @Nullable List<String> getPresetFilter() {
        return this.fPresetFilter;
    }

    @Override
    public @NonNull String getPresetFilterName(String presetFilterId) {
        String presetFilterName = presetFilterId;
        if (this.fPresetFilterName != null) {
            presetFilterName = this.fPresetFilterName.get(presetFilterId);
        }
        return presetFilterName == null ? "" : presetFilterName;
    }

    @Override
    public boolean isCollapseFilter() {
        return this.fCollapseFilterEnabled;
    }
}

