/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hierarchy;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.xtext.ide.editor.hierarchy.ICallHierarchyBuilder;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNode;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyRoot;
import org.eclipse.xtext.ide.editor.navigation.INavigatable;
import org.eclipse.xtext.ui.editor.hierarchy.AbstractHierarchyViewPart;
import org.eclipse.xtext.ui.editor.hierarchy.HierarchyTreeContentProvider;
import org.eclipse.xtext.ui.editor.hierarchy.RefreshHierarchyAction;
import org.eclipse.xtext.ui.editor.hierarchy.SetHierarchyTypeAction;
import org.eclipse.xtext.ui.editor.navigation.NavigationService;
import org.eclipse.xtext.xbase.lib.Pair;

public abstract class AbstractCallHierarchyViewPart
extends AbstractHierarchyViewPart
implements ISelectionChangedListener {
    @Inject
    private NavigationService navigationService;
    private TableViewer locationViewer;
    private TreeViewer callHierarchyViewer;
    private final RefreshHierarchyAction refreshAction = new RefreshHierarchyAction(this);
    private final SetHierarchyTypeAction[] setHierarchyTypeActions = new SetHierarchyTypeAction[]{new SetHierarchyTypeAction(ICallHierarchyBuilder.CallHierarchyType.CALLER, this), new SetHierarchyTypeAction(ICallHierarchyBuilder.CallHierarchyType.CALLEE, this)};

    protected ICallHierarchyBuilder getCallHierarchyBuilder() {
        return this.getBuilder(ICallHierarchyBuilder.class);
    }

    public void setCallHierarchyType(ICallHierarchyBuilder.CallHierarchyType hierarchyType) {
        ICallHierarchyBuilder callHierarchyBuilder = this.getCallHierarchyBuilder();
        if (callHierarchyBuilder != null) {
            callHierarchyBuilder.setHierarchyType(hierarchyType);
        }
        this.refresh((IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void refresh(IProgressMonitor monitor) {
        ICallHierarchyBuilder.CallHierarchyType hierarchyType = this.getCallHierarchyBuilder() != null ? this.getCallHierarchyBuilder().getHierarchyType() : null;
        SetHierarchyTypeAction[] setHierarchyTypeActionArray = this.setHierarchyTypeActions;
        int n = this.setHierarchyTypeActions.length;
        int n2 = 0;
        while (n2 < n) {
            SetHierarchyTypeAction setHierarchyTypeAction;
            setHierarchyTypeAction.setChecked(hierarchyType == (setHierarchyTypeAction = setHierarchyTypeActionArray[n2]).getHierarchyType());
            ++n2;
        }
        super.refresh(monitor);
    }

    @Override
    public void setRoot(IHierarchyRoot root) {
        this.callHierarchyViewer.setInput((Object)root);
        this.setFocus();
    }

    public void createPartControl(Composite parent) {
        Composite layout = this.createLayout(parent);
        this.callHierarchyViewer = this.createCallHierarchyViewer(layout);
        this.locationViewer = this.createLocationViewer(layout);
        this.navigationService.installNavigationSupport((StructuredViewer)this.locationViewer);
        this.navigationService.installNavigationSupport((StructuredViewer)this.callHierarchyViewer);
        this.callHierarchyViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.addActions(this.getViewSite().getActionBars().getToolBarManager());
    }

    protected void addActions(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.refreshAction);
        SetHierarchyTypeAction[] setHierarchyTypeActionArray = this.setHierarchyTypeActions;
        int n = this.setHierarchyTypeActions.length;
        int n2 = 0;
        while (n2 < n) {
            SetHierarchyTypeAction setHierarchyTypeAction = setHierarchyTypeActionArray[n2];
            toolBarManager.add((IAction)setHierarchyTypeAction);
            ++n2;
        }
    }

    protected Composite createLayout(Composite parent) {
        return new SashForm(parent, 0);
    }

    protected TreeViewer createCallHierarchyViewer(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent);
        treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        treeViewer.setUseHashlookup(true);
        treeViewer.setAutoExpandLevel(2);
        treeViewer.setLabelProvider(this.createHierarchyLabelProvider());
        treeViewer.setContentProvider(this.createHierarchyContentProvider());
        return treeViewer;
    }

    protected IContentProvider createHierarchyContentProvider() {
        return new HierarchyTreeContentProvider(this);
    }

    protected abstract IBaseLabelProvider createHierarchyLabelProvider();

    protected TableViewer createLocationViewer(Composite parent) {
        TableViewer locationViewer = new TableViewer(parent);
        locationViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        locationViewer.setLabelProvider(this.createLocationLabelProvider());
        TableLayout layout = new TableLayout();
        locationViewer.getTable().setLayout((Layout)layout);
        locationViewer.getTable().setHeaderVisible(true);
        List<Pair<String, ColumnLayoutData>> locationColumnDescriptions = this.getLocationColumnDescriptionList();
        int index = 0;
        for (Pair<String, ColumnLayoutData> e : locationColumnDescriptions) {
            layout.addColumnData((ColumnLayoutData)e.getValue());
            this.createColumn(locationViewer.getTable(), e, index);
            ++index;
        }
        return locationViewer;
    }

    protected List<Pair<String, ColumnLayoutData>> getLocationColumnDescriptionList() {
        return Arrays.asList(this.getLocationColumnDescriptions());
    }

    @Deprecated(since="2.30", forRemoval=true)
    protected Pair<String, ColumnLayoutData>[] getLocationColumnDescriptions() {
        Pair[] result = new Pair[]{Pair.of((Object)"Line", (Object)new ColumnWeightData(60)), Pair.of((Object)"Call", (Object)new ColumnWeightData(300))};
        return result;
    }

    protected void createColumn(Table table, Pair<String, ColumnLayoutData> columnDescription, int index) {
        TableColumn column = new TableColumn(table, 0, index);
        column.setResizable(((ColumnLayoutData)columnDescription.getValue()).resizable);
        column.setText((String)columnDescription.getKey());
    }

    protected abstract IBaseLabelProvider createLocationLabelProvider();

    public void setFocus() {
        this.callHierarchyViewer.getControl().setFocus();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelectionProvider() == this.callHierarchyViewer) {
            IHierarchyNode callHierarchyNode = this.getSelectedNode(event.getSelection());
            this.onCallHierarchyNodeChanged(callHierarchyNode);
        }
    }

    protected void onCallHierarchyNodeChanged(IHierarchyNode node) {
        Collection<Object> input = Collections.emptyList();
        if (node != null && node.getReferences() != null) {
            input = node.getReferences();
        }
        this.locationViewer.setInput(input);
        this.navigationService.open((INavigatable)node);
        this.setFocus();
    }
}

