/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.jface;

import java.util.Set;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xwt.jface.JFacesHelper;
import org.eclipse.xwt.jface.XWTObservableWrapper;

public class ObservableMapLabelProvider
extends LabelProvider
implements ILabelProvider,
ITableLabelProvider {
    private final IObservableMap[] textMaps;
    private Viewer viewer;
    private IMapChangeListener mapChangeListener = new IMapChangeListener(){

        public void handleMapChange(MapChangeEvent event) {
            Set affectedElements = event.diff.getChangedKeys();
            LabelProviderChangedEvent newEvent = new LabelProviderChangedEvent((IBaseLabelProvider)ObservableMapLabelProvider.this, affectedElements.toArray());
            ObservableMapLabelProvider.this.fireLabelProviderChanged(newEvent);
        }
    };

    public ObservableMapLabelProvider(Viewer viewer, IObservableSet domain, String[] propertyNames) {
        this.textMaps = new XWTObservableWrapper[propertyNames.length];
        int i = 0;
        while (i < this.textMaps.length) {
            this.textMaps[i] = new XWTObservableWrapper(domain, viewer, propertyNames[i]);
            this.textMaps[i].addMapChangeListener(this.mapChangeListener);
            ++i;
        }
        this.viewer = viewer;
    }

    public void dispose() {
        int i = 0;
        while (i < this.textMaps.length) {
            this.textMaps[i].removeMapChangeListener(this.mapChangeListener);
            ++i;
        }
        super.dispose();
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex < this.textMaps.length) {
            Object result = this.textMaps[columnIndex].get(element);
            return JFacesHelper.getColumnImage(this.viewer, result, columnIndex);
        }
        return null;
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex < this.textMaps.length) {
            Object result = this.textMaps[columnIndex].get(element);
            return JFacesHelper.getColumnText(this.viewer, result, columnIndex);
        }
        return null;
    }
}

