package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link OrchestrationConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableOrchestrationConfig.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableOrchestrationConfig
    implements OrchestrationConfig {
  private final @Nullable Integer taskHistoryRetentionLimit;

  private ImmutableOrchestrationConfig(@Nullable Integer taskHistoryRetentionLimit) {
    this.taskHistoryRetentionLimit = taskHistoryRetentionLimit;
  }

  /**
   * @return The value of the {@code taskHistoryRetentionLimit} attribute
   */
  @JsonProperty("TaskHistoryRetentionLimit")
  @Override
  public @Nullable Integer taskHistoryRetentionLimit() {
    return taskHistoryRetentionLimit;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OrchestrationConfig#taskHistoryRetentionLimit() taskHistoryRetentionLimit} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for taskHistoryRetentionLimit (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableOrchestrationConfig withTaskHistoryRetentionLimit(@Nullable Integer value) {
    if (Objects.equals(this.taskHistoryRetentionLimit, value)) return this;
    return new ImmutableOrchestrationConfig(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableOrchestrationConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableOrchestrationConfig
        && equalTo((ImmutableOrchestrationConfig) another);
  }

  private boolean equalTo(ImmutableOrchestrationConfig another) {
    return Objects.equals(taskHistoryRetentionLimit, another.taskHistoryRetentionLimit);
  }

  /**
   * Computes a hash code from attributes: {@code taskHistoryRetentionLimit}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(taskHistoryRetentionLimit);
    return h;
  }

  /**
   * Prints the immutable value {@code OrchestrationConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "OrchestrationConfig{"
        + "taskHistoryRetentionLimit=" + taskHistoryRetentionLimit
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link OrchestrationConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable OrchestrationConfig instance
   */
  public static ImmutableOrchestrationConfig copyOf(OrchestrationConfig instance) {
    if (instance instanceof ImmutableOrchestrationConfig) {
      return (ImmutableOrchestrationConfig) instance;
    }
    return ImmutableOrchestrationConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableOrchestrationConfig ImmutableOrchestrationConfig}.
   * <pre>
   * ImmutableOrchestrationConfig.builder()
   *    .taskHistoryRetentionLimit(Integer | null) // nullable {@link OrchestrationConfig#taskHistoryRetentionLimit() taskHistoryRetentionLimit}
   *    .build();
   * </pre>
   * @return A new ImmutableOrchestrationConfig builder
   */
  public static ImmutableOrchestrationConfig.Builder builder() {
    return new ImmutableOrchestrationConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableOrchestrationConfig ImmutableOrchestrationConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements OrchestrationConfig.Builder {
    private Integer taskHistoryRetentionLimit;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OrchestrationConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OrchestrationConfig instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Integer taskHistoryRetentionLimitValue = instance.taskHistoryRetentionLimit();
      if (taskHistoryRetentionLimitValue != null) {
        taskHistoryRetentionLimit(taskHistoryRetentionLimitValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OrchestrationConfig#taskHistoryRetentionLimit() taskHistoryRetentionLimit} attribute.
     * @param taskHistoryRetentionLimit The value for taskHistoryRetentionLimit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("TaskHistoryRetentionLimit")
    public final Builder taskHistoryRetentionLimit(@Nullable Integer taskHistoryRetentionLimit) {
      this.taskHistoryRetentionLimit = taskHistoryRetentionLimit;
      return this;
    }

    /**
     * Builds a new {@link ImmutableOrchestrationConfig ImmutableOrchestrationConfig}.
     * @return An immutable instance of OrchestrationConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableOrchestrationConfig build() {
      return new ImmutableOrchestrationConfig(taskHistoryRetentionLimit);
    }
  }
}
