/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.logging.server;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StackTraceDeobfuscator {
    private static Pattern JsniRefPattern = Pattern.compile("@?([^:]+)::([^(]+)(\\((.*)\\))?");
    private String symbolMapsDirectory;
    private Map<String, SymbolMap> symbolMaps = new HashMap<String, SymbolMap>();

    public StackTraceDeobfuscator(String symbolMapsDirectory) {
        this.symbolMapsDirectory = symbolMapsDirectory;
    }

    public LogRecord deobfuscateLogRecord(LogRecord lr, String strongName) {
        if (lr.getThrown() != null && strongName != null) {
            lr.setThrown(this.deobfuscateThrowable(lr.getThrown(), strongName));
        }
        return lr;
    }

    public void setSymbolMapsDirectory(String dir) {
        if (!dir.equals(this.symbolMapsDirectory)) {
            this.symbolMapsDirectory = dir;
            this.symbolMaps = new HashMap<String, SymbolMap>();
        }
    }

    private StackTraceElement[] deobfuscateStackTrace(StackTraceElement[] st, String strongName) {
        StackTraceElement[] newSt = new StackTraceElement[st.length];
        for (int i = 0; i < st.length; ++i) {
            newSt[i] = this.resymbolize(st[i], strongName);
        }
        return newSt;
    }

    private Throwable deobfuscateThrowable(Throwable old, String strongName) {
        Throwable t = new Throwable(old.getMessage());
        if (old.getStackTrace() != null) {
            t.setStackTrace(this.deobfuscateStackTrace(old.getStackTrace(), strongName));
        } else {
            t.setStackTrace(new StackTraceElement[0]);
        }
        if (old.getCause() != null) {
            t.initCause(this.deobfuscateThrowable(old.getCause(), strongName));
        }
        return t;
    }

    private SymbolMap loadSymbolMap(String strongName) {
        SymbolMap toReturn = this.symbolMaps.get(strongName);
        if (toReturn != null) {
            return toReturn;
        }
        toReturn = new SymbolMap();
        String filename = this.symbolMapsDirectory + strongName + ".symbolMap";
        try {
            String line;
            BufferedReader bin = new BufferedReader(new FileReader(filename));
            while ((line = bin.readLine()) != null) {
                if (line.charAt(0) == '#') continue;
                int idx = line.indexOf(44);
                toReturn.put(new String(line.substring(0, idx)), line.substring(idx + 1));
            }
        }
        catch (IOException e) {
            toReturn = null;
        }
        this.symbolMaps.put(strongName, toReturn);
        return toReturn;
    }

    private String[] parse(String refString) {
        Matcher matcher = JsniRefPattern.matcher(refString);
        if (!matcher.matches()) {
            return null;
        }
        String className = matcher.group(1);
        String memberName = matcher.group(2);
        String[] toReturn = new String[]{className, memberName};
        return toReturn;
    }

    private StackTraceElement resymbolize(StackTraceElement ste, String strongName) {
        String[] parts;
        String symbolData;
        SymbolMap map = this.loadSymbolMap(strongName);
        String string = symbolData = map == null ? null : (String)map.get(ste.getMethodName());
        if (symbolData != null && (parts = symbolData.split(",")).length == 5) {
            String[] ref = this.parse(parts[0].substring(0, parts[0].lastIndexOf(41) + 1));
            return new StackTraceElement(ref[0], ref[1], ste.getFileName(), ste.getLineNumber());
        }
        return ste;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SymbolMap
    extends HashMap<String, String> {
        private SymbolMap() {
        }
    }
}

