/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.internal.ui.palette.PaletteColorUtil;
import org.eclipse.gef.internal.ui.palette.editparts.DetailedLabelFigure;
import org.eclipse.gef.internal.ui.palette.editparts.ToolEntryEditPart;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteTemplateEntry;
import org.eclipse.gef.ui.palette.editparts.PaletteEditPart;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

public class TemplateEditPart
extends PaletteEditPart {
    private static final String SELECTION_STATE = "selection";

    public TemplateEditPart(PaletteTemplateEntry entry) {
        super(entry);
    }

    @Override
    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            @Override
            public void getDescription(AccessibleEvent e) {
                e.result = TemplateEditPart.this.getTemplateEntry().getDescription();
            }

            @Override
            public void getName(AccessibleEvent e) {
                e.result = TemplateEditPart.this.getTemplateEntry().getLabel();
            }

            @Override
            public void getRole(AccessibleControlEvent e) {
                e.detail = 34;
            }
        };
    }

    @Override
    public IFigure createFigure() {
        DetailedLabelFigure fig = new DetailedLabelFigure(){

            public IFigure getToolTip() {
                return TemplateEditPart.this.createToolTip();
            }

            protected void paintFigure(Graphics graphics) {
                super.paintFigure(graphics);
                if (this.isSelected()) {
                    graphics.setBackgroundColor(PaletteColorUtil.getSelectedColor());
                }
                graphics.fillRoundRectangle(ToolEntryEditPart.getSelectionRectangle(TemplateEditPart.this.getLayoutSetting(), this), 3, 3);
            }
        };
        fig.setRequestFocusEnabled(true);
        return fig;
    }

    @Override
    public void deactivate() {
        ((DetailedLabelFigure)this.getFigure()).dispose();
        super.deactivate();
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        return new PaletteEditPart.SingleSelectionTracker(this){

            @Override
            protected boolean handleButtonDown(int button) {
                TemplateEditPart.this.getFigure().requestFocus();
                return super.handleButtonDown(button);
            }
        };
    }

    private PaletteTemplateEntry getTemplateEntry() {
        return (PaletteTemplateEntry)this.getModel();
    }

    @Override
    protected String getToolTipText() {
        String result = null;
        if (this.getLayoutSetting() != 3) {
            result = super.getToolTipText();
        }
        return result;
    }

    @Override
    protected boolean nameNeededInToolTip() {
        DetailedLabelFigure label = (DetailedLabelFigure)this.getFigure();
        return label.isNameTruncated() || super.nameNeededInToolTip();
    }

    @Override
    protected void refreshVisuals() {
        DetailedLabelFigure fig = (DetailedLabelFigure)this.getFigure();
        PaletteEntry entry = this.getPaletteEntry();
        fig.setName(entry.getLabel());
        fig.setDescription(entry.getDescription());
        if (this.getPreferenceSource().useLargeIcons()) {
            this.setImageDescriptor(entry.getLargeIcon());
        } else {
            this.setImageDescriptor(entry.getSmallIcon());
        }
        int layoutMode = this.getLayoutSetting();
        fig.setLayoutMode(layoutMode);
        if (layoutMode == 1) {
            fig.setBorder(ToolEntryEditPart.ICON_BORDER);
        } else if (layoutMode == 0 || layoutMode == 3) {
            fig.setBorder(ToolEntryEditPart.LIST_BORDER);
        } else if (layoutMode == 2 && !this.isToolbarItem()) {
            fig.setBorder(ToolEntryEditPart.ICON_BORDER);
        } else {
            fig.setBorder(null);
        }
        super.refreshVisuals();
    }

    @Override
    public void restoreState(IMemento memento) {
        this.setSelected(memento.getInteger(SELECTION_STATE));
        super.restoreState(memento);
    }

    @Override
    public void saveState(IMemento memento) {
        memento.putInteger(SELECTION_STATE, this.getSelected());
        super.saveState(memento);
    }

    @Override
    protected void setImageInFigure(Image image) {
        DetailedLabelFigure fig = (DetailedLabelFigure)this.getFigure();
        fig.setImage(image);
    }

    @Override
    public void setSelected(int value) {
        super.setSelected(value);
        DetailedLabelFigure label = (DetailedLabelFigure)this.getFigure();
        if (value == 2) {
            label.requestFocus();
            label.setSelected(true);
        } else {
            label.setSelected(false);
        }
        label.repaint();
    }
}

