/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs;

import org.eclipse.gmf.runtime.common.ui.action.actions.IPrintActionHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.l10n.DiagramUIPrintingMessages;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.printpreview.PrintPreviewHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.internal.util.PrintHelperUtil;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.actions.EnhancedPrintActionHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.dialogs.DialogBlock;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.internal.printpreview.RenderedPrintPreviewHelper;
import org.eclipse.gmf.runtime.diagram.ui.printing.render.model.PrintOptions;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

class ActionsBlock
extends DialogBlock {
    private final PrintOptions options;
    private Button printPreview;
    private PrintPreviewHelper printPreviewHelper;
    private IPrintActionHelper printActionHelper;

    ActionsBlock(DialogBlock.IDialogUnitConverter dluConverter, PrintOptions options) {
        super(dluConverter);
        this.options = options;
    }

    @Override
    public Control createContents(Composite parent) {
        this.printPreview = new Button(parent, 8);
        this.printPreview.setData((Object)2);
        this.printPreview.setText(DiagramUIPrintingMessages.JPSPrintDialog_Button_PrintPreview);
        this.printPreview.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ActionsBlock.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        this.layoutVerticalIndent(this.layoutAlignLeft((Control)this.printPreview));
        return this.printPreview;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case -1: {
                break;
            }
            default: {
                PrintPreviewHelper previewHelper = this.getPrintPreviewHelper();
                PrintHelperUtil.setScale((int)this.options.getScaleFactor());
                PrintHelperUtil.setScaleToWidth((int)this.options.getFitToPagesWidth());
                PrintHelperUtil.setScaleToHeight((int)this.options.getFitToPagesHeight());
                previewHelper.enablePrinting(false);
                if (this.options.isPercentScaling()) {
                    previewHelper.setPercentScaling(this.options.getScaleFactor());
                } else {
                    previewHelper.setFitToPage(this.options.getFitToPagesWidth(), this.options.getFitToPagesHeight());
                }
                previewHelper.doPrintPreview(this.getPrintActionHelper());
                this.options.setScaleFactor(PrintHelperUtil.getScale());
                this.options.setFitToPagesWidth(PrintHelperUtil.getScaleToWidth());
                this.options.setFitToPagesHeight(PrintHelperUtil.getScaleToHeight());
            }
        }
    }

    private PrintPreviewHelper getPrintPreviewHelper() {
        if (this.printPreviewHelper == null) {
            this.printPreviewHelper = new RenderedPrintPreviewHelper();
        }
        return this.printPreviewHelper;
    }

    private IPrintActionHelper getPrintActionHelper() {
        if (this.printActionHelper == null) {
            this.printActionHelper = new EnhancedPrintActionHelper();
        }
        return this.printActionHelper;
    }

    @Override
    public void dispose() {
    }
}

