/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.docker.core.Activator;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettings;
import org.eclipse.linuxtools.docker.core.IDockerConnectionSettingsProvider;
import org.eclipse.linuxtools.docker.core.Messages;
import org.eclipse.linuxtools.internal.docker.core.DockerConnection;
import org.eclipse.linuxtools.internal.docker.core.ProcessMessages;
import org.eclipse.linuxtools.internal.docker.core.SystemUtils;
import org.eclipse.linuxtools.internal.docker.core.TCPConnectionSettings;

public class ShellConnectionSettingsProvider
implements IDockerConnectionSettingsProvider {
    @Override
    public List<IDockerConnectionSettings> getConnectionSettings() {
        try {
            String connectionSettingsDetectionScriptName = this.getConnectionSettingsDetectionScriptName();
            if (connectionSettingsDetectionScriptName == null) {
                Activator.log(Status.error((String)Messages.Docker_No_Settings_Description_Script));
                return Collections.emptyList();
            }
            File connectionSettingsDetectionScript = this.getConnectionSettingsDetectionScript(connectionSettingsDetectionScriptName);
            String[] cmdArray = this.getConnectionSettingsDetectionCommandArray(connectionSettingsDetectionScript);
            Process process = Runtime.getRuntime().exec(cmdArray);
            process.waitFor();
            int exitValue = process.exitValue();
            if (exitValue == 0) {
                InputStream processInputStream = process.getInputStream();
                Properties dockerSettings = new Properties();
                dockerSettings.load(processInputStream);
                IDockerConnectionSettings setting = ShellConnectionSettingsProvider.createDockerConnectionSettings(dockerSettings);
                if (setting == null) {
                    return Collections.emptyList();
                }
                return Arrays.asList(setting);
            }
            if (exitValue != 1) {
                InputStream processErrorStream = process.getErrorStream();
                String errorMessage = this.streamToString(processErrorStream);
                Activator.log(Status.error((String)errorMessage));
            }
        }
        catch (IOException | IllegalArgumentException | InterruptedException e) {
            Activator.log(Status.error((String)Messages.Retrieve_Default_Settings_Failure, (Throwable)e));
        }
        return Collections.emptyList();
    }

    private String[] getConnectionSettingsDetectionCommandArray(File script) {
        if (Platform.getOS().equals("win32")) {
            return new String[]{"cmd.exe", "/C", script.getAbsolutePath()};
        }
        return new String[]{script.getAbsolutePath()};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private File getConnectionSettingsDetectionScript(String scriptName) {
        File script = Activator.getDefault().getBundle().getDataFile(scriptName);
        if (script == null || script.exists() && script.lastModified() >= Activator.getDefault().getBundle().getLastModified()) return script;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                FileOutputStream output = new FileOutputStream(script);
                try {
                    try (InputStream is = DockerConnection.class.getResourceAsStream("/resources/" + scriptName);){
                        int n;
                        byte[] buff = new byte[1024];
                        while ((n = is.read(buff)) > 0) {
                            output.write(buff, 0, n);
                        }
                        script.setExecutable(true);
                    }
                    if (output == null) return script;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (output == null) throw throwable;
                    output.close();
                    throw throwable;
                }
                output.close();
                return script;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.logErrorMessage(ProcessMessages.getString("Settings_Detection_Exception"), e);
        }
        return script;
    }

    private String getConnectionSettingsDetectionScriptName() {
        if (SystemUtils.isLinux()) {
            return "script.sh";
        }
        if (SystemUtils.isMac()) {
            return "script-macosx.sh";
        }
        if (SystemUtils.isWindows()) {
            return "script.bat";
        }
        return null;
    }

    private String streamToString(InputStream stream) {
        BufferedReader buff = new BufferedReader(new InputStreamReader(stream));
        StringBuilder res = new StringBuilder();
        String line = "";
        try {
            while ((line = buff.readLine()) != null) {
                res.append(System.getProperty("line.separator"));
                res.append(line);
            }
            buff.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res.length() > 0 ? res.substring(1) : "";
    }

    public static IDockerConnectionSettings createDockerConnectionSettings(Properties dockerSettings) {
        Object dockerHostEnvVariable = dockerSettings.get("DOCKER_HOST");
        Object dockerCertPathEnvVariable = dockerSettings.get("DOCKER_CERT_PATH");
        if (dockerHostEnvVariable == null) {
            return null;
        }
        return new TCPConnectionSettings(dockerHostEnvVariable.toString(), dockerCertPathEnvVariable != null ? dockerCertPathEnvVariable.toString() : null);
    }
}

