/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.facet.util.ui.internal.exported.util.dialog;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.modisco.facet.util.ui.internal.exported.dialog.IDialog;
import org.eclipse.modisco.facet.util.ui.internal.exported.util.widget.command.ICommandWidget;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractDialog<CB, W extends ICommandWidget>
extends TitleAreaDialog
implements IDialog<W> {
    private W widget;
    private Composite dialogComposite;
    private CB callback;

    protected AbstractDialog(CB callback) {
        this();
        this.callback = callback;
    }

    protected AbstractDialog() {
        super(AbstractDialog.createDisplayedShell());
    }

    private static Shell createDisplayedShell() {
        Display display = Display.getDefault();
        Shell shell = new Shell(display);
        Monitor primary = display.getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = shell.getBounds();
        int xLocation = bounds.x + (bounds.width - rect.width) / 2;
        int yLocation = bounds.y + (bounds.height - rect.height) / 2;
        shell.setLocation(xLocation, yLocation);
        return shell;
    }

    protected abstract void execute();

    protected void okPressed() {
        if (this.isDialogValid()) {
            this.getWidget().onDialogValidation();
            this.execute();
            super.okPressed();
        } else {
            this.setErrorMessage(this.getWidget().getError());
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.getDialogTitle());
        this.setMessage(this.getDialogMessage());
        this.dialogComposite = (Composite)super.createDialogArea(parent);
        this.widget = this.createWidget();
        this.widget.createWidgetContent();
        return this.widget.adapt(Control.class);
    }

    public Composite getDialogComposite() {
        return this.dialogComposite;
    }

    protected abstract W createWidget();

    protected abstract String getDialogMessage();

    protected abstract String getDialogTitle();

    @Override
    public boolean isDialogValid() {
        boolean result = true;
        String error = this.getWidget().getError();
        if (error != null) {
            result = false;
        }
        return result;
    }

    @Override
    public W getWidget() {
        return this.widget;
    }

    @Override
    public void commit() {
        this.okPressed();
    }

    @Override
    public void cancel() {
        this.cancelPressed();
    }

    public CB getCallback() {
        return this.callback;
    }
}

