/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.standalone;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.standalone.StandaloneApplication;
import org.eclipse.ocl.examples.standalone.StandaloneCommand;
import org.eclipse.ocl.examples.standalone.StandaloneResponse;
import org.eclipse.ocl.examples.standalone.messages.StandaloneMessages;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.ElementExtension;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.internal.context.ClassContext;
import org.eclipse.ocl.pivot.internal.resource.OCLASResourceFactory;
import org.eclipse.ocl.pivot.internal.utilities.PivotDiagnostician;
import org.eclipse.ocl.pivot.queries.QueriesFactory;
import org.eclipse.ocl.pivot.queries.QueryModel;
import org.eclipse.ocl.pivot.queries.QueryResult;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.LabelUtil;
import org.eclipse.ocl.pivot.utilities.OCL;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.ocl.pivot.utilities.URIUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class ExecuteCommand
extends StandaloneCommand {
    private static final Logger logger = Logger.getLogger(ExecuteCommand.class);
    public final @NonNull StandaloneCommand.BooleanToken hideResultToken;
    public final @NonNull StandaloneCommand.BooleanToken hideQueryToken;
    public final @NonNull StandaloneCommand.BooleanToken hideASResultToken;
    public final @NonNull StandaloneCommand.BooleanToken hideASQueryToken;
    public final @NonNull StandaloneCommand.BooleanToken hideASTypesToken;
    public final @NonNull ExporterToken exporterToken;
    public final @NonNull StandaloneCommand.OutputToken outputToken;
    public final @NonNull QueryToken queryToken;
    public final @NonNull SelfToken selfToken;

    public ExecuteCommand(@NonNull StandaloneApplication standaloneApplication) {
        super(standaloneApplication, "execute", StandaloneMessages.ExecuteCommand_Help);
        this.hideResultToken = new StandaloneCommand.BooleanToken(this.standaloneApplication, "-hideResult", "Omit the text representation of each result..");
        this.hideQueryToken = new StandaloneCommand.BooleanToken(this.standaloneApplication, "-hideQuery", "Omit the text representation of each query.");
        this.hideASResultToken = new StandaloneCommand.BooleanToken(this.standaloneApplication, "-hideASResult", "Omit the Abstract Syntax representation of each result.");
        this.hideASQueryToken = new StandaloneCommand.BooleanToken(this.standaloneApplication, "-hideASQuery", "Omit the Abstract Syntax representation of each query.");
        this.hideASTypesToken = new StandaloneCommand.BooleanToken(this.standaloneApplication, "-hideASTypes", "Omit type fields from Abstract Syntax; reduces file size by perhaps 75%");
        this.exporterToken = new ExporterToken(this.standaloneApplication);
        this.outputToken = new StandaloneCommand.OutputToken(this.standaloneApplication);
        this.queryToken = new QueryToken(this.standaloneApplication);
        this.selfToken = new SelfToken(this.standaloneApplication);
        this.queryToken.setIsRequired();
        this.addToken(this.hideResultToken);
        this.addToken(this.hideQueryToken);
        this.addToken(this.hideASResultToken);
        this.addToken(this.hideASQueryToken);
        this.addToken(this.hideASTypesToken);
        this.addToken(this.outputToken);
        this.addToken(this.exporterToken);
        this.addToken(this.queryToken);
        this.addToken(this.selfToken);
    }

    protected void appendChildren(List<@NonNull String> errors, List<Diagnostic> children) {
        for (Diagnostic child : children) {
            errors.add(child.getMessage());
            this.appendChildren(errors, child.getChildren());
        }
    }

    @Override
    public @NonNull StandaloneResponse execute() throws IOException {
        this.standaloneApplication.doEssentialOCLSetup();
        EObject context = this.selfToken.getSelf();
        OCL ocl = this.standaloneApplication.getOCL();
        boolean hideResult = this.hideResultToken.isPresent();
        boolean hideQuery = this.hideQueryToken.isPresent();
        boolean hideASResult = this.hideASResultToken.isPresent();
        boolean hideASQuery = this.hideASQueryToken.isPresent();
        boolean hideASTypes = this.hideASTypesToken.isPresent();
        File outputFile = this.outputToken.getOutputFile();
        IResultExporter selectedExporter = this.exporterToken.getExporter();
        if (outputFile == null || selectedExporter == null) {
            selectedExporter = new DefaultResultExporter(this.standaloneApplication);
        } else {
            selectedExporter.open(outputFile, hideQuery, hideResult, hideASQuery, hideASResult, hideASTypes);
        }
        Class classContext = ocl.getContextType((Object)context);
        boolean allOk = true;
        for (String queryString : this.queryToken.getQueries()) {
            ArrayList<String> errors;
            ExpressionInOCL query;
            Object result;
            block13: {
                result = null;
                query = null;
                errors = new ArrayList<String>();
                ClassContext parserContext = new ClassContext(ocl.getEnvironmentFactory(), null, classContext, context instanceof Type && !(context instanceof ElementExtension) ? (Type)context : null);
                try {
                    query = parserContext.parse((EObject)classContext, queryString);
                    Map validationContext = LabelUtil.createDefaultContext((EValidator)Diagnostician.INSTANCE);
                    BasicDiagnostic diagnostics = PivotDiagnostician.BasicDiagnosticWithRemove.validate((EObject)query, (Map)validationContext);
                    List children = diagnostics.getChildren();
                    if (children.size() > 0) {
                        this.appendChildren(errors, children);
                        allOk = false;
                    }
                    if (children.size() > 0 || hideResult && hideASResult) break block13;
                    EvaluationVisitor evaluationVisitor = ocl.createEvaluationVisitor((Object)context, query);
                    try {
                        result = query.accept((Visitor)evaluationVisitor);
                        if (result == null) {
                            result = ValueUtil.createLiteralExp(null);
                        }
                    }
                    catch (InvalidValueException e) {
                        if (e == ValueUtil.INVALID_VALUE) {
                            result = e;
                            break block13;
                        }
                        throw e;
                    }
                }
                catch (AssertionError | Exception e) {
                    errors.add(((Throwable)e).toString());
                    allOk = false;
                }
            }
            try {
                selectedExporter.export(queryString, query, context, result, errors.size() > 0 ? errors : null);
            }
            catch (IOException e) {
                logger.error((Object)StandaloneMessages.OCLValidatorApplication_ExportProblem, (Throwable)e);
                allOk = false;
            }
        }
        selectedExporter.close();
        if (selectedExporter instanceof DefaultResultExporter) {
            this.standaloneApplication.setConsoleOutput(((DefaultResultExporter)selectedExporter).getConsoleText());
        }
        return allOk ? StandaloneResponse.OK : StandaloneResponse.FAIL;
    }

    public static abstract class AbstractResultExporter
    implements IResultExporter {
        protected final @NonNull StandaloneApplication standaloneApplication;

        protected AbstractResultExporter(@NonNull StandaloneApplication standaloneApplication) {
            this.standaloneApplication = standaloneApplication;
        }
    }

    public static class DefaultResultExporter
    extends AbstractResultExporter {
        private final @NonNull StringBuilder s = new StringBuilder();

        protected DefaultResultExporter(@NonNull StandaloneApplication standaloneApplication) {
            super(standaloneApplication);
        }

        @Override
        public void close() {
            if (!this.standaloneApplication.isTest()) {
                System.out.println(this.s.toString());
            }
        }

        @Override
        public void export(@NonNull String query, @Nullable ExpressionInOCL expression, @Nullable Object context, @Nullable Object result, @Nullable List<@NonNull String> errors) throws IOException {
            if (errors == null) {
                this.s.append(result);
            } else {
                for (String error : errors) {
                    this.s.append(String.valueOf(error) + "\n");
                }
            }
            this.s.append("\n");
        }

        public @NonNull String getConsoleText() {
            return this.s.toString();
        }

        @Override
        public void open(@NonNull File exportedFile, boolean hideQuery, boolean hideResult, boolean hideASQuery, boolean hideASResult, boolean hideASTypes) {
        }
    }

    public static class ExporterToken
    extends StandaloneCommand.StringToken {
        private @Nullable IResultExporter exporter;

        public ExporterToken(@NonNull StandaloneApplication standaloneApplication) {
            super(standaloneApplication, "-exporter", StandaloneMessages.ExecuteCommand_Exporter_Help, "none|text|model");
        }

        public @Nullable IResultExporter getExporter() {
            return this.exporter;
        }

        @Override
        public boolean parseCheck(@NonNull String string) {
            if ("none".equals(string)) {
                this.exporter = null;
            } else if ("text".equals(string)) {
                this.exporter = new TextResultExporter(this.standaloneApplication);
            } else if ("model".equals(string)) {
                this.exporter = new ModelResultExporter(this.standaloneApplication);
            } else {
                logger.error((Object)("Unrecognized 'exporter' " + string));
                return false;
            }
            return true;
        }
    }

    public static interface IResultExporter {
        public void close() throws IOException;

        public void export(@NonNull String var1, @Nullable ExpressionInOCL var2, @Nullable Object var3, @Nullable Object var4, @Nullable List<@NonNull String> var5) throws IOException;

        public void open(@NonNull File var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6) throws IOException;
    }

    public static class ModelResultExporter
    extends AbstractResultExporter {
        private boolean hideQuery;
        private boolean hideResult;
        private boolean hideASQuery;
        private boolean hideASResult;
        private boolean hideASTypes;
        private Resource resource;
        private @NonNull QueryModel queryModel = QueriesFactory.eINSTANCE.createQueryModel();

        public ModelResultExporter(@NonNull StandaloneApplication standaloneApplication) {
            super(standaloneApplication);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Override
        public void close() throws IOException {
            if (this.resource != null) {
                if (this.hideASTypes) {
                    @NonNull EList contents = this.resource.getContents();
                    @NonNull Collection newContents = EcoreUtil.copyAll((Collection)contents);
                    contents.clear();
                    contents.addAll(newContents);
                    for (EObject eObject : new TreeIterable(this.resource)) {
                        if (eObject instanceof TypedElement) {
                            ((TypedElement)eObject).setType(null);
                        }
                        if (!(eObject instanceof TypeExp)) continue;
                        ((TypeExp)eObject).setReferredType(null);
                        ((TypeExp)eObject).setTypeValue(null);
                    }
                }
                this.resource.save(null);
                this.resource.getResourceSet().getResources().remove((Object)this.resource);
            }
        }

        @Override
        public void export(@NonNull String query, @Nullable ExpressionInOCL expression, @Nullable Object context, @Nullable Object result, @Nullable List<@NonNull String> errors) throws IOException {
            QueryResult queryResult = QueriesFactory.eINSTANCE.createQueryResult();
            if (context != null) {
                queryResult.setSelf((EObject)context);
            }
            if (!this.hideQuery) {
                queryResult.setQuery(query);
            }
            if (expression != null) {
                expression.setBody(null);
                if (!this.hideASQuery) {
                    queryResult.setExpression(expression);
                }
            }
            if (result != null) {
                if (!this.hideResult) {
                    StringBuilder s = new StringBuilder();
                    ValueUtil.toString((Object)result, (StringBuilder)s, (int)-1);
                    queryResult.setResult(s.toString());
                }
                if (!this.hideASResult) {
                    queryResult.setValue(ValueUtil.createLiteralExp((Object)result));
                }
            }
            if (errors != null) {
                EList errors2 = queryResult.getErrors();
                for (String error : errors) {
                    errors2.add(error);
                }
            }
            this.queryModel.getResults().add((Object)queryResult);
        }

        @Override
        public void open(@Nullable File exportedFile, boolean hideQuery, boolean hideResult, boolean hideASQuery, boolean hideASResult, boolean hideASTypes) throws IOException {
            this.hideResult = hideResult;
            this.hideQuery = hideQuery;
            this.hideASResult = hideASResult;
            this.hideASQuery = hideASQuery;
            this.hideASTypes = hideASTypes;
            if (exportedFile != null) {
                ResourceSet resourceSet = this.standaloneApplication.getOCL().getMetamodelManager().getASResourceSet();
                URI uri = URI.createFileURI((String)exportedFile.getAbsolutePath());
                this.resource = OCLASResourceFactory.getInstance().createResource(uri);
                resourceSet.getResources().add((Object)this.resource);
                this.resource.getContents().add((Object)this.queryModel);
            } else {
                this.resource = null;
            }
        }
    }

    public static class QueryToken
    extends StandaloneCommand.StringToken {
        private @Nullable List<@NonNull String> queries = null;

        public QueryToken(@NonNull StandaloneApplication standaloneApplication) {
            super(standaloneApplication, "-query", StandaloneMessages.ExecuteCommand_Query_Help, "<ocl-query>");
            this.setIsRequired();
        }

        @Override
        protected boolean analyze(@Nullable String string) {
            List<@NonNull String> queries2 = this.queries;
            if (queries2 == null) {
                this.queries = queries2 = new ArrayList<String>();
            }
            queries2.add(string);
            return true;
        }

        @Override
        public int getMaxArguments() {
            return -1;
        }

        public @Nullable List<@NonNull String> getQueries() {
            return this.queries;
        }

        @Override
        public boolean isSingleton() {
            return false;
        }
    }

    public static class SelfToken
    extends StandaloneCommand.StringToken {
        private @Nullable EObject self = null;

        public SelfToken(@NonNull StandaloneApplication standaloneApplication) {
            super(standaloneApplication, "-self", StandaloneMessages.ExecuteCommand_Self_Help, "<self-uri>");
        }

        @Override
        protected boolean analyze(@Nullable String string) {
            URI rawURI = URI.createURI((String)string);
            String fragment = rawURI.fragment();
            rawURI = URIUtil.getAbsoluteURI((URI)rawURI.trimFragment());
            Resource selfResource = this.standaloneApplication.getResourceSet().getResource(rawURI, true);
            if (selfResource == null) {
                String string2 = rawURI.toString();
                logger.error((Object)("Failed to load '" + string2 + "'"));
                return false;
            }
            this.self = selfResource.getEObject(fragment);
            if (this.self == null) {
                String string2 = rawURI.toString();
                logger.error((Object)("Failed to locate '" + fragment + "' within '" + string2 + "'"));
            }
            return this.self != null;
        }

        public @Nullable EObject getSelf() {
            return this.self;
        }
    }

    public static class TextResultExporter
    extends AbstractResultExporter {
        private FileWriter s;
        private boolean hideQuery;
        private boolean hideResult;

        protected TextResultExporter(@NonNull StandaloneApplication standaloneApplication) {
            super(standaloneApplication);
        }

        @Override
        public void close() throws IOException {
            this.s.close();
        }

        @Override
        public void export(@NonNull String query, @Nullable ExpressionInOCL expression, @Nullable Object context, @Nullable Object result, @Nullable List<@NonNull String> errors) throws IOException {
            block5: {
                block3: {
                    block4: {
                        if (errors != null) break block3;
                        if (!this.hideQuery) break block4;
                        if (!this.hideResult) {
                            this.s.append(result + "\n");
                        } else {
                            this.s.append(result + "\n");
                        }
                        break block5;
                    }
                    this.s.append("Query : " + query + "\n");
                    if (this.hideResult) break block5;
                    this.s.append("Result: " + result + "\n");
                    break block5;
                }
                this.s.append("Query : " + query + "\n");
                this.s.append("Result: " + result + "\n");
                for (String error : errors) {
                    this.s.append("Error : " + error + "\n");
                }
            }
        }

        @Override
        public void open(@NonNull File exportedFile, boolean hideQuery, boolean hideResult, boolean hideASQuery, boolean hideASResult, boolean hideASTypes) throws IOException {
            this.hideQuery = hideQuery;
            this.hideResult = hideResult;
            this.s = new FileWriter(exportedFile);
        }
    }
}

