/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.edit.policies;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.handles.ConnectionHandle;
import org.eclipse.gef.handles.SquareHandle;
import org.eclipse.gef.tools.SelectEditPartTracker;
import org.eclipse.gef.tools.SimpleDragTracker;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Connector;
import org.eclipse.gmf.runtime.notation.IntValueStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.PapyrusConnectionEndEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editparts.UMLConnectionNodeEditPart;
import org.eclipse.papyrus.uml.diagram.sequence.figures.DurationLinkFigure;
import org.eclipse.papyrus.uml.diagram.sequence.locator.IntersectionPointSelectionLocator;
import org.eclipse.papyrus.uml.diagram.sequence.requests.MoveArrowRequest;
import org.eclipse.swt.graphics.Cursor;

public class DurationLinkSelectionHandlesEditPolicy
extends PapyrusConnectionEndEditPolicy
implements PropertyChangeListener {
    private UMLConnectionNodeEditPart durationLinkEditPart;
    private TransactionalEditingDomain editingDomain;
    private Integer arrowPositionDelta;

    public DurationLinkSelectionHandlesEditPolicy(UMLConnectionNodeEditPart durationLinkEditPart, TransactionalEditingDomain editingDomain) {
        this.durationLinkEditPart = durationLinkEditPart;
        this.editingDomain = editingDomain;
    }

    public void setHost(EditPart host) {
        super.setHost(host);
        if (this.getHost() != null) {
            this.getHostFigure().addPropertyChangeListener("points", (PropertyChangeListener)this);
        }
    }

    protected List<?> createSelectionHandles() {
        ArrayList<Handle> handles = new ArrayList<Handle>();
        handles.addAll(super.createSelectionHandles());
        this.addSelectionHandles(handles);
        this.addMoveHandles(handles);
        return handles;
    }

    private void addMoveHandles(List<Handle> list) {
        DurationLinkFigure figure = (DurationLinkFigure)this.getHostFigure();
        Cursor cursor = this.getCursor(figure);
        SquareHandle moveHandle = new SquareHandle((GraphicalEditPart)((ConnectionEditPart)this.getHost()), (Locator)new CustomMoveHandleLocator((Connection)figure), cursor){

            protected DragTracker createDragTracker() {
                return new ArrowLineMoveTracker();
            }
        };
        list.add((Handle)moveHandle);
    }

    public void showSourceFeedback(Request request) {
        if ("MoveArrowRequest".equals(request.getType())) {
            this.showArrowMoveFeedback((MoveArrowRequest)request);
        }
        super.showSourceFeedback(request);
    }

    public void eraseSourceFeedback(Request request) {
        if ("MoveArrowRequest".equals(request.getType())) {
            this.eraseArrowMoveFeedback((MoveArrowRequest)request);
        }
        super.eraseSourceFeedback(request);
    }

    private void eraseArrowMoveFeedback(MoveArrowRequest request) {
        this.arrowPositionDelta = null;
        this.getHost().refresh();
    }

    protected void showArrowMoveFeedback(MoveArrowRequest request) {
        DurationLinkFigure figure = (DurationLinkFigure)this.durationLinkEditPart.getFigure();
        if (this.arrowPositionDelta == null) {
            this.arrowPositionDelta = figure.getArrowPositionDelta();
        }
        PointList arrowLinePoints = figure.getArrowLinePoints();
        Point arrowPoint = arrowLinePoints.getMidpoint().getCopy();
        figure.translateToAbsolute((Translatable)arrowPoint);
        arrowPoint.translate(request.getMoveDelta());
        figure.translateToRelative((Translatable)arrowPoint);
        Dimension moveDelta = arrowPoint.getDifference(arrowLinePoints.getMidpoint());
        DurationLinkFigure.Orientation arrowOrientation = request.getArrowOrientation();
        if (arrowOrientation == DurationLinkFigure.Orientation.VERTICAL) {
            figure.setArrowPositionDelta(this.arrowPositionDelta + moveDelta.width);
        } else {
            figure.setArrowPositionDelta(this.arrowPositionDelta + moveDelta.height);
        }
    }

    private Cursor getCursor(DurationLinkFigure figure) {
        if (figure.getArrowOrientation() == DurationLinkFigure.Orientation.VERTICAL) {
            return Cursors.SIZEWE;
        }
        return Cursors.SIZENS;
    }

    private void addSelectionHandles(List<Handle> list) {
        DurationLinkFigure figure = (DurationLinkFigure)this.getHostFigure();
        PointList arrowLinePoints = figure.getArrowLinePoints();
        PointList startLinePoints = figure.getStartLinePoints();
        PointList endLinePoints = figure.getEndLinePoints();
        list.add((Handle)new DurationConstraintArrowSelectionHandle(true, (GraphicalEditPart)this.durationLinkEditPart, (Connection)figure, startLinePoints, arrowLinePoints));
        list.add((Handle)new DurationConstraintArrowSelectionHandle(true, (GraphicalEditPart)this.durationLinkEditPart, (Connection)figure, endLinePoints, arrowLinePoints));
    }

    protected SelectEditPartTracker getSelectTracker() {
        return new SelectEditPartTracker(this.getHost());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.getHost().getSelected() != 0) {
            this.addSelectionHandles();
        }
    }

    class ArrowLineMoveTracker
    extends SimpleDragTracker {
        ArrowLineMoveTracker() {
        }

        protected String getCommandName() {
            return "MoveArrowRequest";
        }

        protected void updateSourceRequest() {
            super.updateSourceRequest();
            MoveArrowRequest request = (MoveArrowRequest)this.getSourceRequest();
            DurationLinkFigure figure = (DurationLinkFigure)DurationLinkSelectionHandlesEditPolicy.this.durationLinkEditPart.getPrimaryShape();
            request.setArrowOrientation(figure.getArrowOrientation());
            Point location = new Point(this.getLocation());
            request.setLocation(location);
            Dimension dragMoveDelta = this.getDragMoveDelta();
            Point moveDelta = new Point(0, 0);
            moveDelta.y += dragMoveDelta.height;
            moveDelta.x += dragMoveDelta.width;
            request.setMoveDelta(moveDelta);
        }

        protected Request createSourceRequest() {
            return new MoveArrowRequest();
        }

        protected Command getCommand() {
            final Request request = this.getSourceRequest();
            if (request instanceof MoveArrowRequest) {
                AbstractTransactionalCommand moveArrowCommand = new AbstractTransactionalCommand(DurationLinkSelectionHandlesEditPolicy.this.editingDomain, "Move arrow", null){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        Connector connector = (Connector)((ArrowLineMoveTracker)ArrowLineMoveTracker.this).DurationLinkSelectionHandlesEditPolicy.this.durationLinkEditPart.getNotationView();
                        Optional<Object> deltaOptional = connector.getStyles().stream().filter(IntValueStyle.class::isInstance).filter(style -> "delta".equals(((IntValueStyle)style).getName())).findFirst();
                        IntValueStyle deltaStyle = deltaOptional.orElseGet(() -> {
                            IntValueStyle style = (IntValueStyle)connector.createStyle(NotationPackage.eINSTANCE.getIntValueStyle());
                            style.setName("delta");
                            return style;
                        });
                        DurationLinkFigure figure = (DurationLinkFigure)((ArrowLineMoveTracker)ArrowLineMoveTracker.this).DurationLinkSelectionHandlesEditPolicy.this.durationLinkEditPart.getFigure();
                        PointList arrowLinePoints = figure.getArrowLinePoints();
                        Point arrowPoint = arrowLinePoints.getMidpoint().getCopy();
                        figure.translateToAbsolute((Translatable)arrowPoint);
                        arrowPoint.translate(((MoveArrowRequest)request).getMoveDelta());
                        figure.translateToRelative((Translatable)arrowPoint);
                        Dimension moveDelta = arrowPoint.getDifference(arrowLinePoints.getMidpoint());
                        DurationLinkFigure.Orientation arrowOrientation = ((MoveArrowRequest)request).getArrowOrientation();
                        if (arrowOrientation == DurationLinkFigure.Orientation.VERTICAL) {
                            deltaStyle.setIntValue(deltaStyle.getIntValue() + moveDelta.width);
                        } else {
                            deltaStyle.setIntValue(deltaStyle.getIntValue() + moveDelta.height);
                        }
                        return CommandResult.newOKCommandResult();
                    }
                };
                return new ICommandProxy((ICommand)moveArrowCommand);
            }
            return super.getCommand();
        }
    }

    class CustomMoveHandleLocator
    extends ConnectionLocator {
        public CustomMoveHandleLocator(Connection connection) {
            super(connection);
        }

        protected Point getLocation(PointList points) {
            DurationLinkFigure figure = (DurationLinkFigure)this.getConnection();
            PointList arrowLinePoints = figure.getArrowLinePoints();
            return arrowLinePoints.getMidpoint();
        }
    }

    class DurationConstraintArrowSelectionHandle
    extends ConnectionHandle {
        DurationConstraintArrowSelectionHandle(boolean fixed, GraphicalEditPart owner, Connection connection, PointList pointList1, PointList pointList2) {
            super(fixed);
            this.setOwner(owner);
            this.setLocator((Locator)new IntersectionPointSelectionLocator(connection, pointList1, pointList2));
        }

        protected DragTracker createDragTracker() {
            return new SimpleDragTracker(){

                protected String getCommandName() {
                    return "selection";
                }
            };
        }
    }
}

