/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.corext.refactoring.changes;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.php.internal.ui.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.php.internal.ui.corext.refactoring.changes.AbstractElementRenameChange;
import org.eclipse.php.internal.ui.util.Messages;

public final class RenameSourceModuleChange
extends AbstractElementRenameChange {
    public RenameSourceModuleChange(ISourceModule unit, String newName) {
        this(unit.getResource().getFullPath(), unit.getElementName(), newName, -1L);
        Assert.isTrue((!unit.isReadOnly() ? 1 : 0) != 0, (String)"source module must not be read-only");
    }

    private RenameSourceModuleChange(IPath resourcePath, String oldName, String newName, long stampToRestore) {
        super(resourcePath, oldName, newName, stampToRestore);
        this.setValidationMethod(5);
    }

    @Override
    protected IPath createNewPath() {
        IPath path = this.getResourcePath();
        if (path.getFileExtension() != null) {
            return path.removeFileExtension().removeLastSegments(1).append(this.getNewName());
        }
        return path.removeLastSegments(1).append(this.getNewName());
    }

    @Override
    protected Change createUndoChange(long stampToRestore) {
        return new RenameSourceModuleChange(this.createNewPath(), this.getNewName(), this.getOldName(), stampToRestore);
    }

    @Override
    protected void doRename(IProgressMonitor pm) throws CoreException {
        ISourceModule cu = (ISourceModule)this.getModifiedElement();
        if (cu != null) {
            cu.rename(this.getNewName(), false, pm);
        }
    }

    public String getName() {
        Object[] keys = new String[]{this.getOldName(), this.getNewName()};
        return Messages.format(RefactoringCoreMessages.RenameSourceModuleChange_name, keys);
    }
}

