/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.planner.compiler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.localsearch.operations.generic.GenericTypeCheck;
import org.eclipse.viatra.query.runtime.localsearch.operations.generic.GenericTypeExtend;
import org.eclipse.viatra.query.runtime.localsearch.operations.generic.GenericTypeExtendSingleValue;
import org.eclipse.viatra.query.runtime.localsearch.planner.compiler.AbstractOperationCompiler;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.TypeFilterConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;

public class GenericOperationCompiler
extends AbstractOperationCompiler {
    public GenericOperationCompiler(IQueryRuntimeContext runtimeContext) {
        super(runtimeContext);
    }

    @Override
    protected void createCheck(TypeFilterConstraint typeConstraint, Map<PVariable, Integer> variableMapping) {
        IInputKey inputKey = typeConstraint.getInputKey();
        Tuple tuple = typeConstraint.getVariablesTuple();
        int[] positions = new int[tuple.getSize()];
        int i = 0;
        while (i < tuple.getSize()) {
            PVariable variable = (PVariable)tuple.get(i);
            positions[i] = variableMapping.get(variable);
            ++i;
        }
        this.operations.add(new GenericTypeCheck(inputKey, positions, TupleMask.fromSelectedIndices((int)variableMapping.size(), (int[])positions)));
    }

    @Override
    protected void createCheck(TypeConstraint typeConstraint, Map<PVariable, Integer> variableMapping) {
        IInputKey inputKey = (IInputKey)typeConstraint.getSupplierKey();
        Tuple tuple = typeConstraint.getVariablesTuple();
        int[] positions = new int[tuple.getSize()];
        int i = 0;
        while (i < tuple.getSize()) {
            PVariable variable = (PVariable)tuple.get(i);
            positions[i] = variableMapping.get(variable);
            ++i;
        }
        this.operations.add(new GenericTypeCheck(inputKey, positions, TupleMask.fromSelectedIndices((int)variableMapping.size(), (int[])positions)));
    }

    @Override
    protected void createUnaryTypeCheck(IInputKey inputKey, int position) {
        int[] positions = new int[]{position};
        this.operations.add(new GenericTypeCheck(inputKey, positions, TupleMask.fromSelectedIndices((int)1, (int[])positions)));
    }

    @Override
    protected void createExtend(TypeConstraint typeConstraint, Map<PVariable, Integer> variableMapping) {
        IInputKey inputKey = (IInputKey)typeConstraint.getSupplierKey();
        Tuple tuple = typeConstraint.getVariablesTuple();
        int[] positions = new int[tuple.getSize()];
        ArrayList<Integer> boundVariableIndices = new ArrayList<Integer>();
        ArrayList<Integer> boundVariables = new ArrayList<Integer>();
        HashSet<Integer> unboundVariables = new HashSet<Integer>();
        int i = 0;
        while (i < tuple.getSize()) {
            PVariable variable = (PVariable)tuple.get(i);
            Integer position = variableMapping.get(variable);
            positions[i] = position;
            if (((Set)this.variableBindings.get(typeConstraint)).contains(position)) {
                boundVariableIndices.add(i);
                boundVariables.add(position);
            } else {
                unboundVariables.add(position);
            }
            ++i;
        }
        TupleMask indexerMask = TupleMask.fromSelectedIndices((int)inputKey.getArity(), boundVariableIndices);
        TupleMask callMask = TupleMask.fromSelectedIndices((int)variableMapping.size(), boundVariables);
        if (unboundVariables.size() == 1) {
            this.operations.add(new GenericTypeExtendSingleValue(inputKey, positions, callMask, indexerMask, (Integer)unboundVariables.iterator().next()));
        } else {
            this.operations.add(new GenericTypeExtend(inputKey, positions, callMask, indexerMask, unboundVariables));
        }
    }
}

