/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui.editor.contentproviders;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.databinding.Messages;

public class ChooseClassConfiguration {
    private String m_dialogFieldLabel;
    private boolean m_dialogFieldEnabled = true;
    private boolean m_useClearButton;
    private String m_valuesScope;
    private String m_clearValue;
    private String[] m_defaultValues;
    private String m_targetClassName;
    private String m_retargetClassName;
    private String[] m_baseClassNames;
    private boolean m_chooseInterfaces;
    private final List<String> m_defaultStarts = Lists.newArrayList();
    private Class<?>[][] m_constructorParameters;
    private String m_emptyClassErrorMessage = Messages.ChooseClassConfiguration_validateEmptyClass;
    private String m_errorMessagePrefix = Messages.ChooseClassConfiguration_validateMessagePrefix;

    public ChooseClassConfiguration() {
    }

    public ChooseClassConfiguration(ChooseClassConfiguration configuration) {
        this.m_dialogFieldLabel = configuration.m_dialogFieldLabel;
        this.m_dialogFieldEnabled = configuration.m_dialogFieldEnabled;
        this.m_useClearButton = configuration.m_useClearButton;
        this.m_valuesScope = configuration.m_valuesScope;
        this.m_clearValue = configuration.m_clearValue;
        this.m_defaultValues = configuration.m_defaultValues;
        this.m_targetClassName = configuration.m_targetClassName;
        this.m_retargetClassName = configuration.m_retargetClassName;
        this.m_baseClassNames = configuration.m_baseClassNames;
        this.m_chooseInterfaces = configuration.m_chooseInterfaces;
        this.m_defaultStarts.addAll(configuration.m_defaultStarts);
        this.m_constructorParameters = configuration.m_constructorParameters;
        this.m_emptyClassErrorMessage = configuration.m_emptyClassErrorMessage;
        this.m_errorMessagePrefix = configuration.m_errorMessagePrefix;
    }

    public final String getDialogFieldLabel() {
        return this.m_dialogFieldLabel;
    }

    public final void setDialogFieldLabel(String dialogFieldLabel) {
        this.m_dialogFieldLabel = dialogFieldLabel;
    }

    public boolean isDialogFieldEnabled() {
        return this.m_dialogFieldEnabled;
    }

    public void setDialogFieldEnabled(boolean dialogFieldEnabled) {
        this.m_dialogFieldEnabled = dialogFieldEnabled;
    }

    public final boolean isUseClearButton() {
        return this.m_useClearButton;
    }

    public final String getValuesScope() {
        return this.m_valuesScope;
    }

    public final void setValueScope(String valuesScope) {
        this.m_valuesScope = valuesScope;
    }

    public final String getClearValue() {
        return this.m_clearValue;
    }

    public final void setClearValue(String clearValue) {
        this.m_useClearButton = !StringUtils.isEmpty((String)clearValue);
        this.m_clearValue = clearValue;
    }

    public final String[] getDefaultValues() {
        return this.m_defaultValues;
    }

    public final void setDefaultValues(String[] defaultValues) {
        this.m_defaultValues = defaultValues;
    }

    public final String getRetargetClassName(String className) {
        if (className.equals(this.m_targetClassName)) {
            return this.m_retargetClassName;
        }
        return className;
    }

    public final void setRetargetClassName(String targetClassName, String retargetClassName) {
        this.m_targetClassName = targetClassName;
        this.m_retargetClassName = retargetClassName;
    }

    public final String[] getBaseClassNames() {
        return this.m_baseClassNames;
    }

    public final void setBaseClassName(String baseClassName) {
        this.setBaseClassNames(baseClassName);
    }

    public final void setBaseClassNames(String ... baseClassNames) {
        this.m_baseClassNames = baseClassNames;
    }

    public final int getOpenTypeStyle() {
        return this.m_chooseInterfaces ? 512 : 2;
    }

    public boolean isChooseInterfaces() {
        return this.m_chooseInterfaces;
    }

    public final void setChooseInterfaces(boolean chooseInterfaces) {
        this.m_chooseInterfaces = chooseInterfaces;
    }

    public final Class<?>[][] getConstructorsParameters() {
        return this.m_constructorParameters;
    }

    public final void setConstructorParameters(Class<?>[] constructorParameters) {
        this.setConstructorsParameters(new Class[][]{constructorParameters});
    }

    public final void setConstructorsParameters(Class<?>[] ... constructorParameters) {
        this.m_constructorParameters = constructorParameters;
    }

    public final boolean isDefaultString(String testString) {
        for (String defaultString : this.m_defaultStarts) {
            if (!testString.startsWith(defaultString)) continue;
            return true;
        }
        return false;
    }

    public final void addDefaultStart(String defaultStart) {
        this.m_defaultStarts.add(defaultStart);
    }

    public final void clearDefaultStrings() {
        this.m_defaultStarts.clear();
    }

    public final String getEmptyClassErrorMessage() {
        return this.m_emptyClassErrorMessage;
    }

    public final void setEmptyClassErrorMessage(String errorMessage) {
        this.m_emptyClassErrorMessage = errorMessage;
    }

    public final String getErrorMessagePrefix() {
        return this.m_errorMessagePrefix;
    }

    public final void setErrorMessagePrefix(String errorMessagePrefix) {
        this.m_errorMessagePrefix = errorMessagePrefix;
    }
}

