/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.controls;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.wb.core.controls.CImageLabel;
import org.eclipse.wb.draw2d.IColorConstants;
import org.eclipse.wb.internal.core.utils.binding.editors.controls.DefaultControlActionsManager;

public class CCombo3
extends Composite {
    private final long m_createTime = System.currentTimeMillis();
    private final CImageLabel m_text;
    private final Button m_arrow;
    private final Shell m_popup;
    private final Table m_table;
    private boolean m_fullDropdownTableSize = false;
    private final Listener m_comboListener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 12: {
                    if (CCombo3.this.m_popup.isDisposed()) break;
                    CCombo3.this.m_popup.dispose();
                    break;
                }
                case 10: {
                    CCombo3.this.doDropDown(false);
                    break;
                }
                case 11: {
                    CCombo3.this.doResize();
                }
            }
        }
    };
    private final Listener m_textListener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 3: {
                    if (System.currentTimeMillis() - CCombo3.this.m_createTime < 400L) {
                        event.detail = -1;
                        CCombo3.this.notifyListeners(8, event);
                        if (CCombo3.this.isDisposed()) break;
                        CCombo3.this.doDropDown(false);
                        break;
                    }
                    CCombo3.this.m_text.setCapture(true);
                    CCombo3.this.doDropDown(!CCombo3.this.isDropped());
                    break;
                }
                case 4: {
                    CCombo3.this.m_text.setCapture(false);
                    TableItem item = this.getItemUnderCursor(event);
                    if (item == null) break;
                    CCombo3.this.doDropDown(false);
                    CCombo3.this.sendSelectionEvent(event);
                    break;
                }
                case 8: {
                    if (event.detail == -1) break;
                    CCombo3.this.notifyListeners(8, event);
                    break;
                }
                case 5: {
                    TableItem item = this.getItemUnderCursor(event);
                    if (item == null) break;
                    CCombo3.this.m_table.setSelection(new TableItem[]{item});
                    break;
                }
                case 1: {
                    int selectionIndex = CCombo3.this.m_table.getSelectionIndex();
                    if (event.keyCode == 0x1000001) {
                        if (--selectionIndex < 0) {
                            selectionIndex = CCombo3.this.m_table.getItemCount() - 1;
                        }
                        CCombo3.this.m_table.setSelection(selectionIndex);
                        return;
                    }
                    if (event.keyCode == 0x1000002) {
                        CCombo3.this.m_table.setSelection((selectionIndex + 1) % CCombo3.this.m_table.getItemCount());
                        return;
                    }
                    if (event.character == '\r' || event.character == ' ') {
                        CCombo3.this.sendSelectionEvent(event);
                        return;
                    }
                    CCombo3.this.resendKeyEvent(event);
                    break;
                }
                case 2: {
                    CCombo3.this.resendKeyEvent(event);
                }
            }
        }

        private TableItem getItemUnderCursor(Event event) {
            Point displayLocation = CCombo3.this.m_text.toDisplay(new Point(event.x, event.y));
            Point tableLocation = CCombo3.this.m_table.toControl(displayLocation);
            return CCombo3.this.m_table.getItem(tableLocation);
        }
    };
    private final Listener m_arrowListener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 13: {
                    CCombo3.this.doDropDown(!CCombo3.this.isDropped());
                }
            }
        }
    };
    private final Listener m_tableListener = new Listener(){

        public void handleEvent(Event event) {
            switch (event.type) {
                case 13: {
                    CCombo3.this.doDropDown(false);
                    int index = CCombo3.this.m_table.getSelectionIndex();
                    CCombo3.this.select(index);
                    CCombo3.this.sendSelectionEvent(event);
                }
            }
        }
    };

    public CCombo3(Composite parent, int style) {
        super(parent, style);
        this.addEvents((Widget)this, this.m_comboListener, new int[]{12, 10, 11});
        this.m_text = new CImageLabel(this, 0);
        new DefaultControlActionsManager((Control)this.m_text);
        this.addEvents((Widget)this.m_text, this.m_textListener, new int[]{1, 2, 3, 4, 5, 8, 31, 15, 16});
        this.m_arrow = new Button((Composite)this, 1028);
        this.addEvents((Widget)this.m_arrow, this.m_arrowListener, new int[]{13, 15, 16});
        Shell shell = this.getShell();
        this.m_popup = new Shell(shell, 0);
        this.m_popup.setLayout((Layout)new FillLayout());
        this.m_table = new Table((Composite)this.m_popup, 65536);
        this.addEvents((Widget)this.m_table, this.m_tableListener, new int[]{13, 15, 16});
        new TableColumn(this.m_table, 0);
        final Listener filter = new Listener(){
            private boolean hasFocus;

            public void handleEvent(Event event) {
                boolean old_hasFocus = this.hasFocus;
                boolean bl = this.hasFocus = CCombo3.this.m_text.isFocusControl() || CCombo3.this.m_arrow.isFocusControl() || CCombo3.this.m_popup.isFocusControl() || CCombo3.this.m_table.isFocusControl();
                if (this.hasFocus) {
                    CCombo3.this.m_text.setBackground(IColorConstants.listSelection);
                    CCombo3.this.m_text.setForeground(IColorConstants.listSelectionText);
                } else {
                    CCombo3.this.m_text.setBackground(IColorConstants.listBackground);
                    CCombo3.this.m_text.setForeground(IColorConstants.listForeground);
                }
                if (old_hasFocus && !this.hasFocus) {
                    Event e = new Event();
                    e.widget = CCombo3.this;
                    e.time = event.time;
                    CCombo3.this.notifyListeners(16, e);
                }
            }
        };
        this.getDisplay().addFilter(15, filter);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                CCombo3.this.getDisplay().removeFilter(15, filter);
            }
        });
    }

    private void sendSelectionEvent(Event event) {
        Event e = new Event();
        e.time = event.time;
        e.stateMask = event.stateMask;
        this.notifyListeners(13, e);
    }

    private void resendKeyEvent(Event event) {
        Event e = new Event();
        e.time = event.time;
        e.character = event.character;
        e.keyCode = event.keyCode;
        e.stateMask = event.stateMask;
        this.notifyListeners(event.type, e);
    }

    private void addEvents(Widget widget, Listener listener, int[] events) {
        int i = 0;
        while (i < events.length) {
            widget.addListener(events[i], listener);
            ++i;
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void doDropDown(boolean drop) {
        if (drop == this.isDropped()) {
            return;
        }
        if (!drop) {
            this.m_popup.setVisible(false);
            this.m_text.setFocus();
            return;
        }
        Point comboSize = this.getSize();
        Point popupLocation = this.toDisplay(new Point(0, 0));
        popupLocation.y += comboSize.y;
        TableColumn tableColumn = this.m_table.getColumn(0);
        tableColumn.pack();
        this.m_table.pack();
        this.m_popup.pack();
        Rectangle tableBounds = this.m_table.getBounds();
        tableBounds.height = Math.min(tableBounds.height, this.m_table.getItemHeight() * 20);
        this.m_table.setBounds(tableBounds);
        int remainingDisplayHeight = this.getDisplay().getClientArea().height - popupLocation.y - 10;
        int preferredHeight = Math.min(tableBounds.height, remainingDisplayHeight);
        int remainingDisplayWidth = this.getDisplay().getClientArea().width - popupLocation.x - 5;
        int preferredWidth = this.isFullDropdownTableWidth() ? Math.min(tableBounds.width, remainingDisplayWidth) : comboSize.x;
        Rectangle popupBounds = this.m_popup.computeTrim(popupLocation.x, popupLocation.y, preferredWidth, preferredHeight);
        this.m_popup.setBounds(popupBounds);
        tableColumn.setWidth(this.m_table.getClientArea().width);
        this.m_popup.setVisible(true);
        this.m_table.showSelection();
    }

    public void startDrag() {
        this.m_text.setCapture(true);
    }

    public void setFullDropdownTableWidth(boolean freeTableSize) {
        this.m_fullDropdownTableSize = freeTableSize;
    }

    public boolean isFullDropdownTableWidth() {
        return this.m_fullDropdownTableSize;
    }

    public boolean isDropped() {
        return this.m_popup.isVisible();
    }

    public void setQuickSearch(boolean value) {
    }

    public void removeAll() {
        TableItem[] items = this.m_table.getItems();
        int index = 0;
        while (index < items.length) {
            TableItem item = items[index];
            item.dispose();
            ++index;
        }
    }

    public void add(String text) {
        this.add(text, null);
    }

    public void add(String text, Image image) {
        this.checkWidget();
        TableItem item = new TableItem(this.m_table, 0);
        item.setText(text);
        item.setImage(image);
    }

    public String getItem(int index) {
        this.checkWidget();
        return this.m_table.getItem(index).getText();
    }

    public int getItemCount() {
        this.checkWidget();
        return this.m_table.getItemCount();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.m_table.getSelectionIndex();
    }

    public void select(int index) {
        this.checkWidget();
        if (index == -1) {
            this.m_table.deselectAll();
            this.m_text.setText(null);
            this.m_text.setImage(null);
            return;
        }
        TableItem item = this.m_table.getItem(index);
        this.m_text.setText(item.getText());
        this.m_text.setImage(item.getImage());
        this.m_table.select(index);
    }

    public void setText(String text) {
        TableItem[] items = this.m_table.getItems();
        int index = 0;
        while (index < items.length) {
            TableItem item = items[index];
            if (item.getText().equals(text)) {
                this.select(index);
                return;
            }
            ++index;
        }
        this.select(-1);
    }

    protected void doResize() {
        Rectangle clientArea = this.getClientArea();
        int areaWidth = clientArea.width;
        int areaHeight = clientArea.height;
        Point buttonSize = this.m_arrow.computeSize(areaHeight, areaHeight);
        Point textSize = this.m_text.computeSize(areaWidth - buttonSize.x, areaHeight);
        this.m_arrow.setLocation(areaWidth - buttonSize.x, 0);
        this.m_arrow.setSize(buttonSize);
        this.m_text.setSize(areaWidth - buttonSize.x, Math.max(textSize.y, areaHeight));
    }
}

