/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor;

import java.text.MessageFormat;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.ModelMessages;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.AbstractTextPropertyEditor;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;

public final class ByteObjectPropertyEditor
extends AbstractTextPropertyEditor {
    public static final ByteObjectPropertyEditor INSTANCE = new ByteObjectPropertyEditor();

    private ByteObjectPropertyEditor() {
    }

    @Override
    public String getText(Property property) throws Exception {
        Object value = property.getValue();
        if (value == null) {
            return "null";
        }
        if (value instanceof Byte) {
            return value.toString();
        }
        return null;
    }

    @Override
    protected String getEditorText(Property property) throws Exception {
        return this.getText(property);
    }

    @Override
    protected boolean setEditorText(Property property, String text) throws Exception {
        Byte value;
        if ((text = text.trim()).length() == 0) {
            property.setValue(Property.UNKNOWN_VALUE);
            return true;
        }
        if (text.equals("null")) {
            property.setValue(null);
            return true;
        }
        try {
            value = Byte.valueOf(text);
        }
        catch (Throwable e) {
            UiUtils.openWarning(DesignerPlugin.getShell(), property.getTitle(), MessageFormat.format(ModelMessages.ByteObjectPropertyEditor_notValidByte, text));
            return false;
        }
        property.setValue(value);
        return true;
    }
}

