/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.testing.formatter;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormatter2;
import org.eclipse.xtext.formatting2.debug.TextRegionAccessToString;
import org.eclipse.xtext.formatting2.debug.TextRegionsToString;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.formatting2.regionaccess.TextRegionAccessBuilder;
import org.eclipse.xtext.formatting2.regionaccess.internal.TextRegions;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.serializer.impl.Serializer;
import org.eclipse.xtext.testing.formatter.FormatterTestRequest;
import org.eclipse.xtext.testing.util.ParseHelper;
import org.eclipse.xtext.util.ExceptionAcceptor;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.junit.Assert;

public class FormatterTestHelper {
    @Inject(optional=true)
    private Provider<IFormatter2> formatter;
    @Inject
    private Provider<FormatterTestRequest> formatterRequestProvider;
    @Inject
    private Provider<TextRegionAccessBuilder> textRegionBuilderProvider;
    @Inject
    private ParseHelper<EObject> parseHelper;
    @Inject
    private Serializer serializer;

    protected void assertAllWhitespaceIsFormatted(ITextRegionAccess access, List<ITextReplacement> replacements) {
        ArrayList expected = Lists.newArrayList();
        IHiddenRegion current = access.regionForRootEObject().getPreviousHiddenRegion();
        while (current != null) {
            expected.addAll(current.getMergedSpaces());
            current = current.getNextHiddenRegion();
        }
        List missing = TextRegions.difference((Iterable)expected, replacements);
        if (!missing.isEmpty()) {
            TextRegionsToString toString = new TextRegionsToString().setTextRegionAccess(access);
            for (ITextSegment region : missing) {
                toString.add(region, region.getClass().getSimpleName());
            }
            String msg = "The following regions are not formatted:\n" + toString;
            System.err.println(msg);
            Assert.fail((String)msg);
        }
    }

    public void assertFormatted(FormatterTestRequest req) {
        Preconditions.checkNotNull((Object)req);
        Preconditions.checkNotNull((Object)req.getToBeFormatted());
        FormatterRequest request = req.getRequest();
        Preconditions.checkArgument((request.getTextRegionAccess() == null ? 1 : 0) != 0);
        String document = req.getToBeFormatted().toString();
        XtextResource parsed = this.parse(document);
        if (req.isAllowSyntaxErrors()) {
            if (request.getExplicitExceptionHandler() == null) {
                request.setExceptionHandler((IAcceptor)ExceptionAcceptor.IGNORING);
            }
        } else {
            this.assertNoSyntaxErrors(parsed);
            if (request.getExplicitExceptionHandler() == null) {
                request.setExceptionHandler((IAcceptor)ExceptionAcceptor.THROWING);
            }
        }
        if (!req.isAllowUnformattedWhitespace()) {
            request.setAllowIdentityEdits(true);
        }
        request.setTextRegionAccess(this.createRegionAccess(parsed, req));
        if (request.getPreferences() == null) {
            request.setPreferences((ITypedPreferenceValues)new MapBasedPreferenceValues((Map)Maps.newLinkedHashMap()));
        }
        List replacements = this.createFormatter(req).format(request);
        this.assertReplacementsAreInRegion(replacements, request.getRegions(), document);
        if (!req.isAllowUnformattedWhitespace()) {
            this.assertAllWhitespaceIsFormatted(request.getTextRegionAccess(), replacements);
        }
        String formatted = request.getTextRegionAccess().getRewriter().renderToString((Iterable)replacements);
        Assert.assertEquals((Object)req.getExpectationOrToBeFormatted().toString(), (Object)formatted);
    }

    public void assertFormatted(Procedures.Procedure1<FormatterTestRequest> init) {
        FormatterTestRequest request = (FormatterTestRequest)this.formatterRequestProvider.get();
        init.apply((Object)request);
        this.assertFormatted(request);
    }

    protected void assertNoSyntaxErrors(XtextResource resource) {
        Iterable syntaxErrors = resource.getParseResult().getSyntaxErrors();
        if (!Iterables.isEmpty((Iterable)syntaxErrors)) {
            StringBuilder builder = new StringBuilder();
            builder.append("This document can't be formatted because of syntax errors:\n");
            for (INode node : syntaxErrors) {
                SyntaxErrorMessage msg = node.getSyntaxErrorMessage();
                builder.append(String.format("Line %02d: %s\n", node.getTotalStartLine(), msg.getMessage()));
            }
            this.fail(builder, resource.getParseResult().getRootNode().getText());
        }
    }

    protected void assertReplacementsAreInRegion(List<ITextReplacement> rep, Collection<ITextRegion> regions, String doc) {
        HashSet invalid = Sets.newHashSet();
        block0: for (ITextRegion allowed : regions) {
            for (ITextReplacement r : rep) {
                if (allowed.contains((ITextRegion)r)) continue block0;
                invalid.add(r);
            }
        }
        if (!invalid.isEmpty()) {
            String visualized = new TextRegionsToString().addAllReplacements((Iterable)invalid).toString();
            this.fail("One or more TextReplacements are outside of the allowed region. Region: " + regions, visualized);
        }
    }

    protected IFormatter2 createFormatter(FormatterTestRequest request) {
        Preconditions.checkNotNull(this.formatter, (Object)("There is a Guice Binding missing for " + IFormatter2.class.getName()));
        return (IFormatter2)this.formatter.get();
    }

    protected ITextRegionAccess createRegionAccess(XtextResource resource, FormatterTestRequest req) {
        boolean useSerializer;
        boolean bl = useSerializer = req.isUseSerializer() && !req.isAllowSyntaxErrors();
        if (req.isUseNodeModel() && useSerializer) {
            ITextRegionAccess nmRegions = this.createRegionAccessViaNodeModel(resource);
            ITextRegionAccess serRegions = this.createRegionAccessViaSerializer(resource);
            String nmString = this.toString(nmRegions);
            String serString = this.toString(serRegions);
            Assert.assertEquals((Object)nmString, (Object)serString);
            return nmRegions;
        }
        if (req.isUseNodeModel()) {
            ITextRegionAccess nmRegions = this.createRegionAccessViaNodeModel(resource);
            return nmRegions;
        }
        if (useSerializer) {
            ITextRegionAccess serRegions = this.createRegionAccessViaSerializer(resource);
            return serRegions;
        }
        throw new IllegalStateException("Can't format anything when using neither NodeModel nor Serializer.");
    }

    protected ITextRegionAccess createRegionAccessViaNodeModel(XtextResource resource) {
        ITextRegionAccess access = ((TextRegionAccessBuilder)this.textRegionBuilderProvider.get()).forNodeModel(resource).create();
        return access;
    }

    protected ITextRegionAccess createRegionAccessViaSerializer(XtextResource resource) {
        EObject root = (EObject)resource.getContents().get(0);
        ITextRegionAccess regionAccess = this.serializer.serializeToRegions(root);
        return regionAccess;
    }

    protected void fail(CharSequence error, CharSequence document) {
        StringBuilder builder = new StringBuilder(Strings.trimTrailingLineBreak((CharSequence)error));
        if (document != null) {
            builder.append("\n----------------------------------------------------------\n");
            builder.append(Strings.trimTrailingLineBreak((CharSequence)document));
            builder.append("\n----------------------------------------------------------");
        }
        String msg = builder.toString();
        System.err.println(msg);
        Assert.fail((String)msg);
    }

    protected XtextResource parse(String document) {
        try {
            return (XtextResource)this.parseHelper.parse(document).eResource();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String toString(ITextRegionAccess nmRegions) {
        return new TextRegionAccessToString().withRegionAccess(nmRegions).hideColumnExplanation() + "\n";
    }
}

