/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal.html.table;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.jacoco.core.analysis.CounterComparator;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.report.internal.ReportOutputFolder;
import org.jacoco.report.internal.html.HTMLElement;
import org.jacoco.report.internal.html.resources.Resources;
import org.jacoco.report.internal.html.table.IColumnRenderer;
import org.jacoco.report.internal.html.table.ITableItem;
import org.jacoco.report.internal.html.table.TableItemComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CounterColumn
implements IColumnRenderer {
    private final ICoverageNode.CounterEntity entity;
    private final NumberFormat integerFormat;
    private final Comparator<ITableItem> comparator;

    public static CounterColumn newTotal(ICoverageNode.CounterEntity entity, Locale locale) {
        return new CounterColumn(entity, locale, (Comparator)CounterComparator.TOTALITEMS.reverse().on(entity)){

            protected int getValue(ICounter counter) {
                return counter.getTotalCount();
            }
        };
    }

    public static CounterColumn newMissed(ICoverageNode.CounterEntity entity, Locale locale) {
        return new CounterColumn(entity, locale, (Comparator)CounterComparator.MISSEDITEMS.reverse().on(entity)){

            protected int getValue(ICounter counter) {
                return counter.getMissedCount();
            }
        };
    }

    public static CounterColumn newCovered(ICoverageNode.CounterEntity entity, Locale locale) {
        return new CounterColumn(entity, locale, (Comparator)CounterComparator.COVEREDITEMS.reverse().on(entity)){

            protected int getValue(ICounter counter) {
                return counter.getCoveredCount();
            }
        };
    }

    protected CounterColumn(ICoverageNode.CounterEntity entity, Locale locale, Comparator<ICoverageNode> comparator) {
        this.entity = entity;
        this.integerFormat = NumberFormat.getIntegerInstance(locale);
        this.comparator = new TableItemComparator(comparator);
    }

    @Override
    public boolean init(List<? extends ITableItem> items, ICoverageNode total) {
        for (ITableItem iTableItem : items) {
            if (iTableItem.getNode().getCounter(this.entity).getTotalCount() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void footer(HTMLElement td, ICoverageNode total, Resources resources, ReportOutputFolder base) throws IOException {
        this.cell(td, total);
    }

    @Override
    public void item(HTMLElement td, ITableItem item, Resources resources, ReportOutputFolder base) throws IOException {
        this.cell(td, item.getNode());
    }

    private void cell(HTMLElement td, ICoverageNode node) throws IOException {
        int value = this.getValue(node.getCounter(this.entity));
        td.text(this.integerFormat.format(value));
    }

    @Override
    public Comparator<ITableItem> getComparator() {
        return this.comparator;
    }

    protected abstract int getValue(ICounter var1);
}

