/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.cdt.core.parser.util.StringUtil;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.gdb.service.GDBBackend;
import org.eclipse.cdt.dsf.gdb.service.Messages;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;

public class GDBBackend_7_12
extends GDBBackend {
    private PTY fMIPty;
    private PTY fCLIPty;
    private boolean fPtyFailure;
    private InputStream fDummyErrorStream;

    public GDBBackend_7_12(DsfSession session, ILaunchConfiguration lc) {
        super(session, lc);
        this.createPty();
    }

    @Override
    public boolean isFullGdbConsoleSupported() {
        return System.getenv("FLATPAK_SANDBOX_DIR") == null && !Platform.getOS().equals("win32") && !Platform.getOS().equals("macosx") && !this.fPtyFailure;
    }

    @Override
    public boolean useTargetAsync() {
        return this.isFullGdbConsoleSupported() || Platform.getOS().equals("win32") && this.getSessionType() == SessionType.REMOTE;
    }

    protected void createPty() {
        if (!this.isFullGdbConsoleSupported()) {
            return;
        }
        try {
            this.fMIPty = new PTY();
            this.fMIPty.validateSlaveName();
            this.fDummyErrorStream = new InputStream(){

                @Override
                public int read() throws IOException {
                    return -1;
                }
            };
        }
        catch (IOException e) {
            this.fMIPty = null;
            this.fPtyFailure = true;
            GdbPlugin.log((IStatus)new Status(1, "org.eclipse.cdt.dsf.gdb", NLS.bind((String)Messages.PTY_Console_not_available, (Object)e.getMessage())));
        }
    }

    @Override
    public OutputStream getMIOutputStream() {
        if (this.fMIPty == null) {
            return super.getMIOutputStream();
        }
        return this.fMIPty.getOutputStream();
    }

    @Override
    public InputStream getMIInputStream() {
        if (this.fMIPty == null) {
            return super.getMIInputStream();
        }
        return this.fMIPty.getInputStream();
    }

    @Override
    public InputStream getMIErrorStream() {
        if (this.fMIPty == null) {
            return super.getMIErrorStream();
        }
        return this.fDummyErrorStream;
    }

    @Override
    public String[] getDebuggerCommandLineArray() {
        String[] originalCommandLine = super.getDebuggerCommandLineArray();
        if (!this.isFullGdbConsoleSupported()) {
            return originalCommandLine;
        }
        String[] extraArguments = new String[]{"-q", "--interpreter", "console", "-ex", "new-ui mi " + this.fMIPty.getSlaveName(), "-ex", "set pagination off", "-ex", "show version"};
        int oriLength = originalCommandLine.length;
        int extraLength = extraArguments.length;
        String[] newCommandLine = new String[oriLength + extraLength];
        System.arraycopy(originalCommandLine, 0, newCommandLine, 0, oriLength);
        System.arraycopy(extraArguments, 0, newCommandLine, oriLength, extraLength);
        return newCommandLine;
    }

    @Override
    protected Process launchGDBProcess() throws CoreException {
        if (!this.isFullGdbConsoleSupported()) {
            return super.launchGDBProcess();
        }
        Process proc = null;
        String[] commandLine = this.getDebuggerCommandLineArray();
        try {
            this.fCLIPty = new PTY(PTY.Mode.TERMINAL);
            IPath path = this.getGDBWorkingDirectory();
            proc = ProcessFactory.getFactory().exec(commandLine, this.getGDBLaunch().getLaunchEnvironment(), new File(path != null ? path.toOSString() : ""), this.fCLIPty);
        }
        catch (IOException e) {
            String message = "Error while launching command: " + StringUtil.join((String[])commandLine, (String)" ");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, message, (Throwable)e));
        }
        return proc;
    }

    @Override
    public PTY getProcessPty() {
        return this.fCLIPty;
    }
}

