/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.runtime.internal.model.decorator;

import org.eclipse.jst.jsf.common.runtime.internal.model.types.ClassTypeInfo;

public class ConverterTypeInfo
extends ClassTypeInfo {
    private static final long serialVersionUID = -7238952424045449907L;
    private static final String[] NO_FOR_CLASS = new String[0];
    private final String _converterId;
    private final String[] _forClasses;
    public static final ConverterTypeInfo UNKNOWN = new ConverterTypeInfo(null);

    public ConverterTypeInfo(String className, String converterId) {
        super(className, new String[0], new String[0]);
        if (className == null && converterId == null) {
            throw new IllegalArgumentException("converterClass and converterId must not both be null.  For unknown validator use the UNKNOWN constant");
        }
        this._converterId = converterId;
        this._forClasses = NO_FOR_CLASS;
    }

    public ConverterTypeInfo(String className, String[] superClasses, String[] interfaces, String converterId, String[] forClass) {
        super(className, superClasses, interfaces);
        if (className == null && converterId == null) {
            throw new IllegalArgumentException("converterClass and converterId must not both be null.  For unknown validator use the UNKNOWN constant");
        }
        this._converterId = converterId;
        this._forClasses = forClass == null ? NO_FOR_CLASS : forClass;
    }

    private ConverterTypeInfo(Object unresolved) {
        super(null, new String[0], new String[0]);
        this._converterId = null;
        this._forClasses = NO_FOR_CLASS;
    }

    public final String getConverterId() {
        return this._converterId;
    }

    public final String[] getForClass() {
        String[] returnArray = new String[this._forClasses.length];
        System.arraycopy(this._forClasses, 0, returnArray, 0, this._forClasses.length);
        return returnArray;
    }

    @Override
    public String toString() {
        String toString = "";
        if (this._forClasses.length > 0) {
            toString = "For-Classes: [";
            int i = 0;
            while (i < this._forClasses.length) {
                toString = String.valueOf(toString) + this._forClasses[i];
                if (i < this._forClasses.length - 1) {
                    toString = String.valueOf(toString) + ", ";
                }
                ++i;
            }
            toString = String.valueOf(toString) + "], ";
        }
        return String.valueOf(toString) + "Converter Type Info: type = " + this._converterId + ", " + super.toString();
    }
}

