/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.views;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.ToolTip;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;

public class SpyView
extends ViewPart {
    private StyledText output;
    private Action spyAction;
    private Action fullyQualifiedAction;
    private Listener keyFilter;
    private Runnable timer;
    private Control lastControl;
    private Field field;
    static final int TIMEOUT = 100;
    private static final ImageDescriptor SPY_IMAGE_DESCRIPTOR = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.swt.tools.spies"), (IPath)new Path("icons/spy.png"), null));

    public void createPartControl(Composite parent) {
        this.output = new StyledText(parent, 778);
        this.keyFilter = e -> {
            if (e.keyCode == 46 && e.stateMask == 458752) {
                if (this.spyAction.isChecked()) {
                    this.spyAction.setChecked(false);
                } else {
                    this.spyAction.setChecked(true);
                    this.spyAction.run();
                }
                e.type = 0;
            }
        };
        parent.getDisplay().addFilter(1, this.keyFilter);
        this.timer = new Runnable(){

            @Override
            public void run() {
                if (SpyView.this.output == null || SpyView.this.output.isDisposed() || !SpyView.this.spyAction.isChecked()) {
                    return;
                }
                Display display = SpyView.this.output.getDisplay();
                Control control = display.getCursorControl();
                if (control != SpyView.this.lastControl) {
                    StringBuilder text = new StringBuilder();
                    if (control != null) {
                        Error error;
                        Composite parent;
                        int n;
                        text.append(SpyView.this.getName(control) + "@" + SpyView.this.getOSHandle(control) + "\n");
                        text.append("\tStyle: " + SpyView.this.getStyle((Widget)control) + "\n");
                        text.append("\tLayout Data: " + SpyView.this.getName(control.getLayoutData()) + "\n");
                        text.append("\tBounds: " + String.valueOf(control.getBounds()) + "\n");
                        if (control instanceof Composite && ((Composite)control).getLayout() != null) {
                            text.append("\tLayout: " + SpyView.this.getName(((Composite)control).getLayout()) + "\n");
                        }
                        text.append("\n");
                        if (control instanceof Composite) {
                            text.append("\nChildren:\n");
                            Control[] controlArray = ((Composite)control).getChildren();
                            n = controlArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Control element = controlArray[n2];
                                text.append("\t" + SpyView.this.getName(element) + "\n");
                                ++n2;
                            }
                        }
                        if ((parent = control.getParent()) != null) {
                            text.append("\nPeers:\n");
                            Control[] controlArray = parent.getChildren();
                            int n3 = controlArray.length;
                            n = 0;
                            while (n < n3) {
                                Control peer = controlArray[n];
                                text.append("\t");
                                if (peer == control) {
                                    text.append("*");
                                }
                                text.append(SpyView.this.getName(peer) + "@" + SpyView.this.getOSHandle(peer));
                                text.append(" Layout Data: " + SpyView.this.getName(peer.getLayoutData()));
                                text.append(" Bounds: " + String.valueOf(peer.getBounds()));
                                text.append("\n");
                                ++n;
                            }
                            text.append("\nParent Tree:\n");
                            Composite[] parents = new Composite[]{};
                            while (parent != null) {
                                Composite[] newParents = new Composite[parents.length + 1];
                                System.arraycopy(parents, 0, newParents, 0, parents.length);
                                newParents[parents.length] = parent;
                                parents = newParents;
                                parent = parent.getParent();
                            }
                            int i = parents.length - 1;
                            while (i >= 0) {
                                Object prefix = "\t";
                                int j = 0;
                                while (j < parents.length - i - 1) {
                                    prefix = (String)prefix + "\t";
                                    ++j;
                                }
                                text.append((String)prefix + SpyView.this.getName(parents[i]) + "@" + SpyView.this.getOSHandle((Control)parents[i]) + "\n");
                                text.append((String)prefix + "\t Style: " + SpyView.this.getStyle((Widget)parents[i]) + "\n");
                                text.append((String)prefix + "\t Bounds: " + String.valueOf(parents[i].getBounds()) + "\n");
                                text.append((String)prefix + "\t Layout: " + SpyView.this.getName(parents[i].getLayout()) + "\n");
                                text.append((String)prefix + "\t LayoutData: " + SpyView.this.getName(parents[i].getLayoutData()) + "\n");
                                --i;
                            }
                        }
                        if ((error = (Error)control.getData("StackTrace")) != null) {
                            text.append("\nCreation Stack Trace:\n");
                            ByteArrayOutputStream stream = new ByteArrayOutputStream();
                            PrintStream s = new PrintStream(stream);
                            error.printStackTrace(s);
                            text.append(stream.toString());
                        }
                    }
                    SpyView.this.output.setText(text.toString());
                }
                SpyView.this.lastControl = control;
                display.timerExec(100, (Runnable)this);
            }
        };
        this.makeActions();
        this.contributeToActionBars();
    }

    String getName(Object object) {
        int index;
        if (object == null) {
            return "null";
        }
        Object name = object.toString();
        if (this.fullyQualifiedAction.isChecked() && (index = ((String)name).indexOf(32)) >= 0 && ((String)name).length() >= 1) {
            name = object.getClass().getName() + ((String)name).substring(index);
        }
        return name;
    }

    public void setFocus() {
        if (this.output != null & !this.output.isDisposed()) {
            this.output.setFocus();
        }
    }

    private String getOSHandle(Control control) {
        if (this.field == null) {
            String[] stringArray = new String[]{"handle", "view"};
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fieldName = stringArray[n2];
                try {
                    this.field = control.getClass().getField(fieldName);
                    if (this.field != null) {
                        break;
                    }
                }
                catch (Throwable throwable) {}
                ++n2;
            }
        }
        try {
            return this.field.get(control).toString();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    public void dispose() {
        if (this.keyFilter != null) {
            Display.getCurrent().removeFilter(1, this.keyFilter);
        }
        super.dispose();
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.spyAction);
        manager.add((IAction)this.fullyQualifiedAction);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.spyAction);
    }

    private void makeActions() {
        this.spyAction = new Action("Spy", 2){

            public void run() {
                Display.getCurrent().timerExec(100, SpyView.this.timer);
            }
        };
        this.spyAction.setToolTipText("Toggle Spy (CONTROL+ALT+SHIFT+.)");
        this.spyAction.setImageDescriptor(SPY_IMAGE_DESCRIPTOR);
        this.fullyQualifiedAction = new Action("Fully Qualify Names", 2){

            public void run() {
            }
        };
    }

    private String getStyle(Widget w) {
        int lastOr;
        int style = w.getStyle();
        Object result = "";
        if (style == -1) {
            return "DEFAULT - bad!";
        }
        if ((style & 2) != 0) {
            result = w instanceof CTabFolder || w instanceof StyledText || w instanceof List || w instanceof Text || w instanceof Table || w instanceof Tree ? (String)result + "MULTI | " : (w instanceof Menu ? (String)result + "BAR | " : (w instanceof Label || w instanceof MenuItem || w instanceof ToolItem ? (String)result + "SEPARATOR | " : (w instanceof Button ? (String)result + "TOGGLE | " : (w instanceof ProgressBar ? (String)result + "INDETERMINATE | " : (String)result + "BAR or SEPARATOR or TOGGLE or MULTI or INDETERMINATE or DBCS | "))));
        }
        if ((style & 4) != 0) {
            result = w instanceof Menu || w instanceof ToolItem || w instanceof CoolItem || w instanceof Combo ? (String)result + "DROP_DOWN | " : (w instanceof Button ? (String)result + "ARROW | " : (w instanceof CTabFolder || w instanceof StyledText || w instanceof List || w instanceof Text || w instanceof Table || w instanceof Tree ? (String)result + "SINGLE | " : (w instanceof Label || w instanceof Group ? (String)result + "SHADOW_IN | " : (w instanceof Decorations ? (String)result + "TOOL | " : (String)result + "ALPHA or TOOL or SINGLE or ARROW or DROP_DOWN or SHADOW_IN | "))));
        }
        if ((style & 8) != 0) {
            result = w instanceof Menu ? (String)result + "POP_UP | " : (w instanceof Button || w instanceof MenuItem || w instanceof ToolItem ? (String)result + "PUSH | " : (w instanceof Combo || w instanceof Text || w instanceof StyledText ? (String)result + "READ_ONLY | " : (w instanceof Label || w instanceof Group || w instanceof ToolBar ? (String)result + "SHADOW_OUT | " : (w instanceof Decorations ? (String)result + "NO_TRIM | " : (String)result + "POP_UP or PUSH or READ_ONLY or SHADOW_OUT or NO_TRIM or NATIVE | "))));
        }
        if ((style & 0x10) != 0) {
            result = w instanceof Button || w instanceof MenuItem || w instanceof ToolItem ? (String)result + "RADIO | " : (w instanceof Group ? (String)result + "SHADOW_ETCHED_IN | " : (w instanceof Decorations || w instanceof Tracker ? (String)result + "RESIZE | " : (String)result + "RESIZE or SHADOW_ETCHED_IN or RADIO or PHONETIC | "));
        }
        if ((style & 0x20) != 0) {
            result = w instanceof Button || w instanceof MenuItem || w instanceof ToolItem || w instanceof Table || w instanceof Tree ? (String)result + "CHECK | " : (w instanceof Label || w instanceof Group ? (String)result + "SHADOW_NONE | " : (w instanceof Decorations ? (String)result + "TITLE | " : (w instanceof DateTime ? (String)result + "DATE | " : (String)result + "ROMAN or CHECK  or SHADOW_NONE or TITLE | ")));
        }
        if ((style & 0x40) != 0) {
            result = w instanceof MenuItem ? (String)result + "CASCADE | " : (w instanceof StyledText || w instanceof Label || w instanceof Text || w instanceof ToolBar ? (String)result + "WRAP | " : (w instanceof Combo ? (String)result + "SIMPLE | " : (w instanceof Group ? (String)result + "SHADOW_ETCHED_OUT | " : (w instanceof Decorations || w instanceof CTabFolder || w instanceof CTabItem ? (String)result + "CLOSE | " : (String)result + "CLOSE or MENU or CASCADE or WRAP or SIMPLE or SHADOW_ETCHED_OUT | "))));
        }
        if ((style & 0x80) != 0) {
            result = w instanceof Decorations ? (String)result + "MIN | " : (w instanceof Button || w instanceof Tracker ? (String)result + "UP | " : (w instanceof CTabFolder ? (String)result + "TOP | " : (w instanceof DateTime ? (String)result + "TIME | " : (String)result + "MIN or UP or TOP | ")));
        }
        if ((style & 0x100) != 0) {
            result = (String)result + "HORIZONTAL | ";
        }
        if ((style & 0x200) != 0) {
            result = (String)result + "VERTICAL | ";
        }
        if ((style & 0x400) != 0) {
            result = w instanceof Decorations ? (String)result + "MAX | " : (w instanceof Button || w instanceof Tracker ? (String)result + "DOWN | " : (w instanceof CTabFolder ? (String)result + "BOTTOM | " : (w instanceof DateTime ? (String)result + "CALENDAR | " : (String)result + "MAX or DOWN or BOTTOM | ")));
        }
        if ((style & 0x800) != 0) {
            result = (String)result + "BORDER | ";
        }
        if ((style & 0x1000) != 0) {
            result = w instanceof ToolTip ? (String)result + "BALLOON | " : (String)result + "CLIP_CHILDREN | ";
        }
        if ((style & 0x2000) != 0) {
            result = (String)result + "CLIP_SIBLINGS | ";
        }
        if ((style & 0x4000) != 0) {
            result = (String)result + "ON_TOP or LEAD or LEFT | ";
        }
        if ((style & 0x8000) != 0) {
            result = w instanceof Shell ? (String)result + "PRIMARY_MODAL | " : (w instanceof Table || w instanceof Tree ? (String)result + "HIDE_SELECTION | " : (w instanceof DateTime ? (String)result + "SHORT | " : (String)result + "PRIMARY_MODAL or HIDE_SELECTION | "));
        }
        if ((style & 0x10000) != 0) {
            result = w instanceof StyledText || w instanceof Table || w instanceof Tree ? (String)result + "FULL_SELECTION | " : (w instanceof Shell ? (String)result + "APPLICATION_MODAL | " : (w instanceof ProgressBar ? (String)result + "SMOOTH | " : (w instanceof DateTime ? (String)result + "MEDIUM | " : (String)result + "FULL_SELECTION or SMOOTH or APPLICATION_MODAL | ")));
        }
        if ((style & 0x20000) != 0) {
            result = w instanceof Shell ? (String)result + "SYSTEM_MODAL | " : (w instanceof Button || w instanceof Label || w instanceof TableColumn || w instanceof Tracker || w instanceof ToolBar ? (String)result + "TRAIL | " : (String)result + "SYSTEM_MODAL or TRAIL or RIGHT | ");
        }
        if ((style & 0x40000) != 0) {
            result = (String)result + "NO_BACKGROUND | ";
        }
        if ((style & 0x80000) != 0) {
            result = (String)result + "NO_FOCUS | ";
        }
        if ((style & 0x100000) != 0) {
            result = (String)result + "NO_REDRAW_RESIZE | ";
        }
        if ((style & 0x200000) != 0) {
            result = (String)result + "NO_MERGE_PAINTS | ";
        }
        if ((style & 0x400000) != 0) {
            result = w instanceof Text ? (String)result + "PASSWORD | " : (w instanceof Composite ? (String)result + "NO_RADIO_GROUP | " : (String)result + "NO_RADIO_GROUP or PASSWORD | ");
        }
        if ((style & 0x800000) != 0) {
            result = (String)result + "FLAT | ";
        }
        if ((style & 0x1000000) != 0) {
            result = w instanceof Button || w instanceof Label || w instanceof TableColumn ? (String)result + "CENTER | " : (String)result + "EMBEDDED or CENTER | ";
        }
        if ((style & 0x2000000) != 0) {
            result = (String)result + "LEFT_TO_RIGHT | ";
        }
        if ((style & 0x4000000) != 0) {
            result = (String)result + "RIGHT_TO_LEFT | ";
        }
        if ((style & 0x8000000) != 0) {
            result = (String)result + "MIRRORED | ";
        }
        if ((style & 0x10000000) != 0) {
            result = w instanceof DateTime ? (String)result + "LONG | " : (String)result + "VIRTUAL | ";
        }
        if ((style & 0x20000000) != 0) {
            result = (String)result + "DOUBLE_BUFFERED | ";
        }
        if ((lastOr = ((String)result).lastIndexOf("|")) == ((String)result).length() - 2) {
            result = ((String)result).substring(0, ((String)result).length() - 2);
        }
        return result;
    }
}

