/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.rcp.swing2swt.layout;

import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.core.editor.actions.assistant.AbstractAssistantPage;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.JavaInfoAddProperties;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.StringComboPropertyEditor;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.rcp.swing2swt.Messages;
import org.eclipse.wb.internal.rcp.swing2swt.layout.BorderLayoutAssistantPage;
import org.eclipse.wb.internal.swt.model.layout.ILayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.LayoutAssistantSupport;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;

public final class BorderLayoutInfo
extends LayoutInfo {
    private final BorderLayoutInfo m_this = this;
    private static final String[] REGION_TITLES = new String[]{Messages.BorderLayout_north, Messages.BorderLayout_south, Messages.BorderLayout_west, Messages.BorderLayout_east, Messages.BorderLayout_center};
    private static final String[] REGION_FIELDS = new String[]{"NORTH", "SOUTH", "WEST", "EAST", "CENTER"};
    private static final PropertyEditor m_regionPropertyEditor = new StringComboPropertyEditor(REGION_TITLES);

    public BorderLayoutInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
        this.contributeProperty();
        this.supportLayoutAssistant();
    }

    private void supportLayoutAssistant() {
        new LayoutAssistantSupport((ILayoutInfo)this){

            protected AbstractAssistantPage createLayoutPage(Composite parent) {
                return new BorderLayoutAssistantPage(parent, this.m_layout);
            }
        };
    }

    public ControlInfo getControl(String region) throws Exception {
        String fieldName = String.valueOf(region.toLowerCase()) + "Child";
        Object control = ReflectionUtils.getFieldObject((Object)this.getObject(), (String)fieldName);
        return (ControlInfo)this.getComposite().getChildByObject(control);
    }

    protected void deleteLayoutData(ControlInfo control) throws Exception {
        super.deleteLayoutData(control);
        control.removeMethodInvocations("setLayoutData(java.lang.Object)");
    }

    public void command_CREATE(ControlInfo control, String region) throws Exception {
        super.command_CREATE(control, null);
        this.command_REGION(control, region);
    }

    public void command_MOVE(ControlInfo control, String region) throws Exception {
        if (control.getParent() != this.getComposite()) {
            super.command_MOVE(control, null);
        }
        this.command_REGION(control, region);
    }

    private void command_REGION(ControlInfo control, String region) throws Exception {
        String layoutDataSource = "swing2swt.layout.BorderLayout." + region;
        control.removeMethodInvocations("setLayoutData(java.lang.Object)");
        control.addMethodInvocation("setLayoutData(java.lang.Object)", layoutDataSource);
    }

    private void contributeProperty() {
        this.addBroadcastListener(new JavaInfoAddProperties(){

            /*
             * WARNING - void declaration
             */
            public void invoke(JavaInfo javaInfo, List<Property> properties) throws Exception {
                JavaInfo javaInfo2 = javaInfo;
                if (javaInfo2 instanceof ControlInfo) {
                    ControlInfo controlInfo = (ControlInfo)javaInfo2;
                    ControlInfo cfr_ignored_0 = (ControlInfo)javaInfo2;
                    if (BorderLayoutInfo.this.isActiveOnComposite(javaInfo.getParent())) {
                        void control;
                        Property constraintsProperty = (Property)control.getArbitraryValue((Object)BorderLayoutInfo.this.m_this);
                        if (constraintsProperty == null) {
                            constraintsProperty = new RegionProperty((ControlInfo)control);
                            control.putArbitraryValue((Object)BorderLayoutInfo.this.m_this, (Object)constraintsProperty);
                        }
                        properties.add(constraintsProperty);
                    }
                }
            }
        });
    }

    private final class RegionProperty
    extends Property {
        private final ControlInfo m_control;

        public RegionProperty(ControlInfo control) {
            super(m_regionPropertyEditor);
            this.m_control = control;
            this.setCategory(PropertyCategory.system((int)6));
        }

        public String getTitle() {
            return "Region";
        }

        public Object getValue() throws Exception {
            int i = 0;
            while (i < REGION_FIELDS.length) {
                String region = REGION_FIELDS[i];
                if (BorderLayoutInfo.this.getControl(region) == this.m_control) {
                    return REGION_TITLES[i];
                }
                ++i;
            }
            return "";
        }

        public boolean isModified() throws Exception {
            return true;
        }

        public void setValue(final Object value) throws Exception {
            ExecutionUtils.run((ObjectInfo)this.m_control, (RunnableEx)new RunnableEx(){

                public void run() throws Exception {
                    int i = 0;
                    while (i < REGION_TITLES.length) {
                        String title = REGION_TITLES[i];
                        if (title.equals(value)) {
                            BorderLayoutInfo.this.command_REGION(RegionProperty.this.m_control, REGION_FIELDS[i]);
                        }
                        ++i;
                    }
                }
            });
        }
    }
}

