/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.i18n.client.impl;

import java.util.Date;

public class DateRecord
extends Date {
    private static final long serialVersionUID = -1278816193740448162L;
    public static final int AM = 0;
    public static final int PM = 1;
    private static final int JS_START_YEAR = 1900;
    private int era = -1;
    private int year = Integer.MIN_VALUE;
    private int month = -1;
    private int dayOfMonth = -1;
    private int ampm = -1;
    private int hours = -1;
    private int minutes = -1;
    private int seconds = -1;
    private int milliseconds = -1;
    private int tzOffset = Integer.MIN_VALUE;
    private int dayOfWeek = -1;
    private boolean ambiguousYear = false;

    public boolean calcDate(Date date, boolean strict) {
        if (this.era == 0 && this.year > 0) {
            this.year = -(this.year - 1);
        }
        if (this.year > Integer.MIN_VALUE) {
            date.setYear(this.year - 1900);
        }
        int orgDayOfMonth = date.getDate();
        date.setDate(1);
        if (this.month >= 0) {
            date.setMonth(this.month);
        }
        if (this.dayOfMonth >= 0) {
            date.setDate(this.dayOfMonth);
        } else if (this.month >= 0) {
            Date tmp = new Date(date.getYear(), date.getMonth(), 35);
            int daysInCurrentMonth = 35 - tmp.getDate();
            date.setDate(Math.min(daysInCurrentMonth, orgDayOfMonth));
        } else {
            date.setDate(orgDayOfMonth);
        }
        if (this.hours < 0) {
            this.hours = date.getHours();
        }
        if (this.ampm > 0 && this.hours < 12) {
            this.hours += 12;
        }
        date.setHours(this.hours);
        if (this.minutes >= 0) {
            date.setMinutes(this.minutes);
        }
        if (this.seconds >= 0) {
            date.setSeconds(this.seconds);
        }
        if (this.milliseconds >= 0) {
            date.setTime(date.getTime() / 1000L * 1000L + (long)this.milliseconds);
        }
        if (strict) {
            if (this.year > Integer.MIN_VALUE && this.year - 1900 != date.getYear()) {
                return false;
            }
            if (this.month >= 0 && this.month != date.getMonth()) {
                return false;
            }
            if (this.dayOfMonth >= 0 && this.dayOfMonth != date.getDate()) {
                return false;
            }
            if (this.hours >= 24) {
                return false;
            }
            if (this.minutes >= 60) {
                return false;
            }
            if (this.seconds >= 60) {
                return false;
            }
            if (this.milliseconds >= 1000) {
                return false;
            }
        }
        if (this.ambiguousYear) {
            Date defaultCenturyStart = new Date();
            defaultCenturyStart.setYear(defaultCenturyStart.getYear() - 80);
            if (date.before(defaultCenturyStart)) {
                date.setYear(defaultCenturyStart.getYear() + 100);
            }
        }
        if (this.dayOfWeek >= 0) {
            if (this.dayOfMonth == -1) {
                int adjustment = (7 + this.dayOfWeek - date.getDay()) % 7;
                if (adjustment > 3) {
                    adjustment -= 7;
                }
                int orgMonth = date.getMonth();
                date.setDate(date.getDate() + adjustment);
                if (date.getMonth() != orgMonth) {
                    date.setDate(date.getDate() + (adjustment > 0 ? -7 : 7));
                }
            } else if (date.getDay() != this.dayOfWeek) {
                return false;
            }
        }
        if (this.tzOffset > Integer.MIN_VALUE) {
            int offset = date.getTimezoneOffset();
            date.setTime(date.getTime() + (long)((this.tzOffset - offset) * 60 * 1000));
        }
        return true;
    }

    public void setAmbiguousYear(boolean ambiguousYear) {
        this.ambiguousYear = ambiguousYear;
    }

    public void setAmpm(int ampm) {
        this.ampm = ampm;
    }

    public void setDayOfMonth(int day) {
        this.dayOfMonth = day;
    }

    public void setDayOfWeek(int dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public void setEra(int era) {
        this.era = era;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public void setMilliseconds(int milliseconds) {
        this.milliseconds = milliseconds;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    public void setTzOffset(int tzOffset) {
        this.tzOffset = tzOffset;
    }

    public void setYear(int value) {
        this.year = value;
    }
}

