/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.branch.CDOBranchManager;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.common.id.CDOIDGenerator;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.protocol.CDOAuthenticator;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.CDOSessionConfiguration;
import org.eclipse.emf.cdo.spi.common.CDOAuthenticationResult;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.view.CDOFetchRuleManager;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.emf.spi.cdo.InternalCDOSessionConfiguration;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.Notifier;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;

public abstract class CDOSessionConfigurationImpl
extends Notifier
implements InternalCDOSessionConfiguration {
    private String userID;
    private boolean passiveUpdateEnabled = true;
    private CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode = CDOCommonSession.Options.PassiveUpdateMode.INVALIDATIONS;
    private CDOCommonSession.Options.LockNotificationMode lockNotificationMode = CDOCommonSession.Options.LockNotificationMode.IF_REQUIRED_BY_VIEWS;
    private IPasswordCredentialsProvider credentialsProvider;
    private CDOSession.ExceptionHandler exceptionHandler;
    private CDOIDGenerator idGenerator;
    private CDOFetchRuleManager fetchRuleManager;
    private InternalCDOBranchManager branchManager;
    private InternalCDOPackageRegistry packageRegistry;
    private InternalCDORevisionManager revisionManager;
    private InternalCDOCommitInfoManager commitInfoManager;
    private boolean loginPeek;
    private boolean mainBranchLocal;
    private boolean activateOnOpen = true;
    private InternalCDOSession session;
    private final IListener lifecycleEventAdapter = new LifecycleEventAdapter(){

        protected void onActivated(final ILifecycle newSession) {
            newSession.removeListener(CDOSessionConfigurationImpl.this.lifecycleEventAdapter);
            CDOSessionConfigurationImpl.this.fireEvent(new CDOSessionConfiguration.SessionOpenedEvent(){

                @Override
                public CDOSessionConfiguration getSource() {
                    return CDOSessionConfigurationImpl.this;
                }

                @Override
                public CDOSession getOpenedSession() {
                    return (CDOSession)newSession;
                }
            });
        }
    };

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public void setUserID(String userID) {
        this.checkNotOpen();
        this.userID = userID;
    }

    @Override
    public boolean isPassiveUpdateEnabled() {
        return this.passiveUpdateEnabled;
    }

    @Override
    public void setPassiveUpdateEnabled(boolean passiveUpdateEnabled) {
        this.checkNotOpen();
        this.uncheckedSetPassiveUpdateEnabled(passiveUpdateEnabled);
    }

    protected void uncheckedSetPassiveUpdateEnabled(boolean passiveUpdateEnabled) {
        this.passiveUpdateEnabled = passiveUpdateEnabled;
    }

    @Override
    public CDOCommonSession.Options.PassiveUpdateMode getPassiveUpdateMode() {
        return this.passiveUpdateMode;
    }

    @Override
    public void setPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode) {
        this.checkNotOpen();
        this.uncheckedSetPassiveUpdateMode(passiveUpdateMode);
    }

    protected void uncheckedSetPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode) {
        this.passiveUpdateMode = passiveUpdateMode;
    }

    @Override
    public CDOCommonSession.Options.LockNotificationMode getLockNotificationMode() {
        return this.lockNotificationMode;
    }

    @Override
    public void setLockNotificationMode(CDOCommonSession.Options.LockNotificationMode lockNotificationMode) {
        this.checkNotOpen();
        this.uncheckedSetLockNotificationMode(lockNotificationMode);
    }

    protected void uncheckedSetLockNotificationMode(CDOCommonSession.Options.LockNotificationMode lockNotificationMode) {
        this.lockNotificationMode = lockNotificationMode;
    }

    @Override
    @Deprecated
    public CDOAuthenticator getAuthenticator() {
        return new CDOAuthenticator(){

            public String getEncryptionAlgorithmName() {
                return null;
            }

            public void setEncryptionAlgorithmName(String encryptionAlgorithmName) {
            }

            public byte[] getEncryptionSaltBytes() {
                return null;
            }

            public void setEncryptionSaltBytes(byte[] encryptionSaltBytes) {
            }

            public int getEncryptionIterationCount() {
                return 0;
            }

            public void setEncryptionIterationCount(int encryptionIterationCount) {
            }

            public IPasswordCredentialsProvider getCredentialsProvider() {
                return CDOSessionConfigurationImpl.this.getCredentialsProvider();
            }

            public void setCredentialsProvider(IPasswordCredentialsProvider credentialsProvider) {
                CDOSessionConfigurationImpl.this.setCredentialsProvider(credentialsProvider);
            }

            public CDOAuthenticationResult authenticate(byte[] randomToken) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public IPasswordCredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    @Override
    public void setCredentialsProvider(IPasswordCredentialsProvider credentialsProvider) {
        this.checkNotOpen();
        this.credentialsProvider = credentialsProvider;
    }

    @Override
    public CDOSession.ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public void setExceptionHandler(CDOSession.ExceptionHandler exceptionHandler) {
        this.checkNotOpen();
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public CDOIDGenerator getIDGenerator() {
        return this.idGenerator;
    }

    @Override
    public void setIDGenerator(CDOIDGenerator idGenerator) {
        this.checkNotOpen();
        this.idGenerator = idGenerator;
    }

    @Override
    public CDOFetchRuleManager getFetchRuleManager() {
        return this.fetchRuleManager;
    }

    @Override
    public void setFetchRuleManager(CDOFetchRuleManager fetchRuleManager) {
        this.checkNotOpen();
        this.fetchRuleManager = fetchRuleManager;
    }

    public InternalCDOBranchManager getBranchManager() {
        return this.branchManager;
    }

    @Override
    public void setBranchManager(CDOBranchManager branchManager) {
        this.checkNotOpen();
        this.branchManager = (InternalCDOBranchManager)branchManager;
    }

    public InternalCDOPackageRegistry getPackageRegistry() {
        return this.packageRegistry;
    }

    public void setPackageRegistry(CDOPackageRegistry packageRegistry) {
        this.checkNotOpen();
        this.packageRegistry = (InternalCDOPackageRegistry)packageRegistry;
    }

    public InternalCDORevisionManager getRevisionManager() {
        return this.revisionManager;
    }

    public void setRevisionManager(CDORevisionManager revisionManager) {
        this.checkNotOpen();
        this.revisionManager = (InternalCDORevisionManager)revisionManager;
    }

    public InternalCDOCommitInfoManager getCommitInfoManager() {
        return this.commitInfoManager;
    }

    public void setCommitInfoManager(CDOCommitInfoManager commitInfoManager) {
        this.checkNotOpen();
        this.commitInfoManager = (InternalCDOCommitInfoManager)commitInfoManager;
    }

    @Override
    public boolean isLoginPeek() {
        return this.loginPeek;
    }

    @Override
    public void setLoginPeek(boolean loginPeek) {
        this.loginPeek = loginPeek;
    }

    @Override
    public boolean isMainBranchLocal() {
        return this.mainBranchLocal;
    }

    @Override
    public void setMainBranchLocal(boolean mainBranchLocal) {
        this.mainBranchLocal = mainBranchLocal;
    }

    @Override
    public boolean isActivateOnOpen() {
        return this.activateOnOpen;
    }

    @Override
    public void setActivateOnOpen(boolean activateOnOpen) {
        this.checkNotOpen();
        this.activateOnOpen = activateOnOpen;
    }

    @Override
    public boolean isSessionOpen() {
        if (this.session == null) {
            return false;
        }
        if (!this.session.isClosed()) {
            return true;
        }
        this.session = null;
        return false;
    }

    @Override
    public CDOSession openSession() {
        if (!this.isSessionOpen()) {
            this.session = this.createSession();
            this.session.addListener(this.lifecycleEventAdapter);
            this.configureSession(this.session);
            if (this.activateOnOpen) {
                this.session.activate();
            }
        }
        return this.session;
    }

    protected void configureSession(InternalCDOSession session) {
        session.options().setPassiveUpdateEnabled(this.passiveUpdateEnabled);
        session.options().setPassiveUpdateMode(this.passiveUpdateMode);
        session.options().setLockNotificationMode(this.lockNotificationMode);
        session.setLoginPeek(this.loginPeek);
        session.setMainBranchLocal(this.mainBranchLocal);
        session.setExceptionHandler(this.exceptionHandler);
        session.setFetchRuleManager(this.fetchRuleManager);
        session.setIDGenerator(this.idGenerator);
        session.setCredentialsProvider(this.credentialsProvider);
        session.setRevisionManager(this.revisionManager);
        session.setBranchManager(this.branchManager);
        session.setCommitInfoManager(this.commitInfoManager);
        session.setPackageRegistry(this.packageRegistry);
    }

    @Override
    public InternalCDOSession getSession() {
        this.checkOpen();
        return this.session;
    }

    protected void setSession(InternalCDOSession session) {
        this.session = session;
    }

    protected void checkOpen() {
        if (!this.isSessionOpen()) {
            throw new IllegalStateException(Messages.getString("CDOSessionConfigurationImpl.1"));
        }
    }

    protected void checkNotOpen() {
        if (this.isSessionOpen()) {
            throw new IllegalStateException(Messages.getString("CDOSessionConfigurationImpl.0"));
        }
    }
}

