/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.changelog.core.editors;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.StringTokenizer;
import org.eclipse.jface.text.formatter.IFormattingStrategy;

public class ChangeLogFormattingStrategy
implements IFormattingStrategy {
    private static final String NEW_LINE_CHAR = "\n";
    private static final String WHITE_SPACE_CHAR = " ";
    private static final String TAB_SPACE_CHAR = "\t";
    private static final String DELIMITER_CHARS = "\n \t";
    private static final int MAX_WIDTH = 80;
    private static final SimpleDateFormat isoDate = new SimpleDateFormat("yyyy-MM-dd");

    public String format(String content, boolean isLineStart, String indentation, int[] positions) {
        String firstLine = "";
        if (!isLineStart) {
            int eol = content.indexOf(NEW_LINE_CHAR);
            if (eol == content.length() - 1) {
                return content;
            }
            firstLine = content.substring(0, eol + 1);
            content = content.substring(eol + 1);
        }
        content.replaceFirst("(\\s+)?\\n(\\s+)?", NEW_LINE_CHAR);
        StringTokenizer candidateWords = new StringTokenizer(content, DELIMITER_CHARS, true);
        String formattedContent = this.formatContent(candidateWords, indentation.length());
        return firstLine.concat(formattedContent);
    }

    private String formatContent(StringTokenizer candidateWords, int indentationLength) {
        StringBuilder formattedWords = new StringBuilder();
        int currentLineLength = indentationLength;
        block0: while (candidateWords.hasMoreTokens()) {
            String cword = candidateWords.nextToken();
            if (this.isDelimeter(cword)) continue;
            if (this.isDate(cword)) {
                if (!this.isOnNewLine(formattedWords)) {
                    formattedWords.append(NEW_LINE_CHAR);
                }
                if (formattedWords.length() > 0) {
                    formattedWords.append(NEW_LINE_CHAR);
                }
                formattedWords.append(cword + WHITE_SPACE_CHAR);
                while (candidateWords.hasMoreTokens()) {
                    cword = candidateWords.nextToken();
                    if (cword.equals(NEW_LINE_CHAR)) {
                        formattedWords.append(NEW_LINE_CHAR);
                        continue block0;
                    }
                    if (this.isEmail(cword)) {
                        formattedWords.append(WHITE_SPACE_CHAR).append(WHITE_SPACE_CHAR).append(cword).append(NEW_LINE_CHAR).append(NEW_LINE_CHAR);
                        currentLineLength = indentationLength;
                        continue block0;
                    }
                    if (this.isDelimeter(cword)) continue;
                    formattedWords.append(WHITE_SPACE_CHAR).append(cword);
                }
                continue;
            }
            if (this.isStar(cword)) {
                if (!this.isOnNewLine(formattedWords)) {
                    formattedWords.append(NEW_LINE_CHAR);
                    currentLineLength = indentationLength;
                }
                formattedWords.append(TAB_SPACE_CHAR).append(cword);
                currentLineLength += cword.length() + 1;
                if (candidateWords.countTokens() < 2) continue;
                candidateWords.nextToken();
                cword = candidateWords.nextToken();
                formattedWords.append(WHITE_SPACE_CHAR).append(cword);
                currentLineLength += cword.length() + 1;
                continue;
            }
            if (cword.startsWith("(")) {
                if (formattedWords.length() > 0) {
                    formattedWords.append(NEW_LINE_CHAR);
                }
                formattedWords.append(TAB_SPACE_CHAR);
                currentLineLength = 1;
                boolean skipMultiWhiteSpace = false;
                while (!cword.endsWith("):") && candidateWords.hasMoreTokens()) {
                    if (cword.equals(NEW_LINE_CHAR)) break;
                    if (cword.equals(WHITE_SPACE_CHAR) && !skipMultiWhiteSpace) {
                        formattedWords.append(cword);
                        currentLineLength += cword.length();
                        skipMultiWhiteSpace = true;
                    }
                    if (!this.isDelimeter(cword)) {
                        formattedWords.append(cword);
                        currentLineLength += cword.length();
                        skipMultiWhiteSpace = false;
                    }
                    cword = candidateWords.nextToken();
                }
                formattedWords.append(cword);
                currentLineLength += cword.length();
                continue;
            }
            if (currentLineLength + cword.length() > 80) {
                formattedWords.append(NEW_LINE_CHAR).append(TAB_SPACE_CHAR).append(cword);
                currentLineLength = indentationLength + cword.length();
                continue;
            }
            if (this.isOnNewLine(formattedWords)) {
                formattedWords.append(TAB_SPACE_CHAR);
            } else {
                formattedWords.append(WHITE_SPACE_CHAR);
            }
            formattedWords.append(cword);
            currentLineLength += cword.length() + 1;
        }
        return formattedWords.toString();
    }

    private boolean isDate(String inputStr) {
        try {
            return isoDate.parse(inputStr) != null;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    private boolean isEmail(String inputStr) {
        return inputStr.startsWith("<") && inputStr.endsWith(">");
    }

    private boolean isStar(String inputStr) {
        return inputStr.equals("*");
    }

    private boolean isDelimeter(String cword) {
        return DELIMITER_CHARS.contains(cword);
    }

    private boolean isOnNewLine(StringBuilder formattedWords) {
        int len = formattedWords.length();
        return len == 0 || formattedWords.charAt(len - 1) == NEW_LINE_CHAR.charAt(0);
    }

    public void formatterStarts(String initialIndentation) {
    }

    public void formatterStops() {
    }
}

