/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.annotations;

import java.util.Collection;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentPopupDialog;
import org.eclipse.mylyn.internal.reviews.ui.annotations.InlineCommentSubmitter;
import org.eclipse.mylyn.internal.reviews.ui.annotations.Messages;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class InlineCommentEditor {
    private static final int MIN_COMMENT_EDITOR_HEIGHT = 100;
    private static MultiValuedMap<String, Integer> editMap = new HashSetValuedHashMap();
    private final CommentPopupDialog dialog;
    private final String reviewItemId;
    private final int startLine;
    private CommentEditorState state;
    private Composite editorComposite;
    private Text commentEditorText;
    private IComment currentComment;
    private Button saveButton;
    private Button discardOrDoneButton;
    private Button cancelButton;
    private String originalComment;

    protected InlineCommentEditor(CommentPopupDialog dialog) {
        this.dialog = dialog;
        this.reviewItemId = dialog.getReviewItem().getId();
        this.startLine = dialog.getRange().getStartLine();
        this.state = CommentEditorState.VIEW;
    }

    protected void createControl(Composite parent, IComment clickedComment) {
        this.dialog.hideHelpText();
        InlineCommentEditor.addToEditMap(this.reviewItemId, this.startLine);
        if (this.editorComposite == null) {
            this.editorComposite = new Composite(parent, 0);
            this.editorComposite.setSize(this.editorComposite.getSize().x, 100);
            this.editorComposite.setBackground(this.dialog.getToolkit().getColors().getBackground());
            GridData textGridData = new GridData(4, 4, true, true);
            this.commentEditorText = new Text(this.editorComposite, 2626);
            this.commentEditorText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (InlineCommentEditor.this.saveButton != null) {
                        if (StringUtils.isEmpty((CharSequence)((Text)e.widget).getText())) {
                            InlineCommentEditor.this.saveButton.setEnabled(false);
                            InlineCommentEditor.this.discardOrDoneButton.setEnabled(true);
                        } else {
                            InlineCommentEditor.this.discardOrDoneButton.setEnabled(InlineCommentEditor.this.currentComment == null || InlineCommentEditor.this.currentComment.isDraft());
                            InlineCommentEditor.this.saveButton.setEnabled(true);
                        }
                    }
                }
            });
            this.commentEditorText.addKeyListener((KeyListener)this.createAddSaveKeyListener());
            textGridData.minimumHeight = this.commentEditorText.getLineHeight() * 4;
            textGridData.verticalSpan = 4;
            this.commentEditorText.setLayoutData((Object)textGridData);
            Composite buttonContainer = new Composite(this.editorComposite, 0);
            buttonContainer.setLayoutData((Object)new GridData(4, 4, true, true));
            GridData buttonGridData = new GridData(4, 4, true, true);
            buttonGridData.verticalSpan = 1;
            GridLayoutFactory.fillDefaults().spacing(1, 1).numColumns(3).applyTo(buttonContainer);
            this.saveButton = this.createButton(buttonContainer, Messages.CommentPopupDialog_Save, buttonGridData, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InlineCommentEditor.this.saveCommentAction();
                }
            });
            this.discardOrDoneButton = this.createButton(buttonContainer, null, buttonGridData, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (InlineCommentEditor.this.currentComment.isDraft()) {
                        InlineCommentEditor.this.setState(CommentEditorState.DISCARD);
                    } else {
                        InlineCommentEditor.this.commentEditorText.setText(Messages.CommentPopupDialog_Done);
                        InlineCommentEditor.this.setState(CommentEditorState.REPLY);
                    }
                    InlineCommentEditor.this.saveComment();
                }
            });
            this.cancelButton = this.createButton(buttonContainer, Messages.CommentPopupDialog_Cancel, buttonGridData, (SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    InlineCommentEditor.this.removeControl();
                }
            });
            this.editorComposite.setLayout((Layout)new GridLayout(1, false));
            this.editorComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            this.dialog.recomputeSize();
        }
        if (clickedComment != null && this.currentComment == null) {
            IComment lastDraft = this.dialog.getLastCommentDraft();
            this.currentComment = !clickedComment.isDraft() && lastDraft != null ? lastDraft : clickedComment;
            if (this.currentComment.isDraft()) {
                this.commentEditorText.setText(this.currentComment.getDescription());
                this.discardOrDoneButton.setText(Messages.CommentPopupDialog_Discard);
            } else {
                this.commentEditorText.setText("");
                this.discardOrDoneButton.setText(Messages.CommentPopupDialog_ReplyDone);
            }
            if (this.originalComment == null) {
                this.originalComment = this.commentEditorText.getText();
            }
            this.commentEditorText.setFocus();
        }
    }

    protected void removeControl() {
        if (this.commentEditorText != null && StringUtils.isNotEmpty((CharSequence)this.commentEditorText.getText())) {
            InlineCommentEditor.addToEditMap(this.reviewItemId, this.startLine);
            this.originalComment = null;
        }
        if (this.editorComposite != null) {
            this.editorComposite.dispose();
        }
        this.editorComposite = null;
        this.commentEditorText = null;
        this.currentComment = null;
        this.setState(CommentEditorState.VIEW);
        this.dialog.recomputeSize();
    }

    protected void forceDispose() {
        this.dialog.dispose(true);
    }

    protected boolean hasEdits() {
        return this.editorComposite != null && !this.editorComposite.isDisposed() && this.commentEditorText != null && !this.commentEditorText.getText().equals(this.originalComment);
    }

    protected Composite getEditorComposite() {
        return this.editorComposite;
    }

    protected Text getCommentEditorText() {
        return this.commentEditorText;
    }

    protected Button getSaveButton() {
        return this.saveButton;
    }

    protected Button getDiscardOrDoneButton() {
        return this.discardOrDoneButton;
    }

    protected Button getCancelButton() {
        return this.cancelButton;
    }

    protected IComment getCurrentComment() {
        return this.currentComment;
    }

    protected CommentEditorState getState() {
        return this.state;
    }

    protected void setState(CommentEditorState state) {
        this.state = state;
    }

    protected static void addToEditMap(String reviewItemId, int startLine) {
        editMap.put((Object)reviewItemId, (Object)startLine);
    }

    protected static void removeFromEditMap(String reviewItemId, int startLine) {
        Collection lines = editMap.get((Object)reviewItemId);
        lines.remove(startLine);
    }

    protected static boolean canAddCommentEditor(String reviewItemId, int startLine) {
        Collection comments = editMap.get((Object)reviewItemId);
        if (comments != null) {
            return !comments.contains(startLine);
        }
        return true;
    }

    private Button createButton(Composite parent, String text, GridData gridData, SelectionListener listener) {
        Button button = new Button(parent, 8);
        if (text != null) {
            button.setText(text);
        }
        button.setLayoutData((Object)gridData);
        button.addSelectionListener(listener);
        return button;
    }

    private KeyAdapter createAddSaveKeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) != 0 && (e.keyCode == 13 || e.keyCode == 10)) {
                    InlineCommentEditor.this.saveCommentAction();
                }
            }
        };
    }

    private void saveCommentAction() {
        if (this.currentComment.isDraft()) {
            this.setState(CommentEditorState.EDIT);
        } else {
            this.setState(CommentEditorState.REPLY);
        }
        this.saveComment();
    }

    private void saveComment() {
        InlineCommentSubmitter submitter = new InlineCommentSubmitter(this.dialog.getReviewItem(), this.dialog.getRange(), this.dialog.getAnnotationInput(), this);
        submitter.saveComment();
    }

    public static enum CommentEditorState {
        VIEW,
        REPLY,
        EDIT,
        DISCARD;

    }
}

