/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db.ddl.delta;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBIndex;
import org.eclipse.net4j.db.ddl.IDBSchema;
import org.eclipse.net4j.db.ddl.IDBSchemaElement;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.db.ddl.delta.IDBDelta;
import org.eclipse.net4j.db.ddl.delta.IDBDeltaVisitor;
import org.eclipse.net4j.db.ddl.delta.IDBFieldDelta;
import org.eclipse.net4j.db.ddl.delta.IDBIndexDelta;
import org.eclipse.net4j.db.ddl.delta.IDBTableDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBFieldDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBIndexDelta;
import org.eclipse.net4j.internal.db.ddl.delta.DBSchemaDelta;
import org.eclipse.net4j.spi.db.ddl.InternalDBSchema;
import org.eclipse.net4j.spi.db.ddl.InternalDBTable;

public final class DBTableDelta
extends DBDelta
implements IDBTableDelta {
    private static final long serialVersionUID = 1L;
    private Map<String, IDBFieldDelta> fieldDeltas = new HashMap<String, IDBFieldDelta>();
    private Map<String, IDBIndexDelta> indexDeltas = new HashMap<String, IDBIndexDelta>();

    public DBTableDelta(DBDelta parent, String name, IDBDelta.ChangeKind changeKind) {
        super(parent, name, changeKind);
    }

    public DBTableDelta(DBSchemaDelta parent, IDBTable table, IDBTable oldTable) {
        this((DBDelta)parent, DBTableDelta.getName(table, oldTable), DBTableDelta.getChangeKind(table, oldTable));
        InternalDBSchema schema = (InternalDBSchema)DBTableDelta.getSchema(table, oldTable);
        IDBSchemaElement[] fields = table == null ? InternalDBTable.NO_FIELDS : table.getFields();
        IDBSchemaElement[] oldFields = oldTable == null ? InternalDBTable.NO_FIELDS : oldTable.getFields();
        DBTableDelta.compare((InternalDBSchema)schema, (IDBSchemaElement[])fields, (IDBSchemaElement[])oldFields, (DBDelta.SchemaElementComparator)new DBDelta.SchemaElementComparator<IDBField>(){

            @Override
            public void compare(IDBField field, IDBField oldField) {
                DBFieldDelta fieldDelta = new DBFieldDelta((DBDelta)DBTableDelta.this, field, oldField);
                if (!fieldDelta.isEmpty()) {
                    DBTableDelta.this.addFieldDelta(fieldDelta);
                }
            }
        });
        IDBSchemaElement[] indices = table == null ? InternalDBTable.NO_INDICES : table.getIndices();
        IDBSchemaElement[] oldIndices = oldTable == null ? InternalDBTable.NO_INDICES : oldTable.getIndices();
        DBTableDelta.compare((InternalDBSchema)schema, (IDBSchemaElement[])indices, (IDBSchemaElement[])oldIndices, (DBDelta.SchemaElementComparator)new DBDelta.SchemaElementComparator<IDBIndex>(){

            @Override
            public void compare(IDBIndex index, IDBIndex oldIndex) {
                DBIndexDelta indexDelta = new DBIndexDelta((DBDelta)DBTableDelta.this, index, oldIndex);
                if (!indexDelta.isEmpty()) {
                    DBTableDelta.this.addIndexDelta(indexDelta);
                }
            }
        });
    }

    protected DBTableDelta() {
    }

    @Override
    public IDBDelta.DeltaType getDeltaType() {
        return IDBDelta.DeltaType.TABLE;
    }

    @Override
    public DBSchemaDelta getParent() {
        return (DBSchemaDelta)super.getParent();
    }

    @Override
    public int getFieldDeltaCount() {
        return this.fieldDeltas.size();
    }

    @Override
    public int getIndexDeltaCount() {
        return this.indexDeltas.size();
    }

    @Override
    public DBFieldDelta getFieldDelta(int position) {
        for (IDBFieldDelta fieldDelta : this.fieldDeltas.values()) {
            if (fieldDelta.getPosition() != position) continue;
            return (DBFieldDelta)fieldDelta;
        }
        return null;
    }

    @Override
    public DBFieldDelta getFieldDelta(String name) {
        return (DBFieldDelta)this.fieldDeltas.get(name);
    }

    @Override
    public DBIndexDelta getIndexDelta(String name) {
        return (DBIndexDelta)this.indexDeltas.get(name);
    }

    @Override
    public Map<String, IDBFieldDelta> getFieldDeltas() {
        return Collections.unmodifiableMap(this.fieldDeltas);
    }

    @Override
    public Map<String, IDBIndexDelta> getIndexDeltas() {
        return Collections.unmodifiableMap(this.indexDeltas);
    }

    public DBFieldDelta[] getFieldDeltasSortedByPosition() {
        Object[] result = this.fieldDeltas.values().toArray(new DBFieldDelta[this.fieldDeltas.size()]);
        Arrays.sort(result);
        return result;
    }

    public DBIndexDelta[] getIndexDeltasSortedByName() {
        Object[] result = this.indexDeltas.values().toArray(new DBIndexDelta[this.indexDeltas.size()]);
        Arrays.sort(result);
        return result;
    }

    @Override
    public IDBTable getSchemaElement(IDBSchema schema) {
        return schema.getTable(this.getName());
    }

    @Override
    public String toString() {
        return MessageFormat.format("DBTableDelta[name={0}, kind={1}, fieldDeltas={2}, indexDeltas={3}]", new Object[]{this.getName(), this.getChangeKind(), this.fieldDeltas.values(), this.indexDeltas.values()});
    }

    public void addFieldDelta(IDBFieldDelta fieldDelta) {
        this.fieldDeltas.put(fieldDelta.getName(), fieldDelta);
        this.resetElements();
    }

    public void addIndexDelta(IDBIndexDelta indexDelta) {
        this.indexDeltas.put(indexDelta.getName(), indexDelta);
        this.resetElements();
    }

    @Override
    protected void doAccept(IDBDeltaVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void collectElements(List<IDBDelta> elements) {
        elements.addAll(this.fieldDeltas.values());
        elements.addAll(this.indexDeltas.values());
    }
}

