/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.annotations;

import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.pde.core.IBaseModel;

public interface OSGiAnnotationProcessor {
    public void processAnnotation(Annotation var1, String var2);

    public void apply(IBaseModel var1);

    public static Optional<String> stringValue(Expression expression) {
        return Optional.ofNullable(expression).filter(StringLiteral.class::isInstance).map(StringLiteral.class::cast).map(StringLiteral::getLiteralValue);
    }

    /*
     * WARNING - void declaration
     */
    public static Stream<Expression> expressions(Expression expression) {
        Expression unwrap = OSGiAnnotationProcessor.value(expression).orElse(expression);
        Expression expression2 = unwrap;
        if (expression2 instanceof ArrayInitializer) {
            void arrayInitializer;
            ArrayInitializer arrayInitializer2 = (ArrayInitializer)expression2;
            ArrayInitializer cfr_ignored_0 = (ArrayInitializer)expression2;
            return arrayInitializer.expressions().stream().filter(Expression.class::isInstance).map(Expression.class::cast);
        }
        return Stream.of(expression);
    }

    public static Optional<Expression> value(Expression annotation) {
        return OSGiAnnotationProcessor.member(annotation, "value");
    }

    /*
     * WARNING - void declaration
     */
    public static Optional<Expression> member(Expression annotation, String memberName) {
        Object value;
        Object object;
        Expression expression = annotation;
        if (expression instanceof NormalAnnotation) {
            void normalAnnotation;
            NormalAnnotation normalAnnotation2 = (NormalAnnotation)expression;
            NormalAnnotation cfr_ignored_0 = (NormalAnnotation)expression;
            object = normalAnnotation.values().iterator();
            while (object.hasNext()) {
                void pair;
                value = object.next();
                Object object2 = value;
                if (!(object2 instanceof MemberValuePair)) continue;
                MemberValuePair cfr_ignored_1 = (MemberValuePair)object2;
                MemberValuePair cfr_ignored_2 = (MemberValuePair)object2;
                SimpleName name = pair.getName();
                if (name == null || !name.toString().equals(memberName)) continue;
                return Optional.ofNullable(pair.getValue());
            }
        }
        if ((object = annotation) instanceof SingleMemberAnnotation) {
            value = (SingleMemberAnnotation)object;
            SingleMemberAnnotation cfr_ignored_3 = (SingleMemberAnnotation)object;
            if ("value".equals(memberName)) {
                void singleMemberAnnotation;
                return Optional.ofNullable(singleMemberAnnotation.getValue());
            }
        }
        return Optional.empty();
    }
}

