/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import jakarta.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.commands.contexts.Context;
import org.eclipse.core.commands.contexts.ContextManager;
import org.eclipse.core.commands.contexts.IContextManagerListener;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.contexts.RunAndTrack;
import org.eclipse.e4.ui.services.EContextService;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.contexts.ContextActivation;
import org.eclipse.ui.internal.contexts.ContextAuthority;
import org.eclipse.ui.internal.contexts.ContextPersistence;

public final class ContextService
implements IContextService {
    private HashMap<IContextActivation, UpdateExpression> activationToRat = new HashMap();
    private final ContextAuthority contextAuthority;
    private ContextManager contextManager;
    @Inject
    private EContextService contextService;
    @Inject
    private IEclipseContext eclipseContext;
    private final ContextPersistence contextPersistence;

    @Inject
    public ContextService(ContextManager contextManager) {
        if (contextManager == null) {
            throw new NullPointerException("Cannot create a context service with a null manager");
        }
        this.contextManager = contextManager;
        this.contextAuthority = new ContextAuthority(contextManager, this);
        this.contextPersistence = new ContextPersistence(contextManager);
    }

    @Override
    public void deferUpdates(boolean defer) {
        this.contextManager.deferUpdates(defer);
        this.contextService.deferUpdates(defer);
    }

    @Override
    public IContextActivation activateContext(String contextId) {
        return this.activateContext(contextId, null);
    }

    @Override
    public IContextActivation activateContext(String contextId, Expression expression) {
        ContextActivation activation = new ContextActivation(contextId, expression, this);
        this.contextAuthority.activateContext(activation);
        if (expression == null) {
            this.contextService.activateContext(contextId);
        } else {
            UpdateExpression runnable = new UpdateExpression(contextId, expression);
            this.activationToRat.put(activation, runnable);
            this.eclipseContext.runAndTrack((RunAndTrack)runnable);
        }
        return activation;
    }

    @Override
    public IContextActivation activateContext(String contextId, Expression expression, boolean global) {
        return this.activateContext(contextId, expression);
    }

    @Override
    public IContextActivation activateContext(String contextId, Expression expression, int sourcePriority) {
        return this.activateContext(contextId, expression);
    }

    @Override
    public void addContextManagerListener(IContextManagerListener listener) {
        this.contextManager.addContextManagerListener(listener);
    }

    @Override
    public void addSourceProvider(ISourceProvider provider) {
        this.contextAuthority.addSourceProvider(provider);
    }

    @Override
    public void deactivateContext(IContextActivation activation) {
        if (activation != null && activation.getContextService() == this) {
            UpdateExpression rat = this.activationToRat.remove(activation);
            if (rat != null) {
                rat.updating = false;
                if (rat.cached != null && rat.cached != EvaluationResult.FALSE) {
                    this.contextService.deactivateContext(activation.getContextId());
                }
            } else {
                this.contextService.deactivateContext(activation.getContextId());
            }
            this.contextAuthority.deactivateContext(activation);
        }
    }

    @Override
    public void deactivateContexts(Collection activations) {
        try {
            this.deferUpdates(true);
            for (IContextActivation activation : activations) {
                this.deactivateContext(activation);
            }
        }
        finally {
            this.deferUpdates(false);
        }
    }

    @Override
    public void dispose() {
        this.contextPersistence.dispose();
        this.contextAuthority.dispose();
    }

    @Override
    public Collection getActiveContextIds() {
        return this.contextService.getActiveContextIds();
    }

    @Override
    public Context getContext(String contextId) {
        return this.contextService.getContext(contextId);
    }

    @Override
    public Collection getDefinedContextIds() {
        return this.contextManager.getDefinedContextIds();
    }

    @Override
    public Context[] getDefinedContexts() {
        return this.contextManager.getDefinedContexts();
    }

    @Override
    public int getShellType(Shell shell) {
        return this.contextAuthority.getShellType(shell);
    }

    @Override
    public void readRegistry() {
    }

    @Override
    public boolean registerShell(Shell shell, int type) {
        return this.contextAuthority.registerShell(shell, type);
    }

    @Override
    public void removeContextManagerListener(IContextManagerListener listener) {
        this.contextManager.removeContextManagerListener(listener);
    }

    @Override
    public void removeSourceProvider(ISourceProvider provider) {
        this.contextAuthority.removeSourceProvider(provider);
    }

    @Override
    public boolean unregisterShell(Shell shell) {
        return this.contextAuthority.unregisterShell(shell);
    }

    public void updateShellKludge() {
        this.contextAuthority.updateShellKludge();
    }

    public void updateShellKludge(Shell shell) {
        Shell currentActiveShell = this.contextAuthority.getActiveShell();
        if (currentActiveShell != shell) {
            this.contextAuthority.sourceChanged(1024, "activeShell", shell);
        }
    }

    private class UpdateExpression
    extends RunAndTrack {
        boolean updating = true;
        private String contextId;
        private Expression expression;
        EvaluationResult cached = null;

        public UpdateExpression(String contextId, Expression expression) {
            this.contextId = contextId;
            this.expression = expression;
        }

        public boolean changed(IEclipseContext context) {
            if (!this.updating) {
                return false;
            }
            ExpressionContext ctx = new ExpressionContext(ContextService.this.eclipseContext);
            try {
                if (this.updating) {
                    EvaluationResult result = this.expression.evaluate((IEvaluationContext)ctx);
                    if (this.cached != null && (this.cached == result || this.cached != EvaluationResult.FALSE && result != EvaluationResult.FALSE)) {
                        return this.updating;
                    }
                    if (result != EvaluationResult.FALSE) {
                        this.runExternalCode(() -> ContextService.this.contextService.activateContext(this.contextId));
                    } else if (this.cached != null) {
                        this.runExternalCode(() -> ContextService.this.contextService.deactivateContext(this.contextId));
                    }
                    this.cached = result;
                }
            }
            catch (CoreException e) {
                WorkbenchPlugin.log("Failed to update " + this.contextId, e);
            }
            return this.updating;
        }
    }
}

