/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api;

import org.eclipse.viatra.transformation.evm.api.Agenda;
import org.eclipse.viatra.transformation.evm.api.ConflictSetIterator;
import org.eclipse.viatra.transformation.evm.api.Executor;
import org.eclipse.viatra.transformation.evm.api.IExecutor;
import org.eclipse.viatra.transformation.evm.api.RuleBase;
import org.eclipse.viatra.transformation.evm.api.event.EventRealm;

public class ScheduledExecution {
    private final IExecutor executor;
    private final RuleBase ruleBase;
    private boolean scheduling = false;
    private final String startMessage = "Executing started in " + this;
    private final String reentrantMessage = "Reentrant schedule call ignored in " + this;
    private final String endMessage = "Executing ended in " + this;

    public ScheduledExecution(EventRealm eventRealm, Agenda agenda, IExecutor executor) {
        this(new RuleBase(eventRealm, agenda), executor);
    }

    public ScheduledExecution(EventRealm eventRealm) {
        this(new RuleBase(eventRealm, new Agenda()), new Executor());
    }

    public ScheduledExecution(RuleBase ruleBase, IExecutor executor) {
        this.ruleBase = ruleBase;
        this.executor = executor;
    }

    public RuleBase getRuleBase() {
        return this.ruleBase;
    }

    public IExecutor getExecutor() {
        return this.executor;
    }

    protected void schedule() {
        if (!this.startScheduling()) {
            return;
        }
        this.executor.startExecution("Scheduling");
        this.executor.execute(new ConflictSetIterator(this.ruleBase.getAgenda().getConflictSet()));
        this.executor.endExecution("Scheduling");
        this.endScheduling();
    }

    protected synchronized boolean startScheduling() {
        if (this.scheduling) {
            this.ruleBase.getLogger().trace((Object)this.reentrantMessage);
            return false;
        }
        this.scheduling = true;
        this.ruleBase.getLogger().trace((Object)this.startMessage);
        return true;
    }

    protected synchronized void endScheduling() {
        this.ruleBase.getLogger().trace((Object)this.endMessage);
        this.scheduling = false;
    }

    protected void dispose() {
        this.ruleBase.dispose();
    }
}

