/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.bundle;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.apache.commons.lang.SystemUtils;
import org.eclipse.wb.internal.core.nls.bundle.IPropertiesAccessor;

public class StandardPropertiesAccessor
implements IPropertiesAccessor {
    public static final StandardPropertiesAccessor INSTANCE = new StandardPropertiesAccessor();

    private StandardPropertiesAccessor() {
    }

    @Override
    public Map<String, String> load(InputStream is, String charset) throws Exception {
        Properties properties = new Properties();
        StandardPropertiesAccessor.load0(properties, is, charset);
        return properties;
    }

    @Override
    public void save(OutputStream os, String charset, Map<String, String> map, String comments) throws Exception {
        SortedProperties sorted = new SortedProperties();
        sorted.putAll(map);
        StandardPropertiesAccessor.store0(sorted, os, charset, comments);
    }

    private static void load0(Properties properties, InputStream is, String charset) throws Exception {
        if (charset.equals("UTF-8") && SystemUtils.isJavaVersionAtLeast((float)1.6f)) {
            Method loadMethod = Properties.class.getMethod("load", Reader.class);
            InputStreamReader reader = new InputStreamReader(is, charset);
            loadMethod.invoke((Object)properties, reader);
        } else {
            properties.load(is);
        }
    }

    private static void store0(Properties properties, OutputStream os, String charset, String comments) throws Exception {
        if (charset.equals("UTF-8") && SystemUtils.isJavaVersionAtLeast((float)1.6f)) {
            Method loadMethod = Properties.class.getMethod("store", Writer.class, String.class);
            OutputStreamWriter reader = new OutputStreamWriter(os, charset);
            loadMethod.invoke((Object)properties, reader, comments);
        } else {
            properties.store(os, comments);
        }
    }

    private static class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 0L;

        private SortedProperties() {
        }

        @Override
        public synchronized Enumeration keys() {
            TreeSet<String> set = new TreeSet<String>();
            Enumeration<Object> e = super.keys();
            while (e.hasMoreElements()) {
                set.add((String)e.nextElement());
            }
            return new IteratorWrapper(set.iterator());
        }

        class IteratorWrapper
        implements Enumeration<String> {
            Iterator<String> iterator;

            public IteratorWrapper(Iterator<String> iterator) {
                this.iterator = iterator;
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return this.iterator.next();
            }
        }
    }
}

