/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.wb.internal.core.utils.GenericTypeError;
import org.eclipse.wb.internal.core.utils.GenericsUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public class GenericTypeResolver {
    protected final GenericTypeResolver m_parent;
    public static GenericTypeResolver EMPTY = new GenericTypeResolver(null);

    public GenericTypeResolver(GenericTypeResolver parent) {
        this.m_parent = parent;
    }

    /*
     * WARNING - void declaration
     */
    public String resolve(Type typeToResolve) {
        Object result;
        if (typeToResolve instanceof Class) {
            return ((Class)typeToResolve).getCanonicalName();
        }
        if (typeToResolve instanceof TypeVariable && (result = this.resolveTypeVariable((TypeVariable)typeToResolve)) != null) {
            return result;
        }
        Type type = typeToResolve;
        if (type instanceof ParameterizedType) {
            void parameterizedType;
            result = (ParameterizedType)type;
            ParameterizedType cfr_ignored_0 = (ParameterizedType)type;
            StringBuilder buffer = new StringBuilder();
            buffer.append(((Class)parameterizedType.getRawType()).getName());
            buffer.append("<");
            boolean firstTypeArgument = true;
            Type[] typeArray = parameterizedType.getActualTypeArguments();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type type2 = typeArray[n2];
                if (firstTypeArgument) {
                    firstTypeArgument = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(GenericsUtils.getTypeName(this, type2));
                ++n2;
            }
            buffer.append(">");
            return buffer.toString();
        }
        Type type3 = typeToResolve;
        if (type3 instanceof WildcardType) {
            void wildcardType;
            WildcardType buffer = (WildcardType)type3;
            WildcardType cfr_ignored_1 = (WildcardType)type3;
            Type[] upperBounds = wildcardType.getUpperBounds();
            if (upperBounds.length == 1) {
                return GenericsUtils.getTypeName(this, upperBounds[0]);
            }
        }
        if (this.m_parent != null) {
            return this.m_parent.resolve(typeToResolve);
        }
        throw new GenericTypeError("Can not resolve actual type for: " + String.valueOf(typeToResolve));
    }

    protected String resolveTypeVariable(TypeVariable<?> variable) {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, Type> getActualTypeArguments(Class<?> declarationClass, Class<?> currentClass, Type[] arguments) {
        HashMap<String, Type> currentArguments = new HashMap<String, Type>();
        TypeVariable<Class<?>>[] typeParameters = currentClass.getTypeParameters();
        int i = 0;
        while (i < typeParameters.length) {
            TypeVariable<Class<?>> typeParameter = typeParameters[i];
            currentArguments.put(typeParameter.getName(), arguments[i]);
            ++i;
        }
        if (currentClass == declarationClass) {
            return currentArguments;
        }
        ArrayList<Type> superTypes = new ArrayList<Type>();
        if (currentClass.getGenericSuperclass() != null) {
            superTypes.add(currentClass.getGenericSuperclass());
        }
        Type[] typeArray = currentClass.getGenericInterfaces();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Type superInterface = typeArray[n2];
            superTypes.add(superInterface);
            ++n2;
        }
        for (Type superType : superTypes) {
            Type[] superArguments;
            Class superClass;
            Type type = superType;
            if (type instanceof ParameterizedType) {
                void parameterizedSuperType;
                ParameterizedType cfr_ignored_0 = (ParameterizedType)type;
                ParameterizedType cfr_ignored_1 = (ParameterizedType)type;
                superClass = (Class)parameterizedSuperType.getRawType();
                superArguments = parameterizedSuperType.getActualTypeArguments();
                int i2 = 0;
                while (i2 < superArguments.length) {
                    Type argument = superArguments[i2];
                    if (argument instanceof TypeVariable) {
                        String name = ((TypeVariable)argument).getName();
                        Type resolvedArgument = (Type)currentArguments.get(name);
                        Assert.isNotNull(resolvedArgument);
                        superArguments[i2] = resolvedArgument;
                    }
                    ++i2;
                }
            } else {
                superClass = (Class)superType;
                superArguments = new Type[]{};
            }
            Map<String, Type> map = GenericTypeResolver.getActualTypeArguments(declarationClass, superClass, superArguments);
            if (map == null) continue;
            return map;
        }
        return null;
    }

    public static GenericTypeResolver superClass(final GenericTypeResolver parent, Class<?> actualClass, Class<?> declarationClass) {
        Assert.isTrue(declarationClass.isAssignableFrom(declarationClass));
        final Map<String, Type> declarationClassArguments = GenericTypeResolver.getActualTypeArguments(declarationClass, actualClass, actualClass.getTypeParameters());
        return new GenericTypeResolver(parent){

            @Override
            protected String resolveTypeVariable(TypeVariable<?> variable) {
                String variableName = variable.getName();
                Type variableType = (Type)declarationClassArguments.get(variableName);
                return parent.resolve(variableType);
            }
        };
    }

    public static GenericTypeResolver fixed(final String name, Class<?> clazz) {
        final String clazzName = ReflectionUtils.getCanonicalName(clazz);
        return new GenericTypeResolver(EMPTY){

            @Override
            protected String resolveTypeVariable(TypeVariable<?> variable) {
                if (variable.getName().equals(name)) {
                    return clazzName;
                }
                return null;
            }
        };
    }

    public static GenericTypeResolver argumentOfMethod(final GenericTypeResolver parent, Method method, int index) {
        Type genericParameter = method.getGenericParameterTypes()[index];
        final Map<String, Type> typeArguments = GenericTypeResolver.getTypeArguments(genericParameter);
        return new GenericTypeResolver(parent){

            @Override
            protected String resolveTypeVariable(TypeVariable<?> variable) {
                String variableName = variable.getName();
                Type variableType = (Type)typeArguments.get(variableName);
                if (variableType != null) {
                    return parent.resolve(variableType);
                }
                return null;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static Map<String, Type> getTypeArguments(Type type) {
        TreeMap<String, Type> typeArguments = new TreeMap<String, Type>();
        Type type2 = type;
        if (type2 instanceof ParameterizedType) {
            void parameterized;
            ParameterizedType parameterizedType = (ParameterizedType)type2;
            ParameterizedType cfr_ignored_0 = (ParameterizedType)type2;
            Type[] actualTypeArguments = parameterized.getActualTypeArguments();
            Class raw = (Class)parameterized.getRawType();
            TypeVariable<Class<T>>[] typeParameters = raw.getTypeParameters();
            int i = 0;
            while (i < typeParameters.length) {
                TypeVariable typeParameter = typeParameters[i];
                typeArguments.put(typeParameter.getName(), actualTypeArguments[i]);
                ++i;
            }
        }
        return typeArguments;
    }
}

