/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.internal.core.model.JavaInfoEvaluationHelper;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.property.converter.StringConverter;
import org.eclipse.wb.internal.core.model.variable.AbstractNamedVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swt.model.widgets.live.SwtLiveManager;
import org.eclipse.wb.internal.swt.support.ControlSupport;

public abstract class WidgetInfo
extends AbstractComponentInfo {
    public WidgetInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
        this.rememberVariableNameAsNameData();
    }

    private void rememberVariableNameAsNameData() {
        this.addBroadcastListener(new JavaEventListener(){

            public void variable_setName(AbstractNamedVariableSupport variableSupport, String oldName, String newName) throws Exception {
                if (variableSupport.getJavaInfo() == WidgetInfo.this) {
                    WidgetInfo.this.setVariableNameAsNameData(newName);
                }
            }
        });
    }

    public void createExposedChildren() throws Exception {
        super.createExposedChildren();
        WidgetInfo.createExposedChildren((JavaInfo)this);
    }

    public static void createExposedChildren(JavaInfo host) throws Exception {
        final ArrayList classList = new ArrayList();
        final ClassLoader classLoader = JavaInfoUtils.getClassLoader((JavaInfo)host);
        ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                Class<?> clazz = classLoader.loadClass("org.eclipse.swt.widgets.Widget");
                classList.add(clazz);
            }
        });
        ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                Class<?> clazz = classLoader.loadClass("org.eclipse.jface.viewers.Viewer");
                classList.add(clazz);
            }
        });
        Class[] classes = classList.toArray(new Class[classList.size()]);
        JavaInfoUtils.addExposedChildren((JavaInfo)host, (Class[])classes);
    }

    private void setVariableNameAsNameData(String newName) throws Exception {
        if (this.getDescription().getToolkit().getPreferences().getBoolean("putNameIntoComponent")) {
            String valueSource = StringConverter.INSTANCE.toJavaSource((JavaInfo)this, (Object)newName);
            List invocations = this.getMethodInvocations("setData(java.lang.String,java.lang.Object)");
            for (MethodInvocation invocation : invocations) {
                Expression keyExpression = (Expression)invocation.arguments().get(0);
                Expression valueExpression = (Expression)invocation.arguments().get(1);
                String key = (String)JavaInfoEvaluationHelper.getValue((Expression)keyExpression);
                if (!"name".equals(key)) continue;
                this.getEditor().replaceExpression(valueExpression, valueSource);
                return;
            }
            String nameSource = StringConverter.INSTANCE.toJavaSource((JavaInfo)this, (Object)"name");
            String arguments = nameSource + ", " + valueSource;
            this.addMethodInvocation("setData(java.lang.String,java.lang.Object)", arguments);
        }
    }

    protected SwtLiveManager getLiveComponentsManager() {
        return new SwtLiveManager(this);
    }

    public final int getStyle() {
        if (this.getObject() != null) {
            return ControlSupport.getStyle(this.getObject());
        }
        return this.getLiveComponentsManager().getStyle();
    }
}

