/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.cell.client;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.cell.client.HasCell;
import com.google.gwt.cell.client.ValueUpdater;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.EventTarget;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeCell<C>
extends AbstractCell<C> {
    private Set<String> consumedEvents;
    private boolean dependsOnSelection;
    private boolean handlesSelection;
    private final List<HasCell<C, ?>> hasCells;

    public CompositeCell(List<HasCell<C, ?>> hasCells) {
        super(new String[0]);
        this.hasCells = new ArrayList(hasCells);
        HashSet<String> theConsumedEvents = null;
        for (HasCell<C, ?> hasCell : hasCells) {
            Cell<?> cell = hasCell.getCell();
            Set<String> events = cell.getConsumedEvents();
            if (events != null) {
                if (theConsumedEvents == null) {
                    theConsumedEvents = new HashSet<String>();
                }
                theConsumedEvents.addAll(events);
            }
            if (cell.dependsOnSelection()) {
                this.dependsOnSelection = true;
            }
            if (!cell.handlesSelection()) continue;
            this.handlesSelection = true;
        }
        if (theConsumedEvents != null) {
            this.consumedEvents = Collections.unmodifiableSet(theConsumedEvents);
        }
    }

    @Override
    public boolean dependsOnSelection() {
        return this.dependsOnSelection;
    }

    @Override
    public Set<String> getConsumedEvents() {
        return this.consumedEvents;
    }

    @Override
    public boolean handlesSelection() {
        return this.handlesSelection;
    }

    @Override
    public void onBrowserEvent(Element parent, C value, Object key, NativeEvent event, ValueUpdater<C> valueUpdater) {
        int index = 0;
        EventTarget eventTarget = event.getEventTarget();
        if (Element.is(eventTarget)) {
            Element target = (Element)eventTarget.cast();
            Element container = this.getContainerElement(parent);
            for (Element wrapper = container.getFirstChildElement(); wrapper != null; wrapper = wrapper.getNextSiblingElement()) {
                if (wrapper.isOrHasChild(target)) {
                    this.onBrowserEventImpl(wrapper, value, key, event, valueUpdater, this.hasCells.get(index));
                }
                ++index;
            }
        }
    }

    @Override
    public void render(C value, Object key, SafeHtmlBuilder sb) {
        for (HasCell<C, ?> hasCell : this.hasCells) {
            this.render(value, key, sb, hasCell);
        }
    }

    @Override
    public boolean resetFocus(Element parent, C value, Object key) {
        Element curChild = this.getContainerElement(parent).getFirstChildElement();
        for (HasCell<C, ?> hasCell : this.hasCells) {
            if (this.resetFocusImpl(curChild, value, key, hasCell)) {
                return true;
            }
            curChild = curChild.getNextSiblingElement();
        }
        return false;
    }

    @Override
    public void setValue(Element parent, C object, Object key) {
        Element curChild = this.getContainerElement(parent).getFirstChildElement();
        for (HasCell<C, ?> hasCell : this.hasCells) {
            this.setValueImpl(curChild, object, key, hasCell);
            curChild = curChild.getNextSiblingElement();
        }
    }

    protected Element getContainerElement(Element parent) {
        return parent;
    }

    protected <X> void render(C value, Object key, SafeHtmlBuilder sb, HasCell<C, X> hasCell) {
        Cell<X> cell = hasCell.getCell();
        sb.appendHtmlConstant("<span>");
        cell.render(hasCell.getValue(value), key, sb);
        sb.appendHtmlConstant("</span>");
    }

    private <X> void onBrowserEventImpl(Element parent, final C object, Object key, NativeEvent event, final ValueUpdater<C> valueUpdater, HasCell<C, X> hasCell) {
        ValueUpdater tempUpdater = null;
        final FieldUpdater<C, X> fieldUpdater = hasCell.getFieldUpdater();
        if (fieldUpdater != null) {
            tempUpdater = new ValueUpdater<X>(){

                @Override
                public void update(X value) {
                    fieldUpdater.update(-1, object, value);
                    if (valueUpdater != null) {
                        valueUpdater.update(object);
                    }
                }
            };
        }
        Cell<X> cell = hasCell.getCell();
        cell.onBrowserEvent(parent, hasCell.getValue(object), key, event, tempUpdater);
    }

    private <X> boolean resetFocusImpl(Element cellParent, C value, Object key, HasCell<C, X> hasCell) {
        X cellValue = hasCell.getValue(value);
        return hasCell.getCell().resetFocus(cellParent, cellValue, key);
    }

    private <X> void setValueImpl(Element cellParent, C object, Object key, HasCell<C, X> hasCell) {
        hasCell.getCell().setValue(cellParent, hasCell.getValue(object), key);
    }
}

