/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.designsession;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.services.IPropertyProvider;
import org.eclipse.datatools.connectivity.oda.consumer.services.impl.ProviderUtil;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.DesignSessionRequest;
import org.eclipse.datatools.connectivity.oda.design.ElementNullability;
import org.eclipse.datatools.connectivity.oda.design.OdaDesignSession;
import org.eclipse.datatools.connectivity.oda.design.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.oda.design.internal.designsession.DesignerLogger;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.DataSetUIElement;
import org.eclipse.datatools.connectivity.oda.design.ui.manifest.UIManifestExplorer;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataSetType;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.Property;

public class DesignSessionUtilBase {
    private static final String DEFAULT_PROPERTY_PROVIDER_ID = "org.eclipse.datatools.connectivity.oda.profile.connectionPropertyService";
    private static final String sm_className = DesignSessionUtilBase.class.getName();

    protected DesignSessionUtilBase() {
    }

    protected static Property[] getDataSourcePublicPropertiesDefn(String odaDataSourceId) throws OdaException {
        try {
            ExtensionManifest runtimeManifest = ManifestExplorer.getInstance().getExtensionManifest(odaDataSourceId);
            return runtimeManifest.getVisibleProperties();
        }
        catch (IllegalArgumentException ex) {
            throw new OdaException((Throwable)ex);
        }
    }

    protected static Property[] getDataSetPublicPropertiesDefn(String odaDataSourceId, String odaDataSetId) throws OdaException {
        try {
            ExtensionManifest runtimeManifest = ManifestExplorer.getInstance().getExtensionManifest(odaDataSourceId);
            DataSetType dataSetType = runtimeManifest.getDataSetType(odaDataSetId);
            return dataSetType.getVisibleProperties();
        }
        catch (IllegalArgumentException ex) {
            throw new OdaException((Throwable)ex);
        }
    }

    protected static Properties getEffectiveDataSourceProperties(DataSourceDesign dataSourceDesign) throws OdaException {
        String baseDataSourceId;
        String effectiveDataSourceId;
        Properties candidateProps = DesignUtil.convertDataSourceProperties((DataSourceDesign)dataSourceDesign);
        IPropertyProvider propProvider = null;
        if (dataSourceDesign != null && (propProvider = DesignSessionUtilBase.getPropertyProvider(effectiveDataSourceId = dataSourceDesign.getEffectiveOdaExtensionId())) == null && !effectiveDataSourceId.equalsIgnoreCase(baseDataSourceId = dataSourceDesign.getOdaExtensionDataSourceId())) {
            propProvider = DesignSessionUtilBase.getPropertyProvider(baseDataSourceId);
        }
        if (propProvider == null) {
            propProvider = DesignSessionUtilBase.getPropertyProvider(DEFAULT_PROPERTY_PROVIDER_ID);
        }
        if (propProvider != null) {
            candidateProps = propProvider.getDataSourceProperties(candidateProps, DesignSessionUtilBase.createResourceIdentifiersContext(dataSourceDesign.getHostResourceIdentifiers()));
        }
        return candidateProps;
    }

    private static IPropertyProvider getPropertyProvider(String odaDataSourceId) {
        IPropertyProvider propProvider = null;
        try {
            propProvider = ProviderUtil.createPropertyProvider((String)odaDataSourceId);
        }
        catch (OdaException ex) {
            DesignerLogger logger = DesignerLogger.getInstance();
            logger.warning(sm_className, "getPropertyProvider(String)", "Unable to get ODA Profile property provider.", ex);
            return null;
        }
        return propProvider;
    }

    protected static org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers createRuntimeResourceIdentifiers(ResourceIdentifiers designResourceIdentifiers) {
        if (designResourceIdentifiers == null || designResourceIdentifiers.getApplResourceBaseURI() == null && designResourceIdentifiers.getDesignResourceBaseURI() == null) {
            return null;
        }
        org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers runtimeResourceIds = new org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers();
        runtimeResourceIds.setApplResourceBaseURI(designResourceIdentifiers.getApplResourceBaseURI());
        runtimeResourceIds.setDesignResourceBaseURI(designResourceIdentifiers.getDesignResourceBaseURI());
        return runtimeResourceIds;
    }

    protected static Map<String, Object> createResourceIdentifiersContext(ResourceIdentifiers designResourceIdentifiers) {
        org.eclipse.datatools.connectivity.oda.util.ResourceIdentifiers runtimeResourceIds = DesignSessionUtilBase.createRuntimeResourceIdentifiers(designResourceIdentifiers);
        if (runtimeResourceIds == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> designSessionAppContext = new HashMap<String, Object>(1);
        String resourceIdKey = "org.eclipse.datatools.connectivity.oda.util_consumerResourceIds";
        designSessionAppContext.put(resourceIdKey, runtimeResourceIds);
        return designSessionAppContext;
    }

    static DataSetUIElement getDataSetUIElement(String odaDataSourceId, String odaDataSetId) throws OdaException {
        DataSetUIElement dataSetElement = UIManifestExplorer.getInstance().getDataSetUIElement(odaDataSourceId, odaDataSetId);
        if (dataSetElement == null) {
            throw new OdaException(Messages.bind((String)Messages.designSession_missingDataSetUIElement, (Object)odaDataSourceId, (Object)odaDataSetId));
        }
        return dataSetElement;
    }

    protected static String validateRequestSessionImpl(DesignSessionRequest requestSession) throws OdaException {
        String odaDataSourceId = null;
        try {
            odaDataSourceId = DesignUtil.validateRequestSession((DesignSessionRequest)requestSession);
        }
        catch (IllegalStateException ex) {
            throw new OdaException((Throwable)ex);
        }
        return odaDataSourceId;
    }

    protected static void validateDataSourceDesignImpl(DataSourceDesign dataSourceDesign) throws OdaException {
        try {
            DesignUtil.validateDataSourceDesign((DataSourceDesign)dataSourceDesign);
        }
        catch (IllegalStateException ex) {
            throw new OdaException((Throwable)ex);
        }
    }

    protected static DesignSessionRequest createNewDataSourceRequest(String odaDataSourceId, String newDataSourceName, String newDataSourceDisplayName, URI applResourceBaseURI, URI designResourceBaseURI) throws OdaException {
        if (odaDataSourceId == null || odaDataSourceId.length() == 0 || newDataSourceName == null || newDataSourceName.length() == 0) {
            throw new OdaException(Messages.designSession_invalidArgument);
        }
        DataSourceDesign newDesign = DesignFactory.eINSTANCE.createDataSourceDesign();
        newDesign.setOdaExtensionId(odaDataSourceId);
        newDesign.setName(newDataSourceName);
        newDesign.setDisplayName(newDataSourceDisplayName);
        DesignSessionUtilBase.setDataSourceResourceIdentifiers(newDesign, applResourceBaseURI, designResourceBaseURI);
        DesignSessionRequest newRequest = DesignFactory.eINSTANCE.createDesignSessionRequest();
        newRequest.setNewDataAccessDesign(newDesign);
        DesignSessionUtilBase.validateRequestSessionImpl(newRequest);
        return newRequest;
    }

    protected static DesignSessionRequest createNewDataSourceProfileRequest(URI applResourceBaseURI, URI designResourceBaseURI) {
        DataSourceDesign newDesign = DesignFactory.eINSTANCE.createDataSourceDesign();
        DesignSessionUtilBase.setDataSourceResourceIdentifiers(newDesign, applResourceBaseURI, designResourceBaseURI);
        DesignSessionRequest newRequest = DesignFactory.eINSTANCE.createDesignSessionRequest();
        newRequest.setNewDataAccessDesign(newDesign);
        return newRequest;
    }

    protected static void setDataSourceResourceIdentifiers(DataSourceDesign dataSourceDesign, URI applResourceBaseURI, URI designResourceBaseURI) {
        if (dataSourceDesign == null) {
            throw new NullPointerException("dataSourceDesign: " + dataSourceDesign);
        }
        ResourceIdentifiers resourceIDs = dataSourceDesign.getHostResourceIdentifiers();
        if (resourceIDs == null) {
            if (applResourceBaseURI == null && designResourceBaseURI == null) {
                return;
            }
            resourceIDs = DesignFactory.eINSTANCE.createResourceIdentifiers();
            dataSourceDesign.setHostResourceIdentifiers(resourceIDs);
        }
        resourceIDs.setApplResourceBaseURI(applResourceBaseURI);
        resourceIDs.setDesignResourceBaseURI(designResourceBaseURI);
    }

    protected static OdaDesignSession createNewDataSetRequestSession(String newDataSetName, String odaDataSetId, DataSourceDesign dataSourceDesign) throws OdaException {
        if (newDataSetName == null || newDataSetName.length() == 0 || dataSourceDesign == null) {
            throw new OdaException(Messages.designSession_invalidArgument);
        }
        OdaDesignSession newSession = DesignFactory.eINSTANCE.createRequestDesignSession(dataSourceDesign);
        DataSetDesign newDataSetDesign = newSession.getRequestDataSetDesign();
        newDataSetDesign.setName(newDataSetName);
        newDataSetDesign.setOdaExtensionDataSetId(odaDataSetId);
        DesignSessionUtilBase.validateRequestSessionImpl(newSession.getRequest());
        return newSession;
    }

    protected static void toElementOptionalAttributes(DataElementAttributes paramAttrs, IParameterMetaData pmd, int i) {
        int count = 1;
        block9: while (count > 0) {
            DesignerLogger logger;
            try {
                switch (count++) {
                    case 1: {
                        paramAttrs.setName(pmd.getParameterName(i));
                        continue block9;
                    }
                    case 2: {
                        paramAttrs.setPrecision(pmd.getPrecision(i));
                        continue block9;
                    }
                    case 3: {
                        paramAttrs.setScale(pmd.getScale(i));
                        continue block9;
                    }
                    case 4: {
                        paramAttrs.setNullability(DesignSessionUtilBase.convertParameterNullability(pmd.isNullable(i)));
                    }
                    default: {
                        return;
                    }
                }
            }
            catch (UnsupportedOperationException ex) {
                ex.printStackTrace();
                logger = DesignerLogger.getInstance();
                logger.info(sm_className, "toElementOptionalAttributes", "The optional metadata attribute " + (count - 1) + " of parameter " + i + " is not available.", ex);
            }
            catch (OdaException odaEx) {
                odaEx.printStackTrace();
                logger = DesignerLogger.getInstance();
                logger.warning(sm_className, "toElementOptionalAttributes", "The optional metadata attribute " + (count - 1) + " of parameter " + i + " is not available.", odaEx);
            }
        }
    }

    protected static ElementNullability convertResultColumnNullability(int columnNullability) {
        ElementNullability toValue;
        switch (columnNullability) {
            case 0: {
                toValue = ElementNullability.NOT_NULLABLE_LITERAL;
                break;
            }
            case 2: {
                toValue = ElementNullability.UNKNOWN_LITERAL;
                break;
            }
            default: {
                toValue = ElementNullability.NULLABLE_LITERAL;
            }
        }
        return toValue;
    }

    protected static ElementNullability convertParameterNullability(int parameterNullability) {
        ElementNullability toValue;
        switch (parameterNullability) {
            case 1: {
                toValue = ElementNullability.NOT_NULLABLE_LITERAL;
                break;
            }
            case 0: {
                toValue = ElementNullability.UNKNOWN_LITERAL;
                break;
            }
            default: {
                toValue = ElementNullability.NULLABLE_LITERAL;
            }
        }
        return toValue;
    }
}

