/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRef;
import org.eclipse.emf.cdo.common.branch.CDOBranchRef;
import org.eclipse.emf.cdo.lm.Baseline;
import org.eclipse.emf.cdo.lm.Change;
import org.eclipse.emf.cdo.lm.Delivery;
import org.eclipse.emf.cdo.lm.Drop;
import org.eclipse.emf.cdo.lm.Impact;
import org.eclipse.emf.cdo.lm.LMPackage;
import org.eclipse.emf.cdo.lm.Module;
import org.eclipse.emf.cdo.lm.Stream;
import org.eclipse.emf.cdo.lm.StreamMode;
import org.eclipse.emf.cdo.lm.impl.FloatingBaselineImpl;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;

public class StreamImpl
extends FloatingBaselineImpl
implements Stream {
    protected static final long START_TIME_STAMP_EDEFAULT = 0L;
    protected static final int MAJOR_VERSION_EDEFAULT = 0;
    protected static final int MINOR_VERSION_EDEFAULT = 1;
    protected static final String CODE_NAME_EDEFAULT = null;
    protected static final Impact ALLOWED_CHANGES_EDEFAULT = Impact.MINOR;
    protected static final StreamMode MODE_EDEFAULT = StreamMode.DEVELOPMENT;
    protected static final CDOBranchRef DEVELOPMENT_BRANCH_EDEFAULT = new CDOBranchRef("/MAIN");
    protected static final CDOBranchRef MAINTENANCE_BRANCH_EDEFAULT = null;
    protected static final long MAINTENANCE_TIME_STAMP_EDEFAULT = 0L;

    protected StreamImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return LMPackage.Literals.STREAM;
    }

    @Override
    public Module getModule() {
        return (Module)this.eDynamicGet(4, (EStructuralFeature)LMPackage.Literals.STREAM__MODULE, true, true);
    }

    public NotificationChain basicSetModule(Module newModule, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newModule, 4, msgs);
        return msgs;
    }

    @Override
    public void setModule(Module newModule) {
        this.eDynamicSet(4, (EStructuralFeature)LMPackage.Literals.STREAM__MODULE, newModule);
    }

    @Override
    public Drop getBase() {
        return (Drop)this.eDynamicGet(5, (EStructuralFeature)LMPackage.Literals.STREAM__BASE, true, true);
    }

    public Drop basicGetBase() {
        return (Drop)this.eDynamicGet(5, (EStructuralFeature)LMPackage.Literals.STREAM__BASE, false, true);
    }

    @Override
    public void setBase(Drop newBase) {
        this.eDynamicSet(5, (EStructuralFeature)LMPackage.Literals.STREAM__BASE, newBase);
    }

    @Override
    public long getBaseTimeStamp() {
        return this.getStartTimeStamp();
    }

    @Override
    public long getStartTimeStamp() {
        return (Long)this.eDynamicGet(6, (EStructuralFeature)LMPackage.Literals.STREAM__START_TIME_STAMP, true, true);
    }

    @Override
    public void setStartTimeStamp(long newStartTimeStamp) {
        this.eDynamicSet(6, (EStructuralFeature)LMPackage.Literals.STREAM__START_TIME_STAMP, newStartTimeStamp);
    }

    @Override
    public int getMajorVersion() {
        return (Integer)this.eDynamicGet(7, (EStructuralFeature)LMPackage.Literals.STREAM__MAJOR_VERSION, true, true);
    }

    @Override
    public void setMajorVersion(int newMajorVersion) {
        this.eDynamicSet(7, (EStructuralFeature)LMPackage.Literals.STREAM__MAJOR_VERSION, newMajorVersion);
    }

    @Override
    public int getMinorVersion() {
        return (Integer)this.eDynamicGet(8, (EStructuralFeature)LMPackage.Literals.STREAM__MINOR_VERSION, true, true);
    }

    @Override
    public void setMinorVersion(int newMinorVersion) {
        this.eDynamicSet(8, (EStructuralFeature)LMPackage.Literals.STREAM__MINOR_VERSION, newMinorVersion);
    }

    @Override
    public String getCodeName() {
        return (String)this.eDynamicGet(9, (EStructuralFeature)LMPackage.Literals.STREAM__CODE_NAME, true, true);
    }

    @Override
    public void setCodeName(String newCodeName) {
        this.eDynamicSet(9, (EStructuralFeature)LMPackage.Literals.STREAM__CODE_NAME, newCodeName);
    }

    @Override
    public Impact getAllowedChanges() {
        return (Impact)((Object)this.eDynamicGet(10, (EStructuralFeature)LMPackage.Literals.STREAM__ALLOWED_CHANGES, true, true));
    }

    @Override
    public void setAllowedChanges(Impact newAllowedChanges) {
        this.eDynamicSet(10, (EStructuralFeature)LMPackage.Literals.STREAM__ALLOWED_CHANGES, (Object)newAllowedChanges);
    }

    @Override
    public EList<Baseline> getContents() {
        return (EList)this.eDynamicGet(14, (EStructuralFeature)LMPackage.Literals.STREAM__CONTENTS, true, true);
    }

    @Override
    public long getMaintenanceTimeStamp() {
        return (Long)this.eDynamicGet(15, (EStructuralFeature)LMPackage.Literals.STREAM__MAINTENANCE_TIME_STAMP, true, true);
    }

    @Override
    public void setMaintenanceTimeStamp(long newMaintenanceTimeStamp) {
        this.eDynamicSet(15, (EStructuralFeature)LMPackage.Literals.STREAM__MAINTENANCE_TIME_STAMP, newMaintenanceTimeStamp);
    }

    @Override
    public int insertContent(Baseline baseline) {
        EList<Baseline> contents = this.getContents();
        int index = Collections.binarySearch(contents, baseline, COMPARATOR);
        if (index < 0) {
            index = -index - 1;
        }
        contents.add(index, (Object)baseline);
        return index;
    }

    @Override
    public CDOBranchPointRef getBranchPoint(long timeStamp) {
        long maintenanceTimeStamp;
        CDOBranchRef maintenanceBranch = this.getMaintenanceBranch();
        if (maintenanceBranch != null && timeStamp >= (maintenanceTimeStamp = this.getMaintenanceTimeStamp())) {
            String maintenanceBranchPath = maintenanceBranch.getBranchPath();
            return new CDOBranchPointRef(maintenanceBranchPath, timeStamp);
        }
        String developmentBranchPath = this.getDevelopmentBranch().getBranchPath();
        return new CDOBranchPointRef(developmentBranchPath, timeStamp);
    }

    @Override
    public EList<Delivery> getDeliveries() {
        BasicEList result = new BasicEList();
        for (Baseline baseline : this.getContents()) {
            if (!(baseline instanceof Change)) continue;
            Change change = (Change)baseline;
            result.addAll(change.getDeliveries());
        }
        return result;
    }

    @Override
    public StreamMode getMode() {
        if (this.isClosed()) {
            return StreamMode.CLOSED;
        }
        if (this.getMaintenanceBranch() != null) {
            return StreamMode.MAINTENANCE;
        }
        return StreamMode.DEVELOPMENT;
    }

    @Override
    public CDOBranchRef getDevelopmentBranch() {
        return (CDOBranchRef)this.eDynamicGet(12, (EStructuralFeature)LMPackage.Literals.STREAM__DEVELOPMENT_BRANCH, true, true);
    }

    @Override
    public void setDevelopmentBranch(CDOBranchRef newDevelopmentBranch) {
        this.eDynamicSet(12, (EStructuralFeature)LMPackage.Literals.STREAM__DEVELOPMENT_BRANCH, newDevelopmentBranch);
    }

    @Override
    public CDOBranchRef getMaintenanceBranch() {
        return (CDOBranchRef)this.eDynamicGet(13, (EStructuralFeature)LMPackage.Literals.STREAM__MAINTENANCE_BRANCH, true, true);
    }

    @Override
    public void setMaintenanceBranch(CDOBranchRef newMaintenanceBranch) {
        this.eDynamicSet(13, (EStructuralFeature)LMPackage.Literals.STREAM__MAINTENANCE_BRANCH, newMaintenanceBranch);
    }

    @Override
    public CDOBranchRef getBranch() {
        CDOBranchRef maintenanceBranch = this.getMaintenanceBranch();
        if (maintenanceBranch != null) {
            return maintenanceBranch;
        }
        return this.getDevelopmentBranch();
    }

    @Override
    public Drop getFirstRelease() {
        if (this.getMaintenanceBranch() != null) {
            EList<Baseline> contents = this.getContents();
            int size = contents.size();
            int i = 0;
            while (i < size) {
                Drop drop;
                Baseline baseline = (Baseline)contents.get(i);
                if (baseline instanceof Drop && (drop = (Drop)baseline).isRelease()) {
                    return drop;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public Drop getLastRelease() {
        if (this.getMaintenanceBranch() != null) {
            EList<Baseline> contents = this.getContents();
            int size = contents.size();
            int i = size - 1;
            while (i >= 0) {
                Drop drop;
                Baseline baseline = (Baseline)contents.get(i);
                if (baseline instanceof Drop && (drop = (Drop)baseline).isRelease()) {
                    return drop;
                }
                --i;
            }
        }
        return null;
    }

    @Override
    public EList<Drop> getReleases() {
        BasicEList result = new BasicEList();
        if (this.getMaintenanceBranch() != null) {
            for (Baseline baseline : this.getContents()) {
                Drop drop;
                if (!(baseline instanceof Drop) || !(drop = (Drop)baseline).isRelease()) continue;
                result.add((Object)drop);
            }
        }
        return result;
    }

    @Override
    public EList<Change> getBasedChanges() {
        BasicEList result = new BasicEList();
        for (Baseline baseline : this.getContents()) {
            Change change;
            if (!(baseline instanceof Change) || (change = (Change)baseline).getBase() != null) continue;
            result.add((Object)change);
        }
        return result;
    }

    @Override
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetModule((Module)otherEnd, msgs);
            }
            case 14: {
                return ((InternalEList)this.getContents()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return this.basicSetModule(null, msgs);
            }
            case 14: {
                return ((InternalEList)this.getContents()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 4: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 4, Module.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 4: {
                return this.getModule();
            }
            case 5: {
                if (resolve) {
                    return this.getBase();
                }
                return this.basicGetBase();
            }
            case 6: {
                return this.getStartTimeStamp();
            }
            case 7: {
                return this.getMajorVersion();
            }
            case 8: {
                return this.getMinorVersion();
            }
            case 9: {
                return this.getCodeName();
            }
            case 10: {
                return this.getAllowedChanges();
            }
            case 11: {
                return this.getMode();
            }
            case 12: {
                return this.getDevelopmentBranch();
            }
            case 13: {
                return this.getMaintenanceBranch();
            }
            case 14: {
                return this.getContents();
            }
            case 15: {
                return this.getMaintenanceTimeStamp();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 4: {
                this.setModule((Module)newValue);
                return;
            }
            case 5: {
                this.setBase((Drop)newValue);
                return;
            }
            case 6: {
                this.setStartTimeStamp((Long)newValue);
                return;
            }
            case 7: {
                this.setMajorVersion((Integer)newValue);
                return;
            }
            case 8: {
                this.setMinorVersion((Integer)newValue);
                return;
            }
            case 9: {
                this.setCodeName((String)newValue);
                return;
            }
            case 10: {
                this.setAllowedChanges((Impact)((Object)newValue));
                return;
            }
            case 12: {
                this.setDevelopmentBranch((CDOBranchRef)newValue);
                return;
            }
            case 13: {
                this.setMaintenanceBranch((CDOBranchRef)newValue);
                return;
            }
            case 14: {
                this.getContents().clear();
                this.getContents().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.setMaintenanceTimeStamp((Long)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 4: {
                this.setModule(null);
                return;
            }
            case 5: {
                this.setBase(null);
                return;
            }
            case 6: {
                this.setStartTimeStamp(0L);
                return;
            }
            case 7: {
                this.setMajorVersion(0);
                return;
            }
            case 8: {
                this.setMinorVersion(1);
                return;
            }
            case 9: {
                this.setCodeName(CODE_NAME_EDEFAULT);
                return;
            }
            case 10: {
                this.setAllowedChanges(ALLOWED_CHANGES_EDEFAULT);
                return;
            }
            case 12: {
                this.setDevelopmentBranch(DEVELOPMENT_BRANCH_EDEFAULT);
                return;
            }
            case 13: {
                this.setMaintenanceBranch(MAINTENANCE_BRANCH_EDEFAULT);
                return;
            }
            case 14: {
                this.getContents().clear();
                return;
            }
            case 15: {
                this.setMaintenanceTimeStamp(0L);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 4: {
                return this.getModule() != null;
            }
            case 5: {
                return this.basicGetBase() != null;
            }
            case 6: {
                return this.getStartTimeStamp() != 0L;
            }
            case 7: {
                return this.getMajorVersion() != 0;
            }
            case 8: {
                return this.getMinorVersion() != 1;
            }
            case 9: {
                return CODE_NAME_EDEFAULT == null ? this.getCodeName() != null : !CODE_NAME_EDEFAULT.equals(this.getCodeName());
            }
            case 10: {
                return this.getAllowedChanges() != ALLOWED_CHANGES_EDEFAULT;
            }
            case 11: {
                return this.getMode() != MODE_EDEFAULT;
            }
            case 12: {
                return DEVELOPMENT_BRANCH_EDEFAULT == null ? this.getDevelopmentBranch() != null : !DEVELOPMENT_BRANCH_EDEFAULT.equals((Object)this.getDevelopmentBranch());
            }
            case 13: {
                return MAINTENANCE_BRANCH_EDEFAULT == null ? this.getMaintenanceBranch() != null : !MAINTENANCE_BRANCH_EDEFAULT.equals((Object)this.getMaintenanceBranch());
            }
            case 14: {
                return !this.getContents().isEmpty();
            }
            case 15: {
                return this.getMaintenanceTimeStamp() != 0L;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 10: {
                return this.insertContent((Baseline)arguments.get(0));
            }
            case 11: {
                return this.getBranchPoint((Long)arguments.get(0));
            }
            case 12: {
                return this.getFirstRelease();
            }
            case 13: {
                return this.getLastRelease();
            }
            case 14: {
                return this.getReleases();
            }
            case 15: {
                return this.getBasedChanges();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public String getName() {
        return String.valueOf(this.getMajorVersion()) + "." + this.getMinorVersion();
    }

    @Override
    public void forEachBaseline(Consumer<Baseline> consumer) {
        for (Baseline baseline : this.getContents()) {
            consumer.accept(baseline);
        }
    }

    @Override
    public Baseline getBaseline(String baselineName) {
        for (Baseline baseline : this.getContents()) {
            if (!Objects.equals(baseline.getName(), baselineName)) continue;
            return baseline;
        }
        return null;
    }

    @Override
    public Delivery getDelivery(Change change) {
        for (Baseline baseline : this.getContents()) {
            Delivery delivery;
            if (!(baseline instanceof Delivery) || (delivery = (Delivery)baseline).getChange() != change) continue;
            return delivery;
        }
        return null;
    }
}

