/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.effect.Blend;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.ColorInput;
import javafx.scene.effect.Effect;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.DotExecutableUtils;
import org.eclipse.gef.dot.internal.DotExtractor;
import org.eclipse.gef.dot.internal.DotFileUtils;
import org.eclipse.gef.dot.internal.DotImport;
import org.eclipse.gef.dot.internal.language.colorlist.ColorList;
import org.eclipse.gef.dot.internal.language.colorlist.WC;
import org.eclipse.gef.dot.internal.ui.DotGraphViewModule;
import org.eclipse.gef.dot.internal.ui.DotUiMessages;
import org.eclipse.gef.dot.internal.ui.conversion.Dot2ZestGraphCopier;
import org.eclipse.gef.dot.internal.ui.conversion.DotColorUtil;
import org.eclipse.gef.dot.internal.ui.language.DotActivator;
import org.eclipse.gef.dot.internal.ui.language.DotActivatorEx;
import org.eclipse.gef.dot.internal.ui.language.editor.DotEditorUtils;
import org.eclipse.gef.dot.internal.ui.preferences.GraphvizPreferencePage;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.zest.fx.parts.GraphPart;
import org.eclipse.gef.zest.fx.ui.ZestFxUiModule;
import org.eclipse.gef.zest.fx.ui.parts.ZestFxUiView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.statushandlers.StatusManager;

public class DotGraphView
extends ZestFxUiView
implements IShowInTarget {
    public static final String STYLES_CSS_FILE = DotGraphView.class.getResource("styles.css").toExternalForm();
    private static final String[] EXTENSIONS = new String[]{"dot", "gv"};
    private static final String GRAPH_NONE = DotUiMessages.DotGraphView_0;
    private boolean listenToDotContent = false;
    private boolean listenToSelectionChanges = false;
    private String currentDot = "digraph{}";
    private File currentFile = null;
    private Link resourceLabel = null;
    @Inject
    private Dot2ZestGraphCopier dot2ZestGraphCopier;
    private IPropertyChangeListener preferenceChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("dotpath")) {
                DotGraphView.this.updateGraph(DotGraphView.this.currentFile);
            }
        }
    };
    private LinkWithDotEditorAction linkWithDotEditorAction;
    private LinkWithSelectionAction linkWithSelectionAction;
    private LoadFileAction loadFileAction;

    public DotGraphView() {
        super(Guice.createInjector((Module[])new Module[]{Modules.override((Module[])new Module[]{new DotGraphViewModule()}).with(new Module[]{new ZestFxUiModule()})}));
    }

    protected void activate() {
        super.activate();
        List importDot = new DotImport().importDot(this.currentDot);
        this.setGraph(importDot.isEmpty() ? null : (Graph)importDot.get(0));
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        DotActivatorEx.dotUiPreferenceStore().addPropertyChangeListener(this.preferenceChangeListener);
    }

    protected boolean isNativeMode() {
        return GraphvizPreferencePage.isGraphvizConfigured();
    }

    public void dispose() {
        DotActivatorEx.dotUiPreferenceStore().removePropertyChangeListener(this.preferenceChangeListener);
        this.currentDot = null;
        this.currentFile = null;
        this.getContentViewer().contentsProperty().clear();
        super.dispose();
    }

    protected void disposeActions() {
        this.linkWithDotEditorAction.dispose();
        this.linkWithSelectionAction.dispose();
        this.loadFileAction.dispose();
        super.disposeActions();
    }

    protected void createActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager mgr = actionBars.getToolBarManager();
        this.linkWithDotEditorAction = new LinkWithDotEditorAction();
        this.linkWithSelectionAction = new LinkWithSelectionAction();
        this.loadFileAction = new LoadFileAction();
        mgr.add((IAction)this.linkWithDotEditorAction);
        mgr.add((IAction)this.linkWithSelectionAction);
        mgr.add((IAction)this.loadFileAction);
        mgr.add((IContributionItem)new Separator());
        super.createActions();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        parent.setLayout((Layout)new GridLayout(1, true));
        this.initResourceLabel(parent);
        this.getCanvas().setLayoutData((Object)new GridData(1808));
        Scene scene = this.getContentViewer().getCanvas().getScene();
        scene.getStylesheets().add((Object)STYLES_CSS_FILE);
    }

    private void initResourceLabel(Composite parent) {
        this.resourceLabel = new Link(parent, 64);
        this.resourceLabel.setText(GRAPH_NONE);
        this.resourceLabel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                this.processEvent(GRAPH_NONE, e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.processEvent(GRAPH_NONE, e);
            }

            private void processEvent(String label, SelectionEvent e) {
                if (label.replaceAll("<a>", "").startsWith(e.text)) {
                    DotGraphView.this.loadFileAction.run();
                } else {
                    DotGraphView.this.linkWithDotEditorAction.setChecked(!DotGraphView.this.linkWithDotEditorAction.isChecked());
                    DotGraphView.this.linkWithDotEditorAction.run();
                }
            }
        });
        this.resourceLabel.setLayoutData((Object)new GridData(768));
    }

    private ImageDescriptor determineImageDescriptor(String imageName) {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(imageName);
    }

    private void setGraphAsync(final String dot, final File file) {
        this.getViewSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!dot.trim().isEmpty()) {
                    try {
                        List importDot = new DotImport().importDot(dot);
                        DotGraphView.this.setGraph(importDot.isEmpty() ? null : (Graph)importDot.get(0));
                    }
                    catch (Exception e) {
                        MultiStatus status = this.createMultiStatus(e.getLocalizedMessage(), e);
                        int style = 3;
                        StatusManager.getManager().handle((IStatus)status, style);
                        return;
                    }
                    if (!DotGraphView.this.resourceLabel.isDisposed()) {
                        DotGraphView.this.resourceLabel.setText(String.valueOf(String.format(DotUiMessages.DotGraphView_4, file.getName())) + (DotGraphView.this.isNativeMode() ? " [native]" : " [emulated]"));
                        DotGraphView.this.resourceLabel.setToolTipText(file.getAbsolutePath());
                    }
                }
            }

            private MultiStatus createMultiStatus(String localizedMessage, Throwable t) {
                ArrayList<Status> childStatuses = new ArrayList<Status>();
                String pluginId = DotActivator.getInstance().getBundle().getSymbolicName();
                Status status = new Status(4, pluginId, dot);
                childStatuses.add(status);
                MultiStatus ms = new MultiStatus(pluginId, 4, (IStatus[])childStatuses.toArray(new Status[0]), t.toString(), t);
                return ms;
            }
        });
    }

    public void setGraph(Graph graph) {
        if (this.getDomain() == null) {
            return;
        }
        boolean isNativeMode = this.isNativeMode();
        this.dot2ZestGraphCopier.getAttributeCopier().options().emulateLayout = !isNativeMode;
        this.dot2ZestGraphCopier.getAttributeCopier().options().invertYAxis = false;
        super.setGraph(this.dot2ZestGraphCopier.copy(graph));
        DotColorUtil colorUtil = new DotColorUtil();
        ColorList bgcolorList = DotAttributes.getBgcolorParsed((Graph)graph);
        Color backgroundColor = null;
        if (bgcolorList != null && bgcolorList.getColorValues() != null && bgcolorList.getColorValues().size() > 0) {
            backgroundColor = colorUtil.computeGraphBackgroundColor(DotAttributes.getColorscheme((Graph)graph), ((WC)bgcolorList.getColorValues().get(0)).getColor());
        }
        if (backgroundColor != null) {
            this.addGraphBackground((Paint)backgroundColor);
        } else {
            this.removeGraphBackground();
        }
    }

    private void removeGraphBackground() {
        GraphPart graphPart = (GraphPart)this.getContentViewer().getRootPart().getContentPartChildren().get(0);
        Group group = (Group)graphPart.getVisual();
        group.setEffect(null);
    }

    private void addGraphBackground(Paint paint) {
        double margin = 5.0;
        GraphPart graphPart = (GraphPart)this.getContentViewer().getRootPart().getContentPartChildren().get(0);
        Group group = (Group)graphPart.getVisual();
        Bounds bounds = group.getLayoutBounds();
        group.setEffect((Effect)new Blend(BlendMode.SRC_OVER, (Effect)new ColorInput(bounds.getMinX() - margin, bounds.getMinY() - margin, bounds.getWidth() + 2.0 * margin, bounds.getHeight() + 2.0 * margin, paint), null));
    }

    private boolean toggle(Action action, boolean input) {
        action.setChecked(!action.isChecked());
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        IContributionItem[] iContributionItemArray = mgr.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && ((ActionContributionItem)item).getAction() == action) {
                action.setChecked(!action.isChecked());
                return !input;
            }
            ++n2;
        }
        return input;
    }

    private boolean updateGraph(IFile file) {
        URI locationURI;
        if (file != null && (locationURI = file.getLocationURI()) != null) {
            URL url = null;
            try {
                url = locationURI.toURL();
            }
            catch (MalformedURLException e) {
                DotActivatorEx.logError(e);
                return false;
            }
            if (url != null) {
                File dotFile = DotFileUtils.resolve((URL)url);
                return this.updateGraph(dotFile);
            }
        }
        return false;
    }

    private boolean updateGraph(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        this.currentFile = file;
        boolean isEmbeddedDotFile = !this.hasDotFileExtension(this.currentFile.getName());
        DotExtractor dotExtractor = null;
        if (isEmbeddedDotFile) {
            dotExtractor = new DotExtractor(this.currentFile);
            this.currentDot = dotExtractor.getDotString();
        } else {
            this.currentDot = DotFileUtils.read((File)this.currentFile);
        }
        if (this.isNativeMode()) {
            String[] result;
            if (isEmbeddedDotFile) {
                File tempDotFile = dotExtractor.getDotTempFile();
                if (tempDotFile == null) {
                    return false;
                }
                result = DotExecutableUtils.executeDot((File)new File(GraphvizPreferencePage.getDotExecutablePath()), (boolean)true, (File)tempDotFile, null, null);
                tempDotFile.delete();
            } else {
                result = DotExecutableUtils.executeDot((File)new File(GraphvizPreferencePage.getDotExecutablePath()), (boolean)true, (File)file, null, null);
            }
            this.currentDot = result[0];
        }
        this.setGraphAsync(this.currentDot, this.currentFile);
        return true;
    }

    private IWorkspaceRunnable updateGraphRunnable(final File f) {
        if (!this.listenToDotContent && !this.hasDotFileExtension(f.getAbsolutePath().toString())) {
            return null;
        }
        IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (DotGraphView.this.updateGraph(f)) {
                    DotGraphView.this.currentFile = f;
                }
            }
        };
        return workspaceRunnable;
    }

    public boolean show(ShowInContext context) {
        Object input = context.getInput();
        ISelection selection = context.getSelection();
        if (input instanceof File) {
            File dotFile = (File)input;
            return this.updateGraph(dotFile);
        }
        if (input instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)input;
            IFile dotFile = fileEditorInput.getFile();
            return this.updateGraph(dotFile);
        }
        if (selection instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)selection;
            Object firstElement = treeSelection.getFirstElement();
            IFile dotFile = (IFile)Platform.getAdapterManager().getAdapter(firstElement, IFile.class);
            this.updateGraph(dotFile);
        }
        return false;
    }

    private boolean hasDotFileExtension(String fileName) {
        return fileName.toLowerCase(Locale.ENGLISH).matches(String.format(".*\\.(%s)\\Z", String.join((CharSequence)"|", EXTENSIONS).toLowerCase(Locale.ENGLISH)));
    }

    private class LinkWithDotEditorAction
    extends Action {
        private IResourceChangeListener resourceChangeListener;
        private IResourceDeltaVisitor resourceVisitor;
        private ISelectionListener selectionChangeListener;

        public LinkWithDotEditorAction() {
            super(DotUiMessages.DotGraphView_1, 2);
            this.resourceChangeListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    if (event.getType() != 16 && event.getType() != 1) {
                        return;
                    }
                    IResourceDelta rootDelta = event.getDelta();
                    try {
                        rootDelta.accept(LinkWithDotEditorAction.this.resourceVisitor);
                    }
                    catch (CoreException e) {
                        DotActivatorEx.logError((Exception)((Object)e));
                    }
                }
            };
            this.resourceVisitor = new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) {
                    IResource resource = delta.getResource();
                    if (resource.getType() == 1 && DotGraphView.this.hasDotFileExtension(((IFile)resource).getName())) {
                        try {
                            IFile f = (IFile)resource;
                            IWorkspaceRunnable workspaceRunnable = DotGraphView.this.updateGraphRunnable(DotFileUtils.resolve((URL)f.getLocationURI().toURL()));
                            IWorkspace workspace = ResourcesPlugin.getWorkspace();
                            if (!workspace.isTreeLocked()) {
                                workspace.run(workspaceRunnable, null);
                            }
                        }
                        catch (Exception e) {
                            DotActivatorEx.logError(e);
                        }
                    }
                    return true;
                }
            };
            this.selectionChangeListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    LinkWithDotEditorAction.this.checkActiveEditorAndUpdateGraph(part);
                }
            };
            this.setId(this.getText());
            this.setImageDescriptor(DotGraphView.this.determineImageDescriptor("IMG_ELCL_SYNCED"));
        }

        public void run() {
            DotGraphView.this.listenToDotContent = DotGraphView.this.toggle(this, DotGraphView.this.listenToDotContent);
            this.toggleResourceListener();
        }

        public void dispose() {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
            DotGraphView.this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionChangeListener);
        }

        private void toggleResourceListener() {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            ISelectionService service = DotGraphView.this.getSite().getWorkbenchWindow().getSelectionService();
            if (DotGraphView.this.listenToDotContent) {
                IEditorPart activeEditor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                this.checkActiveEditorAndUpdateGraph((IWorkbenchPart)activeEditor);
                workspace.addResourceChangeListener(this.resourceChangeListener, 17);
                service.addSelectionListener(this.selectionChangeListener);
            } else {
                workspace.removeResourceChangeListener(this.resourceChangeListener);
                service.removeSelectionListener(this.selectionChangeListener);
            }
        }

        private void checkActiveEditorAndUpdateGraph(IWorkbenchPart part) {
            IEditorInput editorInput;
            if (DotEditorUtils.isDotEditor(part) && (editorInput = ((EditorPart)part).getEditorInput()) instanceof FileEditorInput) {
                IFile file = ((FileEditorInput)editorInput).getFile();
                try {
                    File resolvedFile = DotFileUtils.resolve((URL)file.getLocationURI().toURL());
                    if (!resolvedFile.equals(DotGraphView.this.currentFile)) {
                        DotGraphView.this.updateGraph(resolvedFile);
                    }
                }
                catch (MalformedURLException e) {
                    DotActivatorEx.logError(e);
                }
            }
        }
    }

    private class LinkWithSelectionAction
    extends Action {
        private ISelectionListener listener;

        public LinkWithSelectionAction() {
            super(DotUiMessages.DotGraphView_2, 2);
            this.listener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    if (!DotGraphView.this.listenToSelectionChanges) {
                        return;
                    }
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    IStructuredSelection structured = (IStructuredSelection)selection;
                    if (structured.size() != 1) {
                        return;
                    }
                    Object selected = structured.getFirstElement();
                    IFile file = (IFile)Platform.getAdapterManager().getAdapter(selected, IFile.class);
                    DotGraphView.this.updateGraph(file);
                }
            };
            this.setId(this.getText());
            this.setImageDescriptor(DotGraphView.this.determineImageDescriptor("IMG_ELCL_SYNCED"));
        }

        public void run() {
            DotGraphView.this.listenToSelectionChanges = DotGraphView.this.toggle(this, DotGraphView.this.listenToSelectionChanges);
            this.toggleSelectionChangeListener();
        }

        private void toggleSelectionChangeListener() {
            if (DotGraphView.this.listenToSelectionChanges) {
                this.addSelectionChangeListener();
            } else {
                this.removeSelectionChangeListener();
            }
        }

        private void addSelectionChangeListener() {
            this.getSelectionService().addSelectionListener(this.listener);
        }

        private void removeSelectionChangeListener() {
            this.getSelectionService().removeSelectionListener(this.listener);
        }

        private ISelectionService getSelectionService() {
            return DotGraphView.this.getSite().getWorkbenchWindow().getSelectionService();
        }

        public void dispose() {
            this.removeSelectionChangeListener();
        }
    }

    private class LoadFileAction
    extends Action {
        private String lastSelection;

        public LoadFileAction() {
            super(DotUiMessages.DotGraphView_3, DotGraphView.this.determineImageDescriptor("IMG_OBJ_FILE"));
            this.lastSelection = null;
            this.setId(this.getText());
        }

        public void run() {
            FileDialog dialog = new FileDialog(DotGraphView.this.getViewSite().getShell(), 4096);
            dialog.setFileName(this.lastSelection);
            String[] filterSuffixPattern = new String[EXTENSIONS.length + 1];
            String[] filterReadableName = new String[EXTENSIONS.length + 1];
            filterSuffixPattern[0] = "*.*";
            filterReadableName[0] = String.format("Embedded DOT Graph (%s)", filterSuffixPattern[0]);
            int i = 1;
            while (i <= EXTENSIONS.length) {
                String suffix = EXTENSIONS[i - 1];
                filterSuffixPattern[i] = "*." + suffix;
                filterReadableName[i] = String.format(Locale.ENGLISH, "%S file (%s)", suffix, filterSuffixPattern[i]);
                ++i;
            }
            dialog.setFilterExtensions(filterSuffixPattern);
            dialog.setFilterNames(filterReadableName);
            String selection = dialog.open();
            if (selection != null) {
                this.lastSelection = selection;
                DotGraphView.this.updateGraph(new File(selection));
            }
        }

        public void dispose() {
        }
    }
}

