/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.preferences;

import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.mylyn.internal.wikitext.ui.WikiTextUiPlugin;
import org.eclipse.mylyn.internal.wikitext.ui.editor.preferences.CssStyleFieldEditor;
import org.eclipse.mylyn.internal.wikitext.ui.editor.preferences.Messages;
import org.eclipse.mylyn.internal.wikitext.ui.editor.preferences.Preferences;
import org.eclipse.mylyn.internal.wikitext.ui.editor.preferences.RegExStringFieldEditor;
import org.eclipse.mylyn.internal.wikitext.ui.viewer.CssStyleManager;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class EditorPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public EditorPreferencePage() {
        super(1);
        this.setPreferenceStore(WikiTextUiPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.EditorPreferencePage_introInfo);
    }

    public Control createContents(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768){

            public Point computeSize(int hint, int hint2, boolean changed) {
                return new Point(64, 64);
            }
        };
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Composite body = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)body);
        GridLayoutFactory.fillDefaults().margins(0, 0).numColumns(1).applyTo(body);
        Control contents = super.createContents(body);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(contents);
        scrolledComposite.setMinSize(body.computeSize(-1, -1, true));
        return scrolledComposite;
    }

    public void createFieldEditors() {
        Preferences prefs = new Preferences();
        Layout fieldEditorParentLayout = this.getFieldEditorParent().getLayout();
        Layout layout = fieldEditorParentLayout;
        if (layout instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout;
            GridLayout cfr_ignored_0 = (GridLayout)layout;
            layout.marginRight = 5;
        }
        Group openModeGroup = new Group(this.getFieldEditorParent(), 0);
        openModeGroup.setText(Messages.EditorPreferencePage_openMode);
        openModeGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        this.addField((FieldEditor)new RegExStringFieldEditor("openAsPreviewNamePattern", Messages.EditorPreferencePage_openInPreview, (Composite)openModeGroup));
        Group blockGroup = new Group(this.getFieldEditorParent(), 0);
        blockGroup.setText(Messages.EditorPreferencePage_blockModifiers);
        blockGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        CssStyleManager cssStyleManager = new CssStyleManager(this.getFont());
        for (Map.Entry<String, String> ent : prefs.getCssByBlockModifierType().entrySet()) {
            String preferenceKey = Preferences.toPreferenceKey(ent.getKey(), true);
            this.addField((FieldEditor)new CssStyleFieldEditor(cssStyleManager, preferenceKey, ent.getKey(), (Composite)blockGroup));
        }
        Layout layout2 = blockGroup.getLayout();
        Layout layout3 = layout2;
        if (layout3 instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout3;
            GridLayout cfr_ignored_1 = (GridLayout)layout3;
            gridLayout.marginWidth = 5;
            gridLayout.marginHeight = 5;
        }
        Group phraseModifierGroup = new Group(this.getFieldEditorParent(), 0);
        phraseModifierGroup.setText(Messages.EditorPreferencePage_phraseModifiers);
        phraseModifierGroup.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        for (Map.Entry<String, String> entry : prefs.getCssByPhraseModifierType().entrySet()) {
            String preferenceKey = Preferences.toPreferenceKey(entry.getKey(), false);
            this.addField((FieldEditor)new CssStyleFieldEditor(cssStyleManager, preferenceKey, entry.getKey(), (Composite)phraseModifierGroup));
        }
        layout2 = phraseModifierGroup.getLayout();
        Layout layout4 = layout2;
        if (layout4 instanceof GridLayout) {
            GridLayout gridLayout = (GridLayout)layout4;
            GridLayout cfr_ignored_2 = (GridLayout)layout4;
            gridLayout.marginWidth = 5;
            gridLayout.marginHeight = 5;
        }
        this.applyDialogFont(this.getFieldEditorParent());
        openModeGroup.setFont(this.getFieldEditorParent().getFont());
        blockGroup.setFont(this.getFieldEditorParent().getFont());
        phraseModifierGroup.setFont(this.getFieldEditorParent().getFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.mylyn.wikitext.help.ui.preferences");
    }

    public void init(IWorkbench workbench) {
    }
}

